/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AnonymousFunctionNamingCallback;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CodePrinter;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NameGenerator;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.VariableMap;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class NameAnonymousFunctionsMapped
implements CompilerPass {
    private static Logger logger = Logger.getLogger(NameAnonymousFunctionsMapped.class.getName());
    private final AbstractCompiler compiler;
    private final NameGenerator nameGenerator;
    private final Map<String, String> renameMap;
    private int namedCount = 0;
    private int bytesUsed = 0;

    NameAnonymousFunctionsMapped(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.nameGenerator = new NameGenerator(Collections.<String>emptySet(), "$", null);
        this.renameMap = Maps.newHashMap();
    }

    @Override
    public void process(Node externs, Node root) {
        AnonymousFunctionNamingCallback namingCallback = new AnonymousFunctionNamingCallback(new MappedFunctionNamer());
        NodeTraversal.traverse(this.compiler, root, namingCallback);
        logger.fine("Named " + this.namedCount + " anon functions using " + this.bytesUsed + " bytes");
        if (this.namedCount > 0) {
            this.compiler.reportCodeChange();
        }
    }

    VariableMap getFunctionMap() {
        return new VariableMap(this.renameMap);
    }

    private class MappedFunctionNamer
    implements AnonymousFunctionNamingCallback.FunctionNamer {
        private MappedFunctionNamer() {
        }

        @Override
        public final String getName(Node node) {
            switch (node.getType()) {
                case 38: 
                case 40: {
                    return node.getString();
                }
            }
            return new CodePrinter.Builder(node).build();
        }

        @Override
        public final void setFunctionName(String name, Node fnNode) {
            Node fnNameNode = fnNode.getFirstChild();
            String newName = (String)NameAnonymousFunctionsMapped.this.renameMap.get(name);
            if (newName == null) {
                newName = NameAnonymousFunctionsMapped.this.nameGenerator.generateNextName();
                NameAnonymousFunctionsMapped.this.renameMap.put(name, newName);
            }
            fnNameNode.setString(newName);
            NameAnonymousFunctionsMapped.this.namedCount++;
            NameAnonymousFunctionsMapped.this.bytesUsed += newName.length();
        }

        @Override
        public final String getCombinedName(String lhs, String rhs) {
            return lhs + '.' + rhs;
        }
    }
}

