/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.collect.Lists;
import closurecompiler.internal.com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSModule;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class MoveFunctionDeclarations
implements CompilerPass,
NodeTraversal.Callback {
    private final AbstractCompiler compiler;
    private final Map<JSModule, List<Node>> functions;

    MoveFunctionDeclarations(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.functions = Maps.newHashMap();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
        for (Map.Entry<JSModule, List<Node>> entry : this.functions.entrySet()) {
            JSModule module = entry.getKey();
            Node addingRoot = this.compiler.getNodeForCodeInsertion(module);
            for (Node n : Lists.reverse(entry.getValue())) {
                addingRoot.addChildToFront(n);
            }
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        Node gramps = n.getAncestor(2);
        return gramps == null || !gramps.isScript();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (parent == null || !parent.isScript()) {
            return;
        }
        if (NodeUtil.isFunctionDeclaration(n)) {
            parent.removeChild(n);
            this.compiler.reportCodeChange();
            JSModule module = t.getModule();
            List<Node> moduleFunctions = this.functions.get(module);
            if (moduleFunctions == null) {
                moduleFunctions = Lists.newArrayList();
                this.functions.put(module, moduleFunctions);
            }
            moduleFunctions.add(n);
        }
    }
}

