/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.ImmutableList;
import closurecompiler.internal.com.google.common.collect.ImmutableSet;
import closurecompiler.internal.com.google.common.collect.Iterables;
import closurecompiler.internal.com.google.common.collect.Lists;
import closurecompiler.internal.com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.Scope;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.ScopeCreator;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.StaticSymbolTable;

class MemoizedScopeCreator
implements ScopeCreator,
StaticSymbolTable<Scope.Var, Scope.Var> {
    private final Map<Node, Scope> scopes = Maps.newHashMap();
    private final ScopeCreator delegate;

    MemoizedScopeCreator(ScopeCreator delegate) {
        this.delegate = delegate;
    }

    @Override
    public Iterable<Scope.Var> getReferences(Scope.Var var) {
        return ImmutableList.of(var);
    }

    public Scope getScope(Scope.Var var) {
        return var.scope;
    }

    @Override
    public Iterable<Scope.Var> getAllSymbols() {
        ArrayList<Scope.Var> vars = Lists.newArrayList();
        for (Scope s : this.scopes.values()) {
            Iterables.addAll(vars, s.getAllSymbols());
        }
        return vars;
    }

    @Override
    public Scope createScope(Node n, Scope parent) {
        Scope scope = this.scopes.get(n);
        if (scope == null) {
            scope = this.delegate.createScope(n, parent);
            this.scopes.put(n, scope);
        } else {
            Preconditions.checkState(parent == scope.getParent());
        }
        return scope;
    }

    Collection<Scope> getAllMemoizedScopes() {
        return Collections.unmodifiableCollection(this.scopes.values());
    }

    void removeScopesForScript(String scriptName) {
        for (Node scopeRoot : ImmutableSet.copyOf(this.scopes.keySet())) {
            if (!scriptName.equals(scopeRoot.getSourceFileName())) continue;
            this.scopes.remove(scopeRoot);
        }
    }
}

