/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.HashMultimap;
import closurecompiler.internal.com.google.common.collect.Multimap;
import closurecompiler.internal.com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.ControlFlowGraph;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DataFlowAnalysis;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JoinOp;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.LatticeElement;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.Scope;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.graph.GraphNode;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class MaybeReachingVariableUse
extends DataFlowAnalysis<Node, ReachingUses> {
    private final Scope jsScope;
    private final Set<Scope.Var> escaped;

    MaybeReachingVariableUse(ControlFlowGraph<Node> cfg, Scope jsScope, AbstractCompiler compiler) {
        super(cfg, new ReachingUsesJoinOp());
        this.jsScope = jsScope;
        this.escaped = Sets.newHashSet();
        MaybeReachingVariableUse.computeEscaped(jsScope, this.escaped, compiler);
    }

    @Override
    boolean isForward() {
        return false;
    }

    @Override
    ReachingUses createEntryLattice() {
        return new ReachingUses();
    }

    @Override
    ReachingUses createInitialEstimateLattice() {
        return new ReachingUses();
    }

    @Override
    ReachingUses flowThrough(Node n, ReachingUses input) {
        ReachingUses output = new ReachingUses(input);
        this.computeMayUse(n, n, output, false);
        return output;
    }

    private void computeMayUse(Node n, Node cfgNode, ReachingUses output, boolean conditional) {
        switch (n.getType()) {
            case 105: 
            case 125: {
                return;
            }
            case 38: {
                this.addToUseIfLocal(n.getString(), cfgNode, output);
                return;
            }
            case 108: 
            case 113: 
            case 114: {
                this.computeMayUse(NodeUtil.getConditionExpression(n), cfgNode, output, conditional);
                return;
            }
            case 115: {
                if (!NodeUtil.isForIn(n)) {
                    this.computeMayUse(NodeUtil.getConditionExpression(n), cfgNode, output, conditional);
                } else {
                    Node lhs = n.getFirstChild();
                    Node rhs = lhs.getNext();
                    if (lhs.isVar()) {
                        lhs = lhs.getLastChild();
                    }
                    if (lhs.isName() && !conditional) {
                        this.removeFromUseIfLocal(lhs.getString(), output);
                    }
                    this.computeMayUse(rhs, cfgNode, output, conditional);
                }
                return;
            }
            case 100: 
            case 101: {
                this.computeMayUse(n.getLastChild(), cfgNode, output, true);
                this.computeMayUse(n.getFirstChild(), cfgNode, output, conditional);
                return;
            }
            case 98: {
                this.computeMayUse(n.getLastChild(), cfgNode, output, true);
                this.computeMayUse(n.getFirstChild().getNext(), cfgNode, output, true);
                this.computeMayUse(n.getFirstChild(), cfgNode, output, conditional);
                return;
            }
            case 118: {
                Node varName = n.getFirstChild();
                Preconditions.checkState(n.hasChildren(), "AST should be normalized");
                if (varName.hasChildren()) {
                    this.computeMayUse(varName.getFirstChild(), cfgNode, output, conditional);
                    if (!conditional) {
                        this.removeFromUseIfLocal(varName.getString(), output);
                    }
                }
                return;
            }
        }
        if (NodeUtil.isAssignmentOp(n) && n.getFirstChild().isName()) {
            Node name = n.getFirstChild();
            if (!conditional) {
                this.removeFromUseIfLocal(name.getString(), output);
            }
            if (!n.isAssign()) {
                this.addToUseIfLocal(name.getString(), cfgNode, output);
            }
            this.computeMayUse(name.getNext(), cfgNode, output, conditional);
        } else {
            Node c = n.getLastChild();
            while (c != null) {
                this.computeMayUse(c, cfgNode, output, conditional);
                c = n.getChildBefore(c);
            }
        }
    }

    private void addToUseIfLocal(String name, Node node, ReachingUses use) {
        Scope.Var var = this.jsScope.getVar(name);
        if (var == null || var.scope != this.jsScope) {
            return;
        }
        if (!this.escaped.contains(var)) {
            use.mayUseMap.put(var, node);
        }
    }

    private void removeFromUseIfLocal(String name, ReachingUses use) {
        Scope.Var var = this.jsScope.getVar(name);
        if (var == null || var.scope != this.jsScope) {
            return;
        }
        if (!this.escaped.contains(var)) {
            use.mayUseMap.removeAll(var);
        }
    }

    Collection<Node> getUses(String name, Node defNode) {
        GraphNode n = this.getCfg().getNode(defNode);
        Preconditions.checkNotNull(n);
        DataFlowAnalysis.FlowState state = (DataFlowAnalysis.FlowState)n.getAnnotation();
        return ((ReachingUses)state.getOut()).mayUseMap.get(this.jsScope.getVar(name));
    }

    private static class ReachingUsesJoinOp
    implements JoinOp<ReachingUses> {
        private ReachingUsesJoinOp() {
        }

        @Override
        public ReachingUses apply(List<ReachingUses> from) {
            ReachingUses result = new ReachingUses();
            for (ReachingUses uses : from) {
                result.mayUseMap.putAll(uses.mayUseMap);
            }
            return result;
        }
    }

    static final class ReachingUses
    implements LatticeElement {
        final Multimap<Scope.Var, Node> mayUseMap;

        public ReachingUses() {
            this.mayUseMap = HashMultimap.create();
        }

        public ReachingUses(ReachingUses other) {
            this.mayUseMap = HashMultimap.create(other.mayUseMap);
        }

        public boolean equals(Object other) {
            return other instanceof ReachingUses && ((ReachingUses)other).mayUseMap.equals(this.mayUseMap);
        }

        public int hashCode() {
            return this.mayUseMap.hashCode();
        }
    }
}

