/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.Sets;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.ControlFlowGraph;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DataFlowAnalysis;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JoinOp;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.LatticeElement;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.Scope;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.graph.DiGraph;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class LiveVariablesAnalysis
extends DataFlowAnalysis<Node, LiveVariableLattice> {
    public static final String ARGUMENT_ARRAY_ALIAS = "arguments";
    private final Scope jsScope;
    private final Set<Scope.Var> escaped;

    LiveVariablesAnalysis(ControlFlowGraph<Node> cfg, Scope jsScope, AbstractCompiler compiler) {
        super(cfg, new LiveVariableJoinOp());
        this.jsScope = jsScope;
        this.escaped = Sets.newHashSet();
        LiveVariablesAnalysis.computeEscaped(jsScope, this.escaped, compiler);
    }

    public Set<Scope.Var> getEscapedLocals() {
        return this.escaped;
    }

    public int getVarIndex(String var) {
        return this.jsScope.getVar((String)var).index;
    }

    @Override
    boolean isForward() {
        return false;
    }

    @Override
    LiveVariableLattice createEntryLattice() {
        return new LiveVariableLattice(this.jsScope.getVarCount());
    }

    @Override
    LiveVariableLattice createInitialEstimateLattice() {
        return new LiveVariableLattice(this.jsScope.getVarCount());
    }

    @Override
    LiveVariableLattice flowThrough(Node node, LiveVariableLattice input) {
        BitSet gen = new BitSet(input.liveSet.size());
        BitSet kill = new BitSet(input.liveSet.size());
        boolean conditional = false;
        List edgeList = this.getCfg().getOutEdges(node);
        for (DiGraph.DiGraphEdge edge : edgeList) {
            if (!ControlFlowGraph.Branch.ON_EX.equals(edge.getValue())) continue;
            conditional = true;
        }
        this.computeGenKill(node, gen, kill, conditional);
        LiveVariableLattice result = new LiveVariableLattice(input);
        result.liveSet.andNot(kill);
        result.liveSet.or(gen);
        return result;
    }

    private void computeGenKill(Node n, BitSet gen, BitSet kill, boolean conditional) {
        switch (n.getType()) {
            case 105: 
            case 125: 
            case 132: {
                return;
            }
            case 108: 
            case 113: 
            case 114: {
                this.computeGenKill(NodeUtil.getConditionExpression(n), gen, kill, conditional);
                return;
            }
            case 115: {
                if (!NodeUtil.isForIn(n)) {
                    this.computeGenKill(NodeUtil.getConditionExpression(n), gen, kill, conditional);
                } else {
                    Node lhs = n.getFirstChild();
                    Node rhs = lhs.getNext();
                    if (lhs.isVar()) {
                        lhs = lhs.getLastChild();
                    }
                    if (lhs.isName()) {
                        this.addToSetIfLocal(lhs, kill);
                        this.addToSetIfLocal(lhs, gen);
                    } else {
                        this.computeGenKill(lhs, gen, kill, conditional);
                    }
                    this.computeGenKill(rhs, gen, kill, conditional);
                }
                return;
            }
            case 118: {
                for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                    if (!c.hasChildren()) continue;
                    this.computeGenKill(c.getFirstChild(), gen, kill, conditional);
                    if (conditional) continue;
                    this.addToSetIfLocal(c, kill);
                }
                return;
            }
            case 100: 
            case 101: {
                this.computeGenKill(n.getFirstChild(), gen, kill, conditional);
                this.computeGenKill(n.getLastChild(), gen, kill, true);
                return;
            }
            case 98: {
                this.computeGenKill(n.getFirstChild(), gen, kill, conditional);
                this.computeGenKill(n.getFirstChild().getNext(), gen, kill, true);
                this.computeGenKill(n.getLastChild(), gen, kill, true);
                return;
            }
            case 38: {
                if (this.isArgumentsName(n)) {
                    this.markAllParametersEscaped();
                } else {
                    this.addToSetIfLocal(n, gen);
                }
                return;
            }
        }
        if (NodeUtil.isAssignmentOp(n) && n.getFirstChild().isName()) {
            Node lhs = n.getFirstChild();
            if (!conditional) {
                this.addToSetIfLocal(lhs, kill);
            }
            if (!n.isAssign()) {
                this.addToSetIfLocal(lhs, gen);
            }
            this.computeGenKill(lhs.getNext(), gen, kill, conditional);
        } else {
            for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                this.computeGenKill(c, gen, kill, conditional);
            }
        }
    }

    private void addToSetIfLocal(Node node, BitSet set) {
        Preconditions.checkState(node.isName());
        String name = node.getString();
        if (!this.jsScope.isDeclared(name, false)) {
            return;
        }
        Scope.Var var = this.jsScope.getVar(name);
        if (!this.escaped.contains(var)) {
            set.set(var.index);
        }
    }

    void markAllParametersEscaped() {
        Node lp = this.jsScope.getRootNode().getFirstChild().getNext();
        for (Node arg = lp.getFirstChild(); arg != null; arg = arg.getNext()) {
            this.escaped.add(this.jsScope.getVar(arg.getString()));
        }
    }

    private boolean isArgumentsName(Node n) {
        return n.isName() && n.getString().equals(ARGUMENT_ARRAY_ALIAS) && !this.jsScope.isDeclared(ARGUMENT_ARRAY_ALIAS, false);
    }

    static class LiveVariableLattice
    implements LatticeElement {
        private final BitSet liveSet;

        private LiveVariableLattice(int numVars) {
            this.liveSet = new BitSet(numVars);
        }

        private LiveVariableLattice(LiveVariableLattice other) {
            Preconditions.checkNotNull(other);
            this.liveSet = (BitSet)other.liveSet.clone();
        }

        public boolean equals(Object other) {
            Preconditions.checkNotNull(other);
            return other instanceof LiveVariableLattice && this.liveSet.equals(((LiveVariableLattice)other).liveSet);
        }

        public boolean isLive(Scope.Var v) {
            Preconditions.checkNotNull(v);
            return this.liveSet.get(v.index);
        }

        public boolean isLive(int index) {
            return this.liveSet.get(index);
        }

        public String toString() {
            return this.liveSet.toString();
        }

        public int hashCode() {
            return this.liveSet.hashCode();
        }
    }

    private static class LiveVariableJoinOp
    implements JoinOp<LiveVariableLattice> {
        private LiveVariableJoinOp() {
        }

        @Override
        public LiveVariableLattice apply(List<LiveVariableLattice> in) {
            LiveVariableLattice result = new LiveVariableLattice(in.get(0));
            for (int i = 1; i < in.size(); ++i) {
                result.liveSet.or(in.get(i).liveSet);
            }
            return result;
        }
    }
}

