/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DiagnosticType;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class LineNumberCheck
implements CompilerPass,
NodeTraversal.Callback {
    static final DiagnosticType MISSING_LINE_INFO = DiagnosticType.error("JSC_MISSING_LINE_INFO", "No source location information associated with {0}.\nMost likely a Node has been created with settings the source file and line/column location.  Usually this is done using Node.copyInformationFrom and supplying a Node from the source AST.");
    private final AbstractCompiler compiler;
    private boolean requiresLineNumbers;

    public void setCheckSubTree(Node root) {
        this.requiresLineNumbers = true;
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void process(Node externs, Node root) {
        this.requiresLineNumbers = false;
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isScript()) {
            this.requiresLineNumbers = true;
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isScript()) {
            this.requiresLineNumbers = false;
        } else if (this.requiresLineNumbers && n.getLineno() == -1) {
            this.compiler.report(t.makeError(n, MISSING_LINE_INFO, n.toStringTree()));
        }
    }
}

