/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.base.Strings;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractMessageFormatter;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CheckLevel;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSError;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.Region;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.SourceExcerptProvider;

public class LightweightMessageFormatter
extends AbstractMessageFormatter {
    private SourceExcerptProvider.SourceExcerpt excerpt;
    private static final SourceExcerptProvider.ExcerptFormatter excerptFormatter = new LineNumberingFormatter();

    private LightweightMessageFormatter() {
        super(null);
        this.excerpt = SourceExcerptProvider.SourceExcerpt.LINE;
    }

    public LightweightMessageFormatter(SourceExcerptProvider source) {
        this(source, SourceExcerptProvider.SourceExcerpt.LINE);
    }

    public LightweightMessageFormatter(SourceExcerptProvider source, SourceExcerptProvider.SourceExcerpt excerpt) {
        super(source);
        Preconditions.checkNotNull(source);
        this.excerpt = excerpt;
    }

    static LightweightMessageFormatter withoutSource() {
        return new LightweightMessageFormatter();
    }

    @Override
    public String formatError(JSError error) {
        return this.format(error, false);
    }

    @Override
    public String formatWarning(JSError warning) {
        return this.format(warning, true);
    }

    private String format(JSError error, boolean warning) {
        SourceExcerptProvider source = this.getSource();
        String sourceExcerpt = source == null ? null : this.excerpt.get(source, error.sourceName, error.lineNumber, excerptFormatter);
        StringBuilder b = new StringBuilder();
        if (error.sourceName != null) {
            b.append(error.sourceName);
            if (error.lineNumber > 0) {
                b.append(':');
                b.append(error.lineNumber);
            }
            b.append(": ");
        }
        b.append(this.getLevelName(warning ? CheckLevel.WARNING : CheckLevel.ERROR));
        b.append(" - ");
        b.append(error.description);
        b.append('\n');
        if (sourceExcerpt != null) {
            b.append(sourceExcerpt);
            b.append('\n');
            int charno = error.getCharno();
            if (this.excerpt.equals((Object)SourceExcerptProvider.SourceExcerpt.LINE) && 0 <= charno && charno <= sourceExcerpt.length()) {
                for (int i = 0; i < charno; ++i) {
                    char c = sourceExcerpt.charAt(i);
                    if (Character.isWhitespace(c)) {
                        b.append(c);
                        continue;
                    }
                    b.append(' ');
                }
                b.append("^\n");
            }
        }
        return b.toString();
    }

    static class LineNumberingFormatter
    implements SourceExcerptProvider.ExcerptFormatter {
        LineNumberingFormatter() {
        }

        @Override
        public String formatLine(String line, int lineNumber) {
            return line;
        }

        @Override
        public String formatRegion(Region region) {
            if (region == null) {
                return null;
            }
            String code = region.getSourceExcerpt();
            if (code.length() == 0) {
                return null;
            }
            int numberLength = Integer.toString(region.getEndingLineNumber()).length();
            StringBuilder builder = new StringBuilder(code.length() * 2);
            int start = 0;
            int end = code.indexOf(10, start);
            int lineNumber = region.getBeginningLineNumber();
            while (start >= 0) {
                String line;
                if (end < 0) {
                    line = code.substring(start);
                    if (line.length() == 0) {
                        return builder.substring(0, builder.length() - 1);
                    }
                } else {
                    line = code.substring(start, end);
                }
                builder.append("  ");
                int spaces = numberLength - Integer.toString(lineNumber).length();
                builder.append(Strings.repeat(" ", spaces));
                builder.append(lineNumber);
                builder.append("| ");
                if (end < 0) {
                    builder.append(line);
                    start = -1;
                    continue;
                }
                builder.append(line);
                builder.append('\n');
                start = end + 1;
                end = code.indexOf(10, start);
                ++lineNumber;
            }
            return builder.toString();
        }
    }
}

