/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.logging.Logger;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSError;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.SourceAst;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.SourceFile;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.parsing.ParserRunner;
import org.jetbrains.jet.internal.com.google.javascript.rhino.IR;
import org.jetbrains.jet.internal.com.google.javascript.rhino.InputId;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

public class JsAst
implements SourceAst {
    private static final Logger logger_ = Logger.getLogger(JsAst.class.getName());
    private transient InputId inputId;
    private transient SourceFile sourceFile;
    private String fileName;
    private Node root;

    public JsAst(SourceFile sourceFile) {
        this.inputId = new InputId(sourceFile.getName());
        this.sourceFile = sourceFile;
        this.fileName = sourceFile.getName();
    }

    @Override
    public Node getAstRoot(AbstractCompiler compiler) {
        if (this.root == null) {
            this.parse(compiler);
            this.root.setInputId(this.inputId);
        }
        return this.root;
    }

    @Override
    public void clearAst() {
        this.root = null;
        this.sourceFile.clearCachedSource();
    }

    @Override
    public InputId getInputId() {
        return this.inputId;
    }

    @Override
    public SourceFile getSourceFile() {
        return this.sourceFile;
    }

    @Override
    public void setSourceFile(SourceFile file) {
        Preconditions.checkState(this.fileName.equals(file.getName()));
        this.sourceFile = file;
    }

    private void parse(AbstractCompiler compiler) {
        try {
            logger_.fine("Parsing: " + this.sourceFile.getName());
            this.root = ParserRunner.parse(this.sourceFile, this.sourceFile.getCode(), compiler.getParserConfig(), compiler.getDefaultErrorReporter(), logger_);
        }
        catch (IOException e) {
            compiler.report(JSError.make(AbstractCompiler.READ_ERROR, this.sourceFile.getName()));
        }
        if (this.root == null || compiler.hasHaltingErrors()) {
            this.root = IR.script(new Node[0]);
        } else {
            compiler.prepareAst(this.root);
        }
        this.root.setStaticSourceFile(this.sourceFile);
    }
}

