/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CodingConvention;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CodingConventions;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

public class JqueryCodingConvention
extends CodingConventions.Proxy {
    private final Set<String> propertyTestFunctions = ImmutableSet.of("jQuery.isPlainObject", "jQuery.isFunction", "jQuery.isNumeric", "jQuery.isEmptyObject");
    private final Set<String> prototypeAliases = ImmutableSet.of("jQuery.fn", "jQuerySub.fn");

    public JqueryCodingConvention() {
        this(CodingConventions.getDefault());
    }

    public JqueryCodingConvention(CodingConvention wrapped) {
        super(wrapped);
    }

    @Override
    public String getGlobalObject() {
        return "window";
    }

    @Override
    public boolean isPropertyTestFunction(Node call) {
        Preconditions.checkArgument(call.isCall());
        return this.propertyTestFunctions.contains(call.getFirstChild().getQualifiedName());
    }

    @Override
    public boolean isPrototypeAlias(Node n) {
        if (n.isGetProp()) {
            if (n.isName() || n.isGetProp() || n.isGetElem()) {
                return !NodeUtil.isLValue(n) && this.prototypeAliases.contains(n.getQualifiedName());
            }
            return this.prototypeAliases.contains(n.getQualifiedName());
        }
        return false;
    }
}

