/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.ImmutableList;
import closurecompiler.internal.com.google.common.collect.Iterables;
import closurecompiler.internal.com.google.common.collect.LinkedHashMultimap;
import closurecompiler.internal.com.google.common.collect.LinkedListMultimap;
import closurecompiler.internal.com.google.common.collect.Lists;
import closurecompiler.internal.com.google.common.collect.Maps;
import closurecompiler.internal.com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerInput;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DependencyOptions;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSModule;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.deps.SortedDependencies;

public class JSModuleGraph {
    private List<JSModule> modules;
    private List<List<JSModule>> modulesByDepth;
    private Map<JSModule, Set<JSModule>> dependencyMap = Maps.newHashMap();

    public JSModuleGraph(JSModule[] modulesInDepOrder) {
        this(ImmutableList.copyOf(modulesInDepOrder));
    }

    public JSModuleGraph(List<JSModule> modulesInDepOrder) {
        Preconditions.checkState(modulesInDepOrder.size() == Sets.newHashSet(modulesInDepOrder).size(), "Found duplicate modules");
        this.modules = ImmutableList.copyOf(modulesInDepOrder);
        this.modulesByDepth = Lists.newArrayList();
        for (JSModule module : modulesInDepOrder) {
            int depth = 0;
            for (JSModule dep : module.getDependencies()) {
                int depDepth = dep.getDepth();
                if (depDepth < 0) {
                    throw new ModuleDependenceException(String.format("Modules not in dependency order: %s preceded %s", module.getName(), dep.getName()), module, dep);
                }
                depth = Math.max(depth, depDepth + 1);
            }
            module.setDepth(depth);
            if (depth == this.modulesByDepth.size()) {
                this.modulesByDepth.add(new ArrayList());
            }
            this.modulesByDepth.get(depth).add(module);
        }
    }

    Iterable<JSModule> getAllModules() {
        return this.modules;
    }

    int getModuleCount() {
        return this.modules.size();
    }

    JSModule getRootModule() {
        return (JSModule)Iterables.getOnlyElement((Iterable)this.modulesByDepth.get(0));
    }

    public boolean dependsOn(JSModule src, JSModule m) {
        Set<JSModule> deps = this.dependencyMap.get(src);
        if (deps == null) {
            deps = this.getTransitiveDepsDeepestFirst(src);
            this.dependencyMap.put(src, deps);
        }
        return deps.contains(m);
    }

    JSModule getDeepestCommonDependency(JSModule m1, JSModule m2) {
        int m1Depth = m1.getDepth();
        int m2Depth = m2.getDepth();
        for (int depth = Math.min(m1Depth, m2Depth) - 1; depth >= 0; --depth) {
            List<JSModule> modulesAtDepth = this.modulesByDepth.get(depth);
            for (int i = modulesAtDepth.size() - 1; i >= 0; --i) {
                JSModule m = modulesAtDepth.get(i);
                if (!this.dependsOn(m1, m) || !this.dependsOn(m2, m)) continue;
                return m;
            }
        }
        return null;
    }

    public JSModule getDeepestCommonDependencyInclusive(JSModule m1, JSModule m2) {
        if (m2 == m1 || this.dependsOn(m2, m1)) {
            return m1;
        }
        if (this.dependsOn(m1, m2)) {
            return m2;
        }
        return this.getDeepestCommonDependency(m1, m2);
    }

    public JSModule getDeepestCommonDependencyInclusive(Collection<JSModule> modules) {
        Iterator<JSModule> iter = modules.iterator();
        JSModule dep = iter.next();
        while (iter.hasNext()) {
            dep = this.getDeepestCommonDependencyInclusive(dep, iter.next());
        }
        return dep;
    }

    Set<JSModule> getTransitiveDepsDeepestFirst(JSModule m) {
        Set<JSModule> deps = this.dependencyMap.get(m);
        if (deps != null) {
            return deps;
        }
        deps = new TreeSet<JSModule>(new InverseDepthComparator());
        this.addDeps(deps, m);
        this.dependencyMap.put(m, deps);
        return deps;
    }

    private void addDeps(Set<JSModule> deps, JSModule m) {
        for (JSModule dep : m.getDependencies()) {
            deps.add(dep);
            this.addDeps(deps, dep);
        }
    }

    public void coalesceDuplicateFiles() {
        LinkedHashMultimap<String, JSModule> fileRefs = LinkedHashMultimap.create();
        for (JSModule module : this.modules) {
            for (CompilerInput jsFile : module.getInputs()) {
                fileRefs.put(jsFile.getName(), module);
            }
        }
        for (String path : fileRefs.keySet()) {
            Collection<JSModule> refModules = fileRefs.get(path);
            if (refModules.size() <= 1) continue;
            JSModule depModule = this.getDeepestCommonDependencyInclusive(refModules);
            CompilerInput file = refModules.iterator().next().getByName(path);
            for (JSModule module : refModules) {
                if (module == depModule) continue;
                module.removeByName(path);
            }
            if (refModules.contains(depModule)) continue;
            depModule.add(file);
        }
    }

    public List<CompilerInput> manageDependencies(List<String> entryPoints, List<CompilerInput> inputs) throws SortedDependencies.CircularDependencyException, SortedDependencies.MissingProvideException {
        DependencyOptions depOptions = new DependencyOptions();
        depOptions.setDependencySorting(true);
        depOptions.setDependencyPruning(true);
        depOptions.setEntryPoints(entryPoints);
        return this.manageDependencies(depOptions, inputs);
    }

    public List<CompilerInput> manageDependencies(DependencyOptions depOptions, List<CompilerInput> inputs) throws SortedDependencies.CircularDependencyException, SortedDependencies.MissingProvideException {
        JSModule module3;
        SortedDependencies<CompilerInput> sorter = new SortedDependencies<CompilerInput>(inputs);
        LinkedHashSet<CompilerInput> entryPointInputs = Sets.newLinkedHashSet();
        if (depOptions.shouldPruneDependencies()) {
            if (!depOptions.shouldDropMoochers()) {
                entryPointInputs.addAll(sorter.getInputsWithoutProvides());
            }
            for (String entryPoint : depOptions.getEntryPoints()) {
                entryPointInputs.add(sorter.getInputProviding(entryPoint));
            }
        } else {
            entryPointInputs.addAll(inputs);
        }
        List<CompilerInput> absoluteOrder = sorter.getDependenciesOf(inputs, depOptions.shouldSortDependencies());
        LinkedListMultimap<JSModule, CompilerInput> entryPointInputsPerModule = LinkedListMultimap.create();
        for (CompilerInput input : entryPointInputs) {
            module3 = input.getModule();
            Preconditions.checkNotNull(module3);
            entryPointInputsPerModule.put(module3, input);
        }
        for (JSModule module2 : this.getAllModules()) {
            module2.removeAll();
        }
        for (JSModule module2 : entryPointInputsPerModule.keySet()) {
            List<CompilerInput> transitiveClosure = sorter.getDependenciesOf(entryPointInputsPerModule.get(module2), depOptions.shouldSortDependencies());
            for (CompilerInput input : transitiveClosure) {
                JSModule oldModule = input.getModule();
                if (oldModule == null) {
                    input.setModule(module2);
                    continue;
                }
                input.setModule(null);
                input.setModule(this.getDeepestCommonDependencyInclusive(oldModule, module2));
            }
        }
        for (CompilerInput input : absoluteOrder) {
            module3 = input.getModule();
            if (module3 == null) continue;
            module3.add(input);
        }
        ArrayList<CompilerInput> result = Lists.newArrayList();
        for (JSModule module3 : this.getAllModules()) {
            result.addAll(module3.getInputs());
        }
        return result;
    }

    private int depthCompare(JSModule m1, JSModule m2) {
        int d2;
        if (m1 == m2) {
            return 0;
        }
        int d1 = m1.getDepth();
        return d1 < (d2 = m2.getDepth()) ? -1 : (d2 == d1 ? m1.getName().compareTo(m2.getName()) : 1);
    }

    protected static class ModuleDependenceException
    extends IllegalArgumentException {
        private final JSModule module;
        private final JSModule dependentModule;

        protected ModuleDependenceException(String message, JSModule module, JSModule dependentModule) {
            super(message);
            this.module = module;
            this.dependentModule = dependentModule;
        }

        public JSModule getModule() {
            return this.module;
        }

        public JSModule getDependentModule() {
            return this.dependentModule;
        }
    }

    private class InverseDepthComparator
    implements Comparator<JSModule> {
        private InverseDepthComparator() {
        }

        @Override
        public int compare(JSModule m1, JSModule m2) {
            return JSModuleGraph.this.depthCompare(m2, m1);
        }
    }

    private class DepthComparator
    implements Comparator<JSModule> {
        final /* synthetic */ JSModuleGraph this$0;

        @Override
        public int compare(JSModule m1, JSModule m2) {
            return this.this$0.depthCompare(m1, m2);
        }
    }
}

