/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.collect.ImmutableList;
import closurecompiler.internal.com.google.common.collect.Lists;
import closurecompiler.internal.com.google.protobuf.TextFormat;
import java.io.IOException;
import java.util.List;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.ControlFlowAnalysis;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.ControlFlowGraph;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.FunctionNames;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.Instrumentation;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSError;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSModule;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.RhinoErrorReporter;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.graph.DiGraph;
import org.jetbrains.jet.internal.com.google.javascript.rhino.IR;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class InstrumentFunctions
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final FunctionNames functionNames;
    private final String templateFilename;
    private final String appNameStr;
    private final String initCodeSource;
    private final String definedFunctionName;
    private final String reportFunctionName;
    private final String reportFunctionExitName;
    private final String appNameSetter;
    private final List<String> declarationsToRemove;

    InstrumentFunctions(AbstractCompiler compiler, FunctionNames functionNames, String templateFilename, String appNameStr, Readable readable) {
        this.compiler = compiler;
        this.functionNames = functionNames;
        this.templateFilename = templateFilename;
        this.appNameStr = appNameStr;
        Instrumentation.Builder builder = Instrumentation.newBuilder();
        try {
            TextFormat.merge(readable, builder);
        }
        catch (IOException e) {
            compiler.report(JSError.make(RhinoErrorReporter.PARSE_ERROR, "Error reading instrumentation template protobuf at " + templateFilename));
            this.initCodeSource = "";
            this.definedFunctionName = "";
            this.reportFunctionName = "";
            this.reportFunctionExitName = "";
            this.appNameSetter = "";
            this.declarationsToRemove = Lists.newArrayList();
            return;
        }
        Instrumentation template = builder.build();
        StringBuilder initCodeSourceBuilder = new StringBuilder();
        for (String line : template.getInitList()) {
            initCodeSourceBuilder.append(line).append("\n");
        }
        this.initCodeSource = initCodeSourceBuilder.toString();
        this.definedFunctionName = template.getReportDefined();
        this.reportFunctionName = template.getReportCall();
        this.reportFunctionExitName = template.getReportExit();
        this.appNameSetter = template.getAppNameSetter();
        this.declarationsToRemove = ImmutableList.copyOf(template.getDeclarationToRemoveList());
    }

    @Override
    public void process(Node externs, Node root) {
        Node initCode = null;
        if (!this.initCodeSource.isEmpty()) {
            Node initCodeRoot = this.compiler.parseSyntheticCode(this.templateFilename + ":init", this.initCodeSource);
            if (initCodeRoot != null && initCodeRoot.getFirstChild() != null) {
                initCode = initCodeRoot.removeChildren();
            } else {
                return;
            }
        }
        NodeTraversal.traverse(this.compiler, root, new RemoveCallback(this.declarationsToRemove));
        NodeTraversal.traverse(this.compiler, root, new InstrumentCallback());
        if (!this.appNameSetter.isEmpty()) {
            Node call = IR.call(IR.name(this.appNameSetter), IR.string(this.appNameStr));
            call.putBooleanProp(50, true);
            Node expr = IR.exprResult(call);
            Node addingRoot = this.compiler.getNodeForCodeInsertion(null);
            addingRoot.addChildrenToFront(expr);
            this.compiler.reportCodeChange();
        }
        if (initCode != null) {
            Node addingRoot = this.compiler.getNodeForCodeInsertion(null);
            addingRoot.addChildrenToFront(initCode);
            this.compiler.reportCodeChange();
        }
    }

    private class InstrumentCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private InstrumentCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            Node body;
            if (!n.isFunction()) {
                return;
            }
            int id = InstrumentFunctions.this.functionNames.getFunctionId(n);
            if (id < 0) {
                return;
            }
            if (!InstrumentFunctions.this.reportFunctionName.isEmpty()) {
                body = n.getFirstChild().getNext().getNext();
                Node call = IR.call(IR.name(InstrumentFunctions.this.reportFunctionName), IR.number(id));
                call.putBooleanProp(50, true);
                Node expr = IR.exprResult(call);
                body.addChildToFront(expr);
                InstrumentFunctions.this.compiler.reportCodeChange();
            }
            if (!InstrumentFunctions.this.reportFunctionExitName.isEmpty()) {
                body = n.getFirstChild().getNext().getNext();
                new InstrumentReturns(id).process(body);
            }
            if (!InstrumentFunctions.this.definedFunctionName.isEmpty()) {
                Node call = IR.call(IR.name(InstrumentFunctions.this.definedFunctionName), IR.number(id));
                call.putBooleanProp(50, true);
                Node expr = NodeUtil.newExpr(call);
                Node addingRoot = null;
                if (NodeUtil.isFunctionDeclaration(n)) {
                    JSModule module = t.getModule();
                    addingRoot = InstrumentFunctions.this.compiler.getNodeForCodeInsertion(module);
                    addingRoot.addChildToFront(expr);
                } else {
                    Node beforeChild = n;
                    for (Node ancestor : n.getAncestors()) {
                        int type = ancestor.getType();
                        if (type == 125 || type == 132) {
                            addingRoot = ancestor;
                            break;
                        }
                        beforeChild = ancestor;
                    }
                    addingRoot.addChildBefore(expr, beforeChild);
                }
                InstrumentFunctions.this.compiler.reportCodeChange();
            }
        }
    }

    private class InstrumentReturns
    implements NodeTraversal.Callback {
        private final int functionId;

        InstrumentReturns(int functionId) {
            this.functionId = functionId;
        }

        void process(Node body) {
            NodeTraversal.traverse(InstrumentFunctions.this.compiler, body, this);
            if (!this.allPathsReturn(body)) {
                Node call = this.newReportFunctionExitNode();
                Node expr = IR.exprResult(call);
                body.addChildToBack(expr);
                InstrumentFunctions.this.compiler.reportCodeChange();
            }
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return !n.isFunction();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!n.isReturn()) {
                return;
            }
            Node call = this.newReportFunctionExitNode();
            Node returnRhs = n.removeFirstChild();
            if (returnRhs != null) {
                call.addChildToBack(returnRhs);
            }
            n.addChildToFront(call);
            InstrumentFunctions.this.compiler.reportCodeChange();
        }

        private Node newReportFunctionExitNode() {
            Node call = IR.call(IR.name(InstrumentFunctions.this.reportFunctionExitName), IR.number(this.functionId));
            call.putBooleanProp(50, true);
            return call;
        }

        private boolean allPathsReturn(Node block) {
            ControlFlowAnalysis cfa = new ControlFlowAnalysis(InstrumentFunctions.this.compiler, false, false);
            cfa.process(null, block);
            ControlFlowGraph<Node> cfg = cfa.getCfg();
            Node returnPathsParent = (Node)cfg.getImplicitReturn().getValue();
            for (DiGraph.DiGraphNode pred : cfg.getDirectedPredNodes(returnPathsParent)) {
                Node n = (Node)pred.getValue();
                if (n.isReturn()) continue;
                return false;
            }
            return true;
        }
    }

    private static class RemoveCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private final List<String> removable;

        RemoveCallback(List<String> removable) {
            this.removable = removable;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (NodeUtil.isVarDeclaration(n) && this.removable.contains(n.getString())) {
                parent.removeChild(n);
                if (!parent.hasChildren()) {
                    parent.getParent().removeChild(parent);
                }
            }
        }
    }
}

