/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import java.util.regex.Pattern;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.ClosureCodingConvention;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CodingConvention;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CodingConventions;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

public class GoogleCodingConvention
extends CodingConventions.Proxy {
    private static final Pattern ENUM_KEY_PATTERN = Pattern.compile("[A-Z0-9][A-Z0-9_]*");

    public GoogleCodingConvention() {
        this(new ClosureCodingConvention());
    }

    public GoogleCodingConvention(CodingConvention convention) {
        super(convention);
    }

    @Override
    public boolean isConstant(String name) {
        if (name.length() <= 1) {
            return false;
        }
        int pos = name.lastIndexOf(36);
        if (pos >= 0 && (name = name.substring(pos + 1)).length() == 0) {
            return false;
        }
        return this.isConstantKey(name);
    }

    @Override
    public boolean isConstantKey(String name) {
        if (name.isEmpty() || !Character.isUpperCase(name.charAt(0))) {
            return false;
        }
        return name.toUpperCase().equals(name);
    }

    @Override
    public boolean isValidEnumKey(String key) {
        return ENUM_KEY_PATTERN.matcher(key).matches();
    }

    @Override
    public boolean isOptionalParameter(Node parameter) {
        return parameter.getString().startsWith("opt_");
    }

    @Override
    public boolean isVarArgsParameter(Node parameter) {
        return "var_args".equals(parameter.getString());
    }

    @Override
    public boolean isExported(String name, boolean local) {
        return super.isExported(name, local) || !local && name.startsWith("_");
    }

    @Override
    public boolean isPrivate(String name) {
        return name.endsWith("_") && !this.isExported(name);
    }
}

