/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.ImmutableSet;
import closurecompiler.internal.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CodingConvention;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.rhino.IR;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Token;

class GatherSideEffectSubexpressionsCallback
implements NodeTraversal.Callback {
    private static final Set<Integer> FORBIDDEN_TYPES = ImmutableSet.of(Integer.valueOf(125), Integer.valueOf(132), Integer.valueOf(118), Integer.valueOf(130), Integer.valueOf(4));
    private final AbstractCompiler compiler;
    private final SideEffectAccumulator accumulator;

    GatherSideEffectSubexpressionsCallback(AbstractCompiler compiler, SideEffectAccumulator accumulator) {
        this.compiler = compiler;
        this.accumulator = accumulator;
    }

    private boolean isClassDefiningCall(Node callNode) {
        CodingConvention.SubclassRelationship classes = this.compiler.getCodingConvention().getClassesDefinedByCall(callNode);
        return classes != null;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal traversal, Node node, Node parent) {
        if (FORBIDDEN_TYPES.contains(node.getType()) || NodeUtil.isControlStructure(node)) {
            throw new IllegalArgumentException(Token.name(node.getType()) + " nodes are not supported.");
        }
        if (node.isFunction()) {
            return false;
        }
        if (node.isHook()) {
            return this.processHook(node);
        }
        if (node.isAnd() || node.isOr()) {
            return this.processShortCircuitExpression(node);
        }
        if (!NodeUtil.nodeTypeMayHaveSideEffects(node)) {
            return true;
        }
        if (node.isCall()) {
            return this.processFunctionCall(node);
        }
        if (node.isNew()) {
            return this.processConstructorCall(node);
        }
        this.accumulator.keepSubTree(node);
        return false;
    }

    boolean processShortCircuitExpression(Node node) {
        Preconditions.checkArgument(node.isAnd() || node.isOr(), "Expected: AND or OR, Got: %s", Token.name(node.getType()));
        Node left = node.getFirstChild();
        Node right = left.getNext();
        if (NodeUtil.mayHaveSideEffects(right)) {
            this.accumulator.keepSimplifiedShortCircuitExpression(node);
            return false;
        }
        return true;
    }

    boolean processHook(Node node) {
        Preconditions.checkArgument(node.isHook(), "Expected: HOOK, Got: %s", Token.name(node.getType()));
        Node condition = node.getFirstChild();
        Node ifBranch = condition.getNext();
        Node elseBranch = ifBranch.getNext();
        boolean thenHasSideEffects = NodeUtil.mayHaveSideEffects(ifBranch);
        boolean elseHasSideEffects = NodeUtil.mayHaveSideEffects(elseBranch);
        if (thenHasSideEffects || elseHasSideEffects) {
            this.accumulator.keepSimplifiedHookExpression(node, thenHasSideEffects, elseHasSideEffects);
            return false;
        }
        return true;
    }

    boolean processFunctionCall(Node node) {
        Preconditions.checkArgument(node.isCall(), "Expected: CALL, Got: %s", Token.name(node.getType()));
        Node functionName = node.getFirstChild();
        if ((functionName.isName() || functionName.isGetProp()) && !this.accumulator.classDefiningCallsHaveSideEffects() && this.isClassDefiningCall(node)) {
            return true;
        }
        if (!NodeUtil.functionCallHasSideEffects(node)) {
            return true;
        }
        this.accumulator.keepSubTree(node);
        return false;
    }

    boolean processConstructorCall(Node node) {
        Preconditions.checkArgument(node.isNew(), "Expected: NEW, Got: %s", Token.name(node.getType()));
        if (!NodeUtil.constructorCallHasSideEffects(node)) {
            return true;
        }
        this.accumulator.keepSubTree(node);
        return false;
    }

    @Override
    public void visit(NodeTraversal traversal, Node node, Node parent) {
    }

    static final class CopySideEffectSubexpressions
    implements SideEffectAccumulator {
        private final AbstractCompiler compiler;
        private final List<Node> replacements;

        CopySideEffectSubexpressions(AbstractCompiler compiler, List<Node> replacements) {
            this.compiler = compiler;
            this.replacements = replacements;
        }

        @Override
        public boolean classDefiningCallsHaveSideEffects() {
            return true;
        }

        @Override
        public void keepSubTree(Node original) {
            this.replacements.add(original.cloneTree());
        }

        @Override
        public void keepSimplifiedShortCircuitExpression(Node original) {
            Preconditions.checkArgument(original.isAnd() || original.isOr(), "Expected: AND or OR, Got: %s", Token.name(original.getType()));
            Node left = original.getFirstChild();
            Node right = left.getNext();
            Node simplifiedRight = this.simplifyShortCircuitBranch(right);
            Node simplified = original.cloneNode();
            simplified.addChildToBack(left.cloneTree());
            simplified.addChildToBack(simplifiedRight);
            this.replacements.add(simplified);
        }

        @Override
        public void keepSimplifiedHookExpression(Node hook, boolean thenHasSideEffects, boolean elseHasSideEffects) {
            Preconditions.checkArgument(hook.isHook(), "Expected: HOOK, Got: %s", Token.name(hook.getType()));
            Node condition = hook.getFirstChild();
            Node thenBranch = condition.getNext();
            Node elseBranch = thenBranch.getNext();
            if (thenHasSideEffects && elseHasSideEffects) {
                Node simplified = hook.cloneNode();
                simplified.addChildToBack(condition.cloneTree());
                simplified.addChildToBack(this.simplifyShortCircuitBranch(thenBranch));
                simplified.addChildToBack(this.simplifyShortCircuitBranch(elseBranch));
                this.replacements.add(simplified);
            } else if (thenHasSideEffects || elseHasSideEffects) {
                int type = thenHasSideEffects ? 101 : 100;
                Node body = thenHasSideEffects ? thenBranch : elseBranch;
                Node simplified = new Node(type, condition.cloneTree(), this.simplifyShortCircuitBranch(body)).copyInformationFrom(hook);
                this.replacements.add(simplified);
            } else {
                throw new IllegalArgumentException("keepSimplifiedHookExpression must keep at least 1 branch");
            }
        }

        private Node simplifyShortCircuitBranch(Node node) {
            ArrayList<Node> parts = Lists.newArrayList();
            NodeTraversal.traverse(this.compiler, node, new GatherSideEffectSubexpressionsCallback(this.compiler, new CopySideEffectSubexpressions(this.compiler, parts)));
            Node ret = null;
            for (Node part : parts) {
                if (ret != null) {
                    ret = IR.comma(ret, part).srcref(node);
                    continue;
                }
                ret = part;
            }
            if (ret == null) {
                throw new IllegalArgumentException("expected at least one side effect subexpression in short circuit branch.");
            }
            return ret;
        }
    }

    static interface SideEffectAccumulator {
        public boolean classDefiningCallsHaveSideEffects();

        public void keepSubTree(Node var1);

        public void keepSimplifiedShortCircuitExpression(Node var1);

        public void keepSimplifiedHookExpression(Node var1, boolean var2, boolean var3);
    }
}

