/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.Sets;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class GatherRawExports
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Set<String> exportedVariables = Sets.newHashSet();

    GatherRawExports(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState(this.compiler.getLifeCycleStage().isNormalized());
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        Node sibling = n.getNext();
        if (sibling != null && sibling.isString() && NodeUtil.isGet(parent) && this.isGlobalThisObject(t, n)) {
            this.exportedVariables.add(sibling.getString());
        }
    }

    private boolean isGlobalThisObject(NodeTraversal t, Node n) {
        String varName;
        if (n.isThis()) {
            return t.inGlobalScope();
        }
        return n.isName() && (varName = n.getString()).equals("window");
    }

    public Set<String> getExportedVariableNames() {
        return this.exportedVariables;
    }
}

