/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.collect.HashMultimap;
import closurecompiler.internal.com.google.common.collect.ImmutableList;
import closurecompiler.internal.com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.InlineCostEstimator;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.rhino.IR;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Token;

class FunctionRewriter
implements CompilerPass {
    private final AbstractCompiler compiler;

    FunctionRewriter(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        ImmutableList<Reducer> reducers = ImmutableList.of(new ReturnConstantReducer(), new GetterReducer(), new SetterReducer(), new EmptyFunctionReducer(), new IdentityReducer());
        HashMultimap<Reducer, Reduction> reductionMap = HashMultimap.create();
        NodeTraversal.traverse(this.compiler, root, new ReductionGatherer(reducers, reductionMap));
        for (Reducer reducer : reducers) {
            Node helperCode;
            Collection reductions = reductionMap.get(reducer);
            if (reductions.isEmpty() || (helperCode = this.parseHelperCode(reducer)) == null) continue;
            int helperCodeCost = InlineCostEstimator.getCost(helperCode);
            int savings = 0;
            for (Reduction reduction : reductions) {
                savings += reduction.estimateSavings();
            }
            if (savings <= helperCodeCost + 16) continue;
            for (Reduction reduction : reductions) {
                reduction.apply();
            }
            Node addingRoot = this.compiler.getNodeForCodeInsertion(null);
            addingRoot.addChildrenToFront(helperCode);
            this.compiler.reportCodeChange();
        }
    }

    public Node parseHelperCode(Reducer reducer) {
        Node root = this.compiler.parseSyntheticCode(reducer.getClass().toString() + ":helper", reducer.getHelperSource());
        return root != null ? root.removeFirstChild() : null;
    }

    private static boolean isReduceableFunctionExpression(Node n) {
        return NodeUtil.isFunctionExpression(n) && !NodeUtil.isGetOrSetKey(n.getParent());
    }

    private static class SetterReducer
    extends Reducer {
        private SetterReducer() {
        }

        @Override
        public String getHelperSource() {
            return "function JSCompiler_set(JSCompiler_set_name) {  return function(JSCompiler_set_value) {this[JSCompiler_set_name] = JSCompiler_set_value}}";
        }

        @Override
        public Node reduce(Node node) {
            if (!FunctionRewriter.isReduceableFunctionExpression(node)) {
                return node;
            }
            Node propName = this.getSetPropertyName(node);
            if (propName != null) {
                if (!propName.isString()) {
                    throw new IllegalStateException("Expected STRING, got " + Token.name(propName.getType()));
                }
                return this.buildCallNode("JSCompiler_set", propName, node);
            }
            return node;
        }

        private Node getSetPropertyName(Node functionNode) {
            Node rhs;
            Node body = functionNode.getLastChild();
            if (!body.hasOneChild()) {
                return null;
            }
            Node argList = functionNode.getFirstChild().getNext();
            Node paramNode = argList.getFirstChild();
            if (paramNode == null) {
                return null;
            }
            Node statement = body.getFirstChild();
            if (!NodeUtil.isExprAssign(statement)) {
                return null;
            }
            Node assign = statement.getFirstChild();
            Node lhs = assign.getFirstChild();
            if (lhs.isGetProp() && lhs.getFirstChild().isThis() && (rhs = assign.getLastChild()).isName() && rhs.getString().equals(paramNode.getString())) {
                Node propertyName = lhs.getLastChild();
                return propertyName;
            }
            return null;
        }
    }

    private static class GetterReducer
    extends SingleReturnStatementReducer {
        private GetterReducer() {
        }

        @Override
        public String getHelperSource() {
            return "function JSCompiler_get(JSCompiler_get_name) {  return function() {return this[JSCompiler_get_name]}}";
        }

        @Override
        public Node reduce(Node node) {
            if (!FunctionRewriter.isReduceableFunctionExpression(node)) {
                return node;
            }
            Node propName = this.getGetPropertyName(node);
            if (propName != null) {
                if (!propName.isString()) {
                    throw new IllegalStateException("Expected STRING, got " + Token.name(propName.getType()));
                }
                return this.buildCallNode("JSCompiler_get", propName, node);
            }
            return node;
        }

        private Node getGetPropertyName(Node functionNode) {
            Node value = this.maybeGetSingleReturnRValue(functionNode);
            if (value != null && value.isGetProp() && value.getFirstChild().isThis()) {
                return value.getLastChild();
            }
            return null;
        }
    }

    private static class ReturnConstantReducer
    extends SingleReturnStatementReducer {
        private ReturnConstantReducer() {
        }

        @Override
        public String getHelperSource() {
            return "function JSCompiler_returnArg(JSCompiler_returnArg_value) {  return function() {return JSCompiler_returnArg_value}}";
        }

        @Override
        public Node reduce(Node node) {
            if (!FunctionRewriter.isReduceableFunctionExpression(node)) {
                return node;
            }
            Node valueNode = this.getValueNode(node);
            if (valueNode != null) {
                return this.buildCallNode("JSCompiler_returnArg", valueNode, node);
            }
            return node;
        }

        private Node getValueNode(Node functionNode) {
            Node value = this.maybeGetSingleReturnRValue(functionNode);
            if (value != null && NodeUtil.isImmutableValue(value)) {
                return value;
            }
            return null;
        }
    }

    private static class IdentityReducer
    extends SingleReturnStatementReducer {
        private IdentityReducer() {
        }

        @Override
        public String getHelperSource() {
            return "function JSCompiler_identityFn() {  return function(JSCompiler_identityFn_value) {return JSCompiler_identityFn_value}}";
        }

        @Override
        public Node reduce(Node node) {
            if (!FunctionRewriter.isReduceableFunctionExpression(node)) {
                return node;
            }
            if (this.isIdentityFunction(node)) {
                return this.buildCallNode("JSCompiler_identityFn", null, node);
            }
            return node;
        }

        private boolean isIdentityFunction(Node functionNode) {
            Node argList = functionNode.getFirstChild().getNext();
            Node paramNode = argList.getFirstChild();
            if (paramNode == null) {
                return false;
            }
            Node value = this.maybeGetSingleReturnRValue(functionNode);
            return value != null && value.isName() && value.getString().equals(paramNode.getString());
        }
    }

    static abstract class SingleReturnStatementReducer
    extends Reducer {
        SingleReturnStatementReducer() {
        }

        protected final Node maybeGetSingleReturnRValue(Node functionNode) {
            Node body = functionNode.getLastChild();
            if (!body.hasOneChild()) {
                return null;
            }
            Node statement = body.getFirstChild();
            if (statement.isReturn()) {
                return statement.getFirstChild();
            }
            return null;
        }
    }

    private static class EmptyFunctionReducer
    extends Reducer {
        private EmptyFunctionReducer() {
        }

        @Override
        public String getHelperSource() {
            return "function JSCompiler_emptyFn() {  return function() {}}";
        }

        @Override
        public Node reduce(Node node) {
            if (NodeUtil.isEmptyFunctionExpression(node)) {
                return this.buildCallNode("JSCompiler_emptyFn", null, node);
            }
            return node;
        }
    }

    static abstract class Reducer {
        Reducer() {
        }

        abstract String getHelperSource();

        abstract Node reduce(Node var1);

        protected final Node buildCallNode(String methodName, Node argumentNode, Node srcref) {
            Node call = IR.call(IR.name(methodName), new Node[0]).srcref(srcref);
            call.putBooleanProp(50, true);
            if (argumentNode != null) {
                call.addChildToBack(argumentNode.cloneTree());
            }
            return call;
        }
    }

    private class ReductionGatherer
    implements NodeTraversal.Callback {
        private final List<Reducer> reducers;
        private final Multimap<Reducer, Reduction> reductions;

        ReductionGatherer(List<Reducer> reducers, Multimap<Reducer, Reduction> reductions) {
            this.reducers = reducers;
            this.reductions = reductions;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal raversal, Node node, Node parent) {
            for (Reducer reducer : this.reducers) {
                Node replacement = reducer.reduce(node);
                if (replacement == node) continue;
                this.reductions.put(reducer, new Reduction(parent, node, replacement));
                return false;
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal traversal, Node node, Node parent) {
        }
    }

    private class Reduction {
        private final Node parent;
        private final Node oldChild;
        private final Node newChild;

        Reduction(Node parent, Node oldChild, Node newChild) {
            this.parent = parent;
            this.oldChild = oldChild;
            this.newChild = newChild;
        }

        void apply() {
            this.parent.replaceChild(this.oldChild, this.newChild);
            FunctionRewriter.this.compiler.reportCodeChange();
        }

        int estimateSavings() {
            return InlineCostEstimator.getCost(this.oldChild) - InlineCostEstimator.getCost(this.newChild);
        }
    }
}

