/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.base.Predicate;
import closurecompiler.internal.com.google.common.base.Supplier;
import closurecompiler.internal.com.google.common.collect.Maps;
import closurecompiler.internal.com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CodingConvention;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class FunctionArgumentInjector {
    private FunctionArgumentInjector() {
    }

    static Node inject(AbstractCompiler compiler, Node node, Node parent, Map<String, Node> replacements) {
        return FunctionArgumentInjector.inject(compiler, node, parent, replacements, true);
    }

    static Node inject(AbstractCompiler compiler, Node node, Node parent, Map<String, Node> replacements, boolean replaceThis) {
        Node replacementTemplate;
        if (node.isName()) {
            replacementTemplate = replacements.get(node.getString());
            if (replacementTemplate != null) {
                Preconditions.checkState(!parent.isFunction() || !parent.isVar() || !parent.isCatch());
                Node replacement = replacementTemplate.cloneTree();
                parent.replaceChild(node, replacement);
                return replacement;
            }
        } else if (replaceThis && node.isThis()) {
            replacementTemplate = replacements.get("this");
            Preconditions.checkNotNull(replacementTemplate);
            if (!replacementTemplate.isThis()) {
                Node replacement = replacementTemplate.cloneTree();
                parent.replaceChild(node, replacement);
                if (NodeUtil.mayHaveSideEffects(replacementTemplate, compiler)) {
                    replacements.remove("this");
                }
                return replacement;
            }
        } else if (node.isFunction()) {
            replaceThis = false;
        }
        for (Node c = node.getFirstChild(); c != null; c = c.getNext()) {
            c = FunctionArgumentInjector.inject(compiler, c, node, replacements, replaceThis);
        }
        return node;
    }

    static LinkedHashMap<String, Node> getFunctionCallParameterMap(Node fnNode, Node callNode, Supplier<String> safeNameIdSupplier) {
        LinkedHashMap<String, Node> argMap = Maps.newLinkedHashMap();
        Node cArg = callNode.getFirstChild().getNext();
        if (cArg != null && NodeUtil.isFunctionObjectCall(callNode)) {
            argMap.put("this", cArg);
            cArg = cArg.getNext();
        } else {
            Preconditions.checkState(!NodeUtil.isFunctionObjectApply(callNode));
            argMap.put("this", NodeUtil.newUndefinedNode(callNode));
        }
        for (Node fnArg : NodeUtil.getFunctionParameters(fnNode).children()) {
            if (cArg != null) {
                argMap.put(fnArg.getString(), cArg);
                cArg = cArg.getNext();
                continue;
            }
            Node srcLocation = callNode;
            argMap.put(fnArg.getString(), NodeUtil.newUndefinedNode(srcLocation));
        }
        boolean anonArg = false;
        while (cArg != null) {
            String uniquePlaceholder = FunctionArgumentInjector.getUniqueAnonymousParameterName(safeNameIdSupplier);
            argMap.put(uniquePlaceholder, cArg);
            cArg = cArg.getNext();
        }
        return argMap;
    }

    private static String getUniqueAnonymousParameterName(Supplier<String> safeNameIdSupplier) {
        return "JSCompiler_inline_anon_param_" + safeNameIdSupplier.get();
    }

    static Set<String> findModifiedParameters(Node fnNode) {
        Set<String> names = FunctionArgumentInjector.getFunctionParameterSet(fnNode);
        HashSet<String> unsafeNames = Sets.newHashSet();
        return FunctionArgumentInjector.findModifiedParameters(fnNode.getLastChild(), null, names, unsafeNames, false);
    }

    private static Set<String> findModifiedParameters(Node n, Node parent, Set<String> names, Set<String> unsafe, boolean inInnerFunction) {
        Preconditions.checkArgument(unsafe != null);
        if (n.isName()) {
            if (names.contains(n.getString()) && (inInnerFunction || FunctionArgumentInjector.canNameValueChange(n, parent))) {
                unsafe.add(n.getString());
            }
        } else if (n.isFunction()) {
            inInnerFunction = true;
        }
        for (Node c : n.children()) {
            FunctionArgumentInjector.findModifiedParameters(c, n, names, unsafe, inInnerFunction);
        }
        return unsafe;
    }

    private static boolean canNameValueChange(Node n, Node parent) {
        int type = parent.getType();
        return type == 118 || type == 102 || type == 103 || NodeUtil.isAssignmentOp(parent) && parent.getFirstChild() == n;
    }

    static void maybeAddTempsForCallArguments(Node fnNode, Map<String, Node> argMap, Set<String> namesNeedingTemps, CodingConvention convention) {
        if (argMap.isEmpty()) {
            return;
        }
        Preconditions.checkArgument(fnNode.isFunction());
        Node block = fnNode.getLastChild();
        Set<String> parameters = argMap.keySet();
        Set<String> namesAfterSideEffects = FunctionArgumentInjector.findParametersReferencedAfterSideEffect(parameters, block);
        for (Map.Entry<String, Node> entry : argMap.entrySet()) {
            String argName = entry.getKey();
            if (namesNeedingTemps.contains(argName)) continue;
            Node cArg = entry.getValue();
            boolean safe = true;
            int references = NodeUtil.getNameReferenceCount(block, argName);
            if (NodeUtil.mayEffectMutableState(cArg) && references > 0) {
                safe = false;
            } else if (NodeUtil.mayHaveSideEffects(cArg)) {
                safe = false;
            } else if (NodeUtil.canBeSideEffected(cArg) && namesAfterSideEffects.contains(argName)) {
                safe = false;
            } else if (references > 1) {
                switch (cArg.getType()) {
                    case 38: {
                        String name = cArg.getString();
                        safe = !convention.isExported(name);
                        break;
                    }
                    case 42: {
                        safe = true;
                        break;
                    }
                    case 40: {
                        safe = cArg.getString().length() < 2;
                        break;
                    }
                    default: {
                        safe = NodeUtil.isImmutableValue(cArg);
                    }
                }
            }
            if (safe) continue;
            namesNeedingTemps.add(argName);
        }
    }

    private static Set<String> findParametersReferencedAfterSideEffect(Set<String> parameters, Node root) {
        HashSet<String> locals = Sets.newHashSet(parameters);
        FunctionArgumentInjector.gatherLocalNames(root, locals);
        ReferencedAfterSideEffect collector = new ReferencedAfterSideEffect(parameters, locals);
        NodeUtil.visitPostOrder(root, collector, collector);
        return collector.getResults();
    }

    private static void gatherLocalNames(Node n, Set<String> names) {
        if (n.isFunction()) {
            if (NodeUtil.isFunctionDeclaration(n)) {
                names.add(n.getFirstChild().getString());
            }
            return;
        }
        if (n.isName()) {
            switch (n.getParent().getType()) {
                case 118: 
                case 120: {
                    names.add(n.getString());
                }
            }
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            FunctionArgumentInjector.gatherLocalNames(c, names);
        }
    }

    private static Set<String> getFunctionParameterSet(Node fnNode) {
        HashSet<String> set = Sets.newHashSet();
        for (Node n : NodeUtil.getFunctionParameters(fnNode).children()) {
            set.add(n.getString());
        }
        return set;
    }

    private static class ReferencedAfterSideEffect
    implements Predicate<Node>,
    NodeUtil.Visitor {
        private final Set<String> parameters;
        private final Set<String> locals;
        private boolean sideEffectSeen = false;
        private Set<String> parametersReferenced = Sets.newHashSet();
        private int loopsEntered = 0;

        ReferencedAfterSideEffect(Set<String> parameters, Set<String> locals) {
            this.parameters = parameters;
            this.locals = locals;
        }

        Set<String> getResults() {
            return this.parametersReferenced;
        }

        @Override
        public boolean apply(Node node) {
            if (NodeUtil.isLoopStructure(node)) {
                ++this.loopsEntered;
            }
            return !this.sideEffectSeen || this.parameters.size() != this.parametersReferenced.size();
        }

        boolean inLoop() {
            return this.loopsEntered != 0;
        }

        @Override
        public void visit(Node n) {
            if (NodeUtil.isLoopStructure(n)) {
                --this.loopsEntered;
                if (!this.inLoop() && !this.sideEffectSeen) {
                    this.parametersReferenced.clear();
                }
            }
            if (!this.sideEffectSeen && this.hasNonLocalSideEffect(n)) {
                this.sideEffectSeen = true;
            }
            if (this.inLoop() || this.sideEffectSeen) {
                if (n.isName()) {
                    String name = n.getString();
                    if (this.parameters.contains(name)) {
                        this.parametersReferenced.add(name);
                    }
                } else if (n.isThis()) {
                    this.parametersReferenced.add("this");
                }
            }
        }

        private boolean hasNonLocalSideEffect(Node n) {
            boolean sideEffect = false;
            int type = n.getType();
            if (NodeUtil.isAssignmentOp(n) || type == 102 || type == 103) {
                Node lhs = n.getFirstChild();
                if (!this.isLocalName(lhs)) {
                    sideEffect = true;
                }
            } else if (type == 37) {
                sideEffect = NodeUtil.functionCallHasSideEffects(n);
            } else if (type == 30) {
                sideEffect = NodeUtil.constructorCallHasSideEffects(n);
            } else if (type == 31) {
                sideEffect = true;
            }
            return sideEffect;
        }

        private boolean isLocalName(Node node) {
            if (node.isName()) {
                String name = node.getString();
                return this.locals.contains(name);
            }
            return false;
        }
    }
}

