/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.base.Predicate;
import closurecompiler.internal.com.google.common.base.Predicates;
import closurecompiler.internal.com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CheckPathsBetweenNodes;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.ControlFlowAnalysis;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.ControlFlowGraph;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DataFlowAnalysis;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.MaybeReachingVariableUse;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.MustBeReachingVariableDef;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.graph.DiGraph;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class FlowSensitiveInlineVariables
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private final AbstractCompiler compiler;
    private ControlFlowGraph<Node> cfg;
    private List<Candidate> candidates;
    private MustBeReachingVariableDef reachingDef;
    private MaybeReachingVariableUse reachingUses;
    private static final Predicate<Node> SIDE_EFFECT_PREDICATE = new Predicate<Node>(){

        @Override
        public boolean apply(Node n) {
            if (n == null) {
                return false;
            }
            if (n.isCall() && NodeUtil.functionCallHasSideEffects(n)) {
                return true;
            }
            if (n.isNew() && NodeUtil.constructorCallHasSideEffects(n)) {
                return true;
            }
            for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                if (ControlFlowGraph.isEnteringNewCfgNode(c) || !this.apply(c)) continue;
                return true;
            }
            return false;
        }
    };

    public FlowSensitiveInlineVariables(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void enterScope(NodeTraversal t) {
        if (t.inGlobalScope()) {
            return;
        }
        if (100 < t.getScope().getVarCount()) {
            return;
        }
        ControlFlowAnalysis cfa = new ControlFlowAnalysis(this.compiler, false, true);
        Preconditions.checkState(t.getScopeRoot().isFunction());
        cfa.process(null, t.getScopeRoot().getLastChild());
        this.cfg = cfa.getCfg();
        this.reachingDef = new MustBeReachingVariableDef(this.cfg, t.getScope(), this.compiler);
        this.reachingDef.analyze();
        this.candidates = Lists.newLinkedList();
        new NodeTraversal(this.compiler, new GatherCandiates()).traverse(t.getScopeRoot().getLastChild());
        this.reachingUses = new MaybeReachingVariableUse(this.cfg, t.getScope(), this.compiler);
        this.reachingUses.analyze();
        for (Candidate c : this.candidates) {
            if (!c.canInline()) continue;
            c.inlineVariable();
        }
    }

    @Override
    public void exitScope(NodeTraversal t) {
    }

    @Override
    public void process(Node externs, Node root) {
        new NodeTraversal(this.compiler, this).traverse(root);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
    }

    private static boolean checkRightOf(Node n, Node expressionRoot, Predicate<Node> predicate) {
        for (Node p = n; p != expressionRoot; p = p.getParent()) {
            for (Node cur = p.getNext(); cur != null; cur = cur.getNext()) {
                if (!predicate.apply(cur)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkLeftOf(Node n, Node expressionRoot, Predicate<Node> predicate) {
        for (Node p = n.getParent(); p != expressionRoot; p = p.getParent()) {
            for (Node cur = p.getParent().getFirstChild(); cur != p; cur = cur.getNext()) {
                if (!predicate.apply(cur)) continue;
                return true;
            }
        }
        return false;
    }

    private class Candidate {
        private final String varName;
        private Node def;
        private final Node defCfgNode;
        private final Node use;
        private final Node useCfgNode;
        private int numUseWithinUseCfgNode;

        Candidate(String varName, Node defCfgNode, Node use, Node useCfgNode) {
            Preconditions.checkArgument(use.isName());
            this.varName = varName;
            this.defCfgNode = defCfgNode;
            this.use = use;
            this.useCfgNode = useCfgNode;
        }

        private boolean canInline() {
            CheckPathsBetweenNodes pathCheck;
            if (this.defCfgNode.isFunction()) {
                return false;
            }
            this.getDefinition(this.defCfgNode, null);
            this.getNumUseInUseCfgNode(this.useCfgNode, null);
            if (this.def == null) {
                return false;
            }
            if (this.def.isAssign() && !NodeUtil.isExprAssign(this.def.getParent())) {
                return false;
            }
            if (FlowSensitiveInlineVariables.checkRightOf(this.def, this.defCfgNode, SIDE_EFFECT_PREDICATE)) {
                return false;
            }
            if (FlowSensitiveInlineVariables.checkLeftOf(this.use, this.useCfgNode, SIDE_EFFECT_PREDICATE)) {
                return false;
            }
            if (NodeUtil.mayHaveSideEffects(this.def.getLastChild())) {
                return false;
            }
            if (this.numUseWithinUseCfgNode != 1) {
                return false;
            }
            if (NodeUtil.isWithinLoop(this.use)) {
                return false;
            }
            Collection<Node> uses = FlowSensitiveInlineVariables.this.reachingUses.getUses(this.varName, this.defCfgNode);
            if (uses.size() != 1) {
                return false;
            }
            if (NodeUtil.has(this.def.getLastChild(), new Predicate<Node>(){

                @Override
                public boolean apply(Node input) {
                    switch (input.getType()) {
                        case 30: 
                        case 33: 
                        case 35: 
                        case 47: 
                        case 63: 
                        case 64: {
                            return true;
                        }
                    }
                    return false;
                }
            }, new Predicate<Node>(){

                @Override
                public boolean apply(Node input) {
                    return !input.isFunction();
                }
            })) {
                return false;
            }
            return !NodeUtil.isStatementBlock(this.defCfgNode.getParent()) || this.defCfgNode.getNext() == this.useCfgNode || !(pathCheck = new CheckPathsBetweenNodes(FlowSensitiveInlineVariables.this.cfg, FlowSensitiveInlineVariables.this.cfg.getDirectedGraphNode(this.defCfgNode), FlowSensitiveInlineVariables.this.cfg.getDirectedGraphNode(this.useCfgNode), SIDE_EFFECT_PREDICATE, Predicates.alwaysTrue(), false)).somePathsSatisfyPredicate();
        }

        private void inlineVariable() {
            Node defParent = this.def.getParent();
            Node useParent = this.use.getParent();
            if (this.def.isAssign()) {
                Node rhs = this.def.getLastChild();
                rhs.detachFromParent();
                Preconditions.checkState(defParent.isExprResult());
                while (defParent.getParent().isLabel()) {
                    defParent = defParent.getParent();
                }
                defParent.detachFromParent();
                useParent.replaceChild(this.use, rhs);
            } else if (defParent.isVar()) {
                Node rhs = this.def.getLastChild();
                this.def.removeChild(rhs);
                useParent.replaceChild(this.use, rhs);
            } else {
                Preconditions.checkState(false, "No other definitions can be inlined.");
            }
            FlowSensitiveInlineVariables.this.compiler.reportCodeChange();
        }

        private void getDefinition(Node n, Node parent) {
            ControlFlowGraph.AbstractCfgNodeTraversalCallback gatherCb = new ControlFlowGraph.AbstractCfgNodeTraversalCallback(){

                @Override
                public void visit(NodeTraversal t, Node n, Node parent) {
                    switch (n.getType()) {
                        case 38: {
                            if (n.getString().equals(Candidate.this.varName) && n.hasChildren()) {
                                Candidate.this.def = n;
                            }
                            return;
                        }
                        case 86: {
                            Node lhs = n.getFirstChild();
                            if (lhs.isName() && lhs.getString().equals(Candidate.this.varName)) {
                                Candidate.this.def = n;
                            }
                            return;
                        }
                    }
                }
            };
            NodeTraversal.traverse(FlowSensitiveInlineVariables.this.compiler, n, gatherCb);
        }

        private void getNumUseInUseCfgNode(Node n, Node parant) {
            ControlFlowGraph.AbstractCfgNodeTraversalCallback gatherCb = new ControlFlowGraph.AbstractCfgNodeTraversalCallback(){

                @Override
                public void visit(NodeTraversal t, Node n, Node parent) {
                    if (n.isName() && n.getString().equals(Candidate.this.varName) && (!parent.isAssign() || parent.getFirstChild() != n)) {
                        Candidate.this.numUseWithinUseCfgNode++;
                    }
                }
            };
            NodeTraversal.traverse(FlowSensitiveInlineVariables.this.compiler, n, gatherCb);
        }
    }

    private class GatherCandiates
    extends NodeTraversal.AbstractShallowCallback {
        private GatherCandiates() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            DiGraph.DiGraphNode graphNode = FlowSensitiveInlineVariables.this.cfg.getDirectedGraphNode(n);
            if (graphNode == null) {
                return;
            }
            DataFlowAnalysis.FlowState state = (DataFlowAnalysis.FlowState)graphNode.getAnnotation();
            MustBeReachingVariableDef.MustDef defs = (MustBeReachingVariableDef.MustDef)state.getIn();
            final Node cfgNode = n;
            ControlFlowGraph.AbstractCfgNodeTraversalCallback gatherCb = new ControlFlowGraph.AbstractCfgNodeTraversalCallback(){

                @Override
                public void visit(NodeTraversal t, Node n, Node parent) {
                    if (n.isName()) {
                        if (NodeUtil.isAssignmentOp(parent) && parent.getFirstChild() == n || parent.isVar() || parent.isInc() || parent.isDec() || parent.isParamList() || parent.isCatch()) {
                            return;
                        }
                        String name = n.getString();
                        if (FlowSensitiveInlineVariables.this.compiler.getCodingConvention().isExported(name)) {
                            return;
                        }
                        Node defNode = FlowSensitiveInlineVariables.this.reachingDef.getDef(name, cfgNode);
                        if (defNode != null && !FlowSensitiveInlineVariables.this.reachingDef.dependsOnOuterScopeVars(name, cfgNode)) {
                            FlowSensitiveInlineVariables.this.candidates.add(new Candidate(name, defNode, n, cfgNode));
                        }
                    }
                }
            };
            NodeTraversal.traverse(FlowSensitiveInlineVariables.this.compiler, cfgNode, gatherCb);
        }
    }
}

