/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DiagnosticType;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.rhino.JSDocInfo;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

public class FindExportableNodes
extends NodeTraversal.AbstractPostOrderCallback {
    static final DiagnosticType NON_GLOBAL_ERROR = DiagnosticType.error("JSC_NON_GLOBAL_ERROR", "@export only applies to symbols/properties defined in the global scope.");
    private final LinkedHashMap<String, GenerateNodeContext> exports;
    private final AbstractCompiler compiler;

    public FindExportableNodes(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.exports = Maps.newLinkedHashMap();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        JSDocInfo docInfo = n.getJSDocInfo();
        if (docInfo != null && docInfo.isExport()) {
            String export = null;
            GenerateNodeContext context = null;
            switch (n.getType()) {
                case 105: {
                    if (!parent.isScript()) break;
                    export = NodeUtil.getFunctionName(n);
                    context = new GenerateNodeContext(n, parent, n);
                    break;
                }
                case 86: {
                    Node grandparent = parent.getParent();
                    if (grandparent == null || !grandparent.isScript() || !parent.isExprResult() || n.getLastChild().isAssign()) break;
                    export = n.getFirstChild().getQualifiedName();
                    context = new GenerateNodeContext(n, grandparent, parent);
                    break;
                }
                case 118: {
                    if (!parent.isScript() || !n.getFirstChild().hasChildren() || n.getFirstChild().getFirstChild().isAssign()) break;
                    export = n.getFirstChild().getString();
                    context = new GenerateNodeContext(n, parent, n);
                }
            }
            if (export != null) {
                this.exports.put(export, context);
            } else {
                this.compiler.report(t.makeError(n, NON_GLOBAL_ERROR, new String[0]));
            }
        }
    }

    public LinkedHashMap<String, GenerateNodeContext> getExports() {
        return this.exports;
    }

    public static class GenerateNodeContext {
        private final Node scriptNode;
        private final Node contextNode;
        private final Node node;

        public GenerateNodeContext(Node node, Node scriptNode, Node contextNode) {
            this.node = node;
            this.scriptNode = scriptNode;
            this.contextNode = contextNode;
        }

        public Node getNode() {
            return this.node;
        }

        public Node getScriptNode() {
            return this.scriptNode;
        }

        public Node getContextNode() {
            return this.contextNode;
        }
    }
}

