/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Joiner;
import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.Iterables;
import closurecompiler.internal.com.google.common.collect.Lists;
import closurecompiler.internal.com.google.common.collect.Maps;
import closurecompiler.internal.com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CheckLevel;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CodePrinter;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CodingConvention;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DiagnosticType;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSError;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.rhino.IR;
import org.jetbrains.jet.internal.com.google.javascript.rhino.JSDocInfo;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.FunctionType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSType;

final class ExternExportsPass
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType EXPORTED_FUNCTION_UNKNOWN_PARAMETER_TYPE = DiagnosticType.warning("JSC_EXPORTED_FUNCTION_UNKNOWN_PARAMETER_TYPE", "Unable to determine type of parameter {0} for exported function {1}");
    static final DiagnosticType EXPORTED_FUNCTION_UNKNOWN_RETURN_TYPE = DiagnosticType.warning("JSC_EXPORTED_FUNCTION_UNKNOWN_RETURN_TYPE", "Unable to determine return type for exported function {0}");
    private final List<Export> exports = Lists.newArrayList();
    private final Map<String, Node> definitionMap;
    private final AbstractCompiler compiler;
    private final Node externsRoot;
    private final Map<String, String> mappedPaths;
    private final Set<String> alreadyExportedPaths;
    private List<String> exportSymbolFunctionNames;
    private List<String> exportPropertyFunctionNames;

    ExternExportsPass(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.definitionMap = Maps.newHashMap();
        this.externsRoot = IR.block();
        this.externsRoot.setIsSyntheticBlock(true);
        this.alreadyExportedPaths = Sets.newHashSet();
        this.mappedPaths = Maps.newHashMap();
        this.initExportMethods();
    }

    private void initExportMethods() {
        this.exportSymbolFunctionNames = Lists.newArrayList();
        this.exportPropertyFunctionNames = Lists.newArrayList();
        CodingConvention convention = this.compiler.getCodingConvention();
        this.exportSymbolFunctionNames.add(convention.getExportSymbolFunction());
        this.exportPropertyFunctionNames.add(convention.getExportPropertyFunction());
        this.exportSymbolFunctionNames.add("google_exportSymbol");
        this.exportPropertyFunctionNames.add("google_exportProperty");
    }

    @Override
    public void process(Node externs, Node root) {
        new NodeTraversal(this.compiler, this).traverse(root);
        TreeSet<Export> sorted = new TreeSet<Export>(new Comparator<Export>(){

            @Override
            public int compare(Export e1, Export e2) {
                return e1.getExportedPath().compareTo(e2.getExportedPath());
            }
        });
        sorted.addAll(this.exports);
        for (Export export : sorted) {
            export.generateExterns();
        }
    }

    public String getGeneratedExterns() {
        CodePrinter.Builder builder = new CodePrinter.Builder(this.externsRoot).setPrettyPrint(true).setOutputTypes(true);
        return builder.build();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 33: 
            case 38: {
                String name = n.getQualifiedName();
                if (name == null) {
                    return;
                }
                if (parent.isAssign() || parent.isVar()) {
                    this.definitionMap.put(n.getQualifiedName(), parent);
                }
                if (!parent.isCall()) {
                    return;
                }
                if (this.exportPropertyFunctionNames.contains(n.getQualifiedName())) {
                    this.handlePropertyExport(parent);
                }
                if (!this.exportSymbolFunctionNames.contains(n.getQualifiedName())) break;
                this.handleSymbolExport(parent);
            }
        }
    }

    private void handleSymbolExport(Node parent) {
        if (parent.getChildCount() != 3) {
            return;
        }
        Node thisNode = parent.getFirstChild();
        Node nameArg = thisNode.getNext();
        Node valueArg = nameArg.getNext();
        if (!nameArg.isString()) {
            return;
        }
        this.exports.add(new SymbolExport(nameArg.getString(), valueArg));
    }

    private void handlePropertyExport(Node parent) {
        if (parent.getChildCount() != 4) {
            return;
        }
        Node thisNode = parent.getFirstChild();
        Node objectArg = thisNode.getNext();
        Node nameArg = objectArg.getNext();
        Node valueArg = nameArg.getNext();
        if (objectArg.getQualifiedName() == null) {
            return;
        }
        if (!nameArg.isString()) {
            return;
        }
        this.exports.add(new PropertyExport(objectArg.getQualifiedName(), nameArg.getString(), valueArg));
    }

    private class PropertyExport
    extends Export {
        private final String exportPath;

        public PropertyExport(String exportPath, String symbolName, Node value) {
            super(symbolName, value);
            this.exportPath = exportPath;
        }

        @Override
        String getExportedPath() {
            ArrayList<String> pieces = Lists.newArrayList(this.exportPath.split("\\."));
            for (int i = pieces.size(); i > 0; --i) {
                String cPath = Joiner.on(".").join(Iterables.limit(pieces, i));
                if (!ExternExportsPass.this.mappedPaths.containsKey(cPath)) continue;
                String newPath = (String)ExternExportsPass.this.mappedPaths.get(cPath);
                if (i < pieces.size()) {
                    newPath = newPath + "." + Joiner.on(".").join(Iterables.skip(pieces, i));
                }
                return newPath + "." + this.symbolName;
            }
            return this.exportPath + "." + this.symbolName;
        }
    }

    private class SymbolExport
    extends Export {
        public SymbolExport(String symbolName, Node value) {
            super(symbolName, value);
            String qualifiedName = value.getQualifiedName();
            if (qualifiedName != null) {
                ExternExportsPass.this.mappedPaths.put(qualifiedName, symbolName);
            }
        }

        @Override
        String getExportedPath() {
            return this.symbolName;
        }
    }

    private abstract class Export {
        protected final String symbolName;
        protected final Node value;

        Export(String symbolName, Node value) {
            this.symbolName = symbolName;
            this.value = value;
        }

        void generateExterns() {
            this.appendExtern(this.getExportedPath(), this.getValue(this.value));
        }

        abstract String getExportedPath();

        void appendExtern(String path, Node valueToExport) {
            List<String> pathPrefixes = this.computePathPrefixes(path);
            for (int i = 0; i < pathPrefixes.size(); ++i) {
                Node initializer;
                boolean skipPathPrefix;
                String pathPrefix = pathPrefixes.get(i);
                boolean isCompletePathPrefix = i == pathPrefixes.size() - 1;
                boolean bl = skipPathPrefix = pathPrefix.endsWith(".prototype") || ExternExportsPass.this.alreadyExportedPaths.contains(pathPrefix) && !isCompletePathPrefix;
                if (skipPathPrefix) continue;
                if (isCompletePathPrefix && valueToExport != null) {
                    if (valueToExport.isFunction()) {
                        initializer = this.createExternFunction(valueToExport);
                    } else {
                        Preconditions.checkState(valueToExport.isObjectLit());
                        initializer = this.createExternObjectLit(valueToExport);
                    }
                } else {
                    initializer = IR.empty();
                }
                this.appendPathDefinition(pathPrefix, initializer);
            }
        }

        private List<String> computePathPrefixes(String path) {
            ArrayList<String> pieces = Lists.newArrayList(path.split("\\."));
            ArrayList<String> pathPrefixes = Lists.newArrayList();
            for (int i = 0; i < pieces.size(); ++i) {
                pathPrefixes.add(Joiner.on(".").join(Iterables.limit(pieces, i + 1)));
            }
            return pathPrefixes;
        }

        private void appendPathDefinition(String path, Node initializer) {
            Node pathDefinition;
            if (!path.contains(".")) {
                pathDefinition = initializer.isEmpty() ? IR.var(IR.name(path)) : NodeUtil.newVarNode(path, initializer);
            } else {
                Node qualifiedPath = NodeUtil.newQualifiedNameNode(ExternExportsPass.this.compiler.getCodingConvention(), path);
                pathDefinition = initializer.isEmpty() ? NodeUtil.newExpr(qualifiedPath) : NodeUtil.newExpr(IR.assign(qualifiedPath, initializer));
            }
            ExternExportsPass.this.externsRoot.addChildToBack(pathDefinition);
            ExternExportsPass.this.alreadyExportedPaths.add(path);
        }

        private Node createExternFunction(Node exportedFunction) {
            Node paramList = NodeUtil.getFunctionParameters(exportedFunction).cloneTree();
            Node externFunction = IR.function(IR.name(""), paramList, IR.block());
            this.checkForFunctionsWithUnknownTypes(exportedFunction);
            externFunction.setJSType(exportedFunction.getJSType());
            return externFunction;
        }

        private Node createExternObjectLit(Node exportedObjectLit) {
            Node lit = IR.objectlit(new Node[0]);
            lit.setJSType(exportedObjectLit.getJSType());
            lit.setJSDocInfo(new JSDocInfo());
            int index = 1;
            for (Node child = exportedObjectLit.getFirstChild(); child != null; child = child.getNext()) {
                if (!child.isString()) continue;
                lit.addChildToBack(IR.propdef(IR.string(child.getString()), IR.number(index++)));
            }
            return lit;
        }

        private void checkForFunctionsWithUnknownTypes(Node function) {
            Preconditions.checkArgument(function.isFunction());
            FunctionType functionType = JSType.toMaybeFunctionType(function.getJSType());
            if (functionType == null) {
                return;
            }
            JSDocInfo functionJSDocInfo = functionType.getJSDocInfo();
            JSType returnType = functionType.getReturnType();
            if (!functionType.isConstructor() && (returnType == null || returnType.isUnknownType())) {
                this.reportUnknownReturnType(function);
            }
            Node astParameterIterator = NodeUtil.getFunctionParameters(function).getFirstChild();
            Node typeParameterIterator = functionType.getParametersNode().getFirstChild();
            while (astParameterIterator != null) {
                JSType parameterType = typeParameterIterator.getJSType();
                if (parameterType == null || parameterType.isUnknownType()) {
                    this.reportUnknownParameterType(function, astParameterIterator);
                }
                astParameterIterator = astParameterIterator.getNext();
                typeParameterIterator = typeParameterIterator.getNext();
            }
        }

        private void reportUnknownParameterType(Node function, Node parameter) {
            ExternExportsPass.this.compiler.report(JSError.make(NodeUtil.getSourceName(function), parameter, CheckLevel.WARNING, EXPORTED_FUNCTION_UNKNOWN_PARAMETER_TYPE, NodeUtil.getFunctionName(function), parameter.getString()));
        }

        private void reportUnknownReturnType(Node function) {
            ExternExportsPass.this.compiler.report(JSError.make(NodeUtil.getSourceName(function), function, CheckLevel.WARNING, EXPORTED_FUNCTION_UNKNOWN_RETURN_TYPE, NodeUtil.getFunctionName(function)));
        }

        protected Node getValue(Node qualifiedNameNode) {
            Node definition;
            String qualifiedName = this.value.getQualifiedName();
            if (qualifiedName == null) {
                return null;
            }
            Node definitionParent = (Node)ExternExportsPass.this.definitionMap.get(qualifiedName);
            if (definitionParent == null) {
                return null;
            }
            switch (definitionParent.getType()) {
                case 86: {
                    definition = definitionParent.getLastChild();
                    break;
                }
                case 118: {
                    definition = definitionParent.getLastChild().getLastChild();
                    break;
                }
                default: {
                    return null;
                }
            }
            if (!definition.isFunction() && !definition.isObjectLit()) {
                return null;
            }
            return definition;
        }
    }
}

