/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.base.Supplier;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.rhino.IR;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class ExpressionDecomposer {
    private final AbstractCompiler compiler;
    private final Supplier<String> safeNameIdSupplier;
    private final Set<String> knownConstants;
    private String tempNamePrefix = "JSCompiler_temp";

    public ExpressionDecomposer(AbstractCompiler compiler, Supplier<String> safeNameIdSupplier, Set<String> constNames) {
        Preconditions.checkNotNull(compiler);
        Preconditions.checkNotNull(safeNameIdSupplier);
        Preconditions.checkNotNull(constNames);
        this.compiler = compiler;
        this.safeNameIdSupplier = safeNameIdSupplier;
        this.knownConstants = constNames;
    }

    void maybeDecomposeExpression(Node expression) {
        int i = 0;
        while (DecompositionType.DECOMPOSABLE == this.canExposeExpression(expression)) {
            this.exposeExpression(expression);
            if (++i <= 100) continue;
            throw new IllegalStateException("DecomposeExpression depth exceeded on :\n" + expression.toStringTree());
        }
    }

    void exposeExpression(Node expression) {
        Node expressionRoot = ExpressionDecomposer.findExpressionRoot(expression);
        Preconditions.checkState(expressionRoot != null);
        this.exposeExpression(expressionRoot, expression);
        this.compiler.reportCodeChange();
    }

    private void exposeExpression(Node expressionRoot, Node subExpression) {
        Node nonconditionalExpr = ExpressionDecomposer.findNonconditionalParent(subExpression, expressionRoot);
        boolean hasFollowingSideEffects = NodeUtil.mayHaveSideEffects(nonconditionalExpr);
        Node exprInjectionPoint = ExpressionDecomposer.findInjectionPoint(nonconditionalExpr);
        DecompositionState state = new DecompositionState();
        state.sideEffects = hasFollowingSideEffects;
        state.extractBeforeStatement = exprInjectionPoint;
        Node grandchild = null;
        Node child = nonconditionalExpr;
        Node parent = child.getParent();
        while (parent != expressionRoot) {
            int parentType = parent.getType();
            Preconditions.checkState(!ExpressionDecomposer.isConditionalOp(parent) || child == parent.getFirstChild());
            if (parentType == 86) {
                if (!this.isSafeAssign(parent, state.sideEffects)) {
                    Node left = parent.getFirstChild();
                    int type = left.getType();
                    if (left != child) {
                        Preconditions.checkState(NodeUtil.isGet(left));
                        if (type == 35) {
                            this.decomposeSubExpressions(left.getLastChild(), null, state);
                        }
                        this.decomposeSubExpressions(left.getFirstChild(), null, state);
                    }
                }
            } else if (parentType == 37 && NodeUtil.isGet(parent.getFirstChild())) {
                Node functionExpression = parent.getFirstChild();
                this.decomposeSubExpressions(functionExpression.getNext(), child, state);
                if (this.isExpressionTreeUnsafe(functionExpression, state.sideEffects) && functionExpression.getFirstChild() != grandchild) {
                    Node replacement;
                    Preconditions.checkState(ExpressionDecomposer.allowObjectCallDecomposing(), "Object method calls can not be decomposed.");
                    state.sideEffects = true;
                    parent = replacement = this.rewriteCallExpression(parent, state);
                }
            } else if (parentType == 64) {
                this.decomposeObjectLiteralKeys(parent.getFirstChild(), child, state);
            } else {
                this.decomposeSubExpressions(parent.getFirstChild(), child, state);
            }
            grandchild = child;
            child = parent;
            parent = child.getParent();
        }
        if (nonconditionalExpr != subExpression) {
            Node parent2 = nonconditionalExpr.getParent();
            boolean needResult = !parent2.isExprResult();
            Node node = this.extractConditional(nonconditionalExpr, exprInjectionPoint, needResult);
        }
    }

    private static boolean allowObjectCallDecomposing() {
        return false;
    }

    private boolean maybeExternMethod(Node node) {
        return true;
    }

    private static Node findNonconditionalParent(Node subExpression, Node expressionRoot) {
        Node result = subExpression;
        Node child = subExpression;
        Node parent = child.getParent();
        while (parent != expressionRoot) {
            if (ExpressionDecomposer.isConditionalOp(parent) && child != parent.getFirstChild()) {
                result = parent;
            }
            child = parent;
            parent = child.getParent();
        }
        return result;
    }

    private void decomposeObjectLiteralKeys(Node key, Node stopNode, DecompositionState state) {
        if (key == null || key == stopNode) {
            return;
        }
        this.decomposeObjectLiteralKeys(key.getNext(), stopNode, state);
        this.decomposeSubExpressions(key.getFirstChild(), stopNode, state);
    }

    private void decomposeSubExpressions(Node n, Node stopNode, DecompositionState state) {
        if (n == null || n == stopNode) {
            return;
        }
        Preconditions.checkState(!NodeUtil.isObjectLitKey(n, n.getParent()));
        this.decomposeSubExpressions(n.getNext(), stopNode, state);
        if (this.isExpressionTreeUnsafe(n, state.sideEffects)) {
            state.sideEffects = true;
            state.extractBeforeStatement = this.extractExpression(n, state.extractBeforeStatement);
        }
    }

    private Node extractConditional(Node expr, Node injectionPoint, boolean needResult) {
        Node parent = expr.getParent();
        String tempName = this.getTempValueName();
        Node first = expr.getFirstChild();
        Node second = first.getNext();
        Node last = expr.getLastChild();
        expr.detachChildren();
        Node cond = null;
        Node trueExpr = IR.block().srcref(expr);
        Node falseExpr = IR.block().srcref(expr);
        switch (expr.getType()) {
            case 98: {
                cond = first;
                trueExpr.addChildToFront(NodeUtil.newExpr(ExpressionDecomposer.buildResultExpression(second, needResult, tempName)));
                falseExpr.addChildToFront(NodeUtil.newExpr(ExpressionDecomposer.buildResultExpression(last, needResult, tempName)));
                break;
            }
            case 101: {
                cond = ExpressionDecomposer.buildResultExpression(first, needResult, tempName);
                trueExpr.addChildToFront(NodeUtil.newExpr(ExpressionDecomposer.buildResultExpression(last, needResult, tempName)));
                break;
            }
            case 100: {
                cond = ExpressionDecomposer.buildResultExpression(first, needResult, tempName);
                falseExpr.addChildToFront(NodeUtil.newExpr(ExpressionDecomposer.buildResultExpression(last, needResult, tempName)));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected.");
            }
        }
        Node ifNode = falseExpr.hasChildren() ? IR.ifNode(cond, trueExpr, falseExpr) : IR.ifNode(cond, trueExpr);
        ifNode.copyInformationFrom(expr);
        if (needResult) {
            Node tempVarNode = NodeUtil.newVarNode(tempName, null).copyInformationFromForTree(expr);
            Node injectionPointParent = injectionPoint.getParent();
            injectionPointParent.addChildBefore(tempVarNode, injectionPoint);
            injectionPointParent.addChildAfter(ifNode, tempVarNode);
            Node replacementValueNode = IR.name(tempName);
            parent.replaceChild(expr, replacementValueNode);
        } else {
            Preconditions.checkArgument(parent.isExprResult());
            Node gramps = parent.getParent();
            gramps.replaceChild(parent, ifNode);
        }
        return ifNode;
    }

    private static Node buildResultExpression(Node expr, boolean needResult, String tempName) {
        if (needResult) {
            return IR.assign(IR.name(tempName), expr).srcrefTree(expr);
        }
        return expr;
    }

    private boolean isConstantName(Node n, Set<String> knownConstants) {
        return n.isName() && (NodeUtil.isConstantName(n) || knownConstants.contains(n.getString()));
    }

    private Node extractExpression(Node expr, Node injectionPoint) {
        Node tempNameValue;
        Node parent = expr.getParent();
        boolean isLhsOfAssignOp = NodeUtil.isAssignmentOp(parent) && !parent.isAssign() && parent.getFirstChild() == expr;
        Node firstExtractedNode = null;
        if (isLhsOfAssignOp && NodeUtil.isGet(expr)) {
            for (Node n : expr.children()) {
                if (n.isString() || this.isConstantName(n, this.knownConstants)) continue;
                Node extractedNode = this.extractExpression(n, injectionPoint);
                if (firstExtractedNode != null) continue;
                firstExtractedNode = extractedNode;
            }
        }
        String tempName = this.getTempConstantValueName();
        Node replacementValueNode = IR.name(tempName).srcref(expr);
        if (isLhsOfAssignOp) {
            Preconditions.checkState(expr.isName() || NodeUtil.isGet(expr));
            Node opNode = new Node(NodeUtil.getOpFromAssignmentOp(parent)).copyInformationFrom(parent);
            Node rightOperand = parent.getLastChild();
            parent.setType(86);
            parent.replaceChild(rightOperand, opNode);
            opNode.addChildToFront(replacementValueNode);
            opNode.addChildToBack(rightOperand);
            tempNameValue = expr.cloneTree();
        } else {
            parent.replaceChild(expr, replacementValueNode);
            tempNameValue = expr;
        }
        Node tempVarNode = NodeUtil.newVarNode(tempName, tempNameValue);
        Node injectionPointParent = injectionPoint.getParent();
        injectionPointParent.addChildBefore(tempVarNode, injectionPoint);
        if (firstExtractedNode == null) {
            firstExtractedNode = tempVarNode;
        }
        return firstExtractedNode;
    }

    private Node rewriteCallExpression(Node call, DecompositionState state) {
        Node thisVarNode;
        Node getVarNode;
        Preconditions.checkArgument(call.isCall());
        Node first = call.getFirstChild();
        Preconditions.checkArgument(NodeUtil.isGet(first));
        state.extractBeforeStatement = getVarNode = this.extractExpression(first, state.extractBeforeStatement);
        Node getExprNode = getVarNode.getFirstChild().getFirstChild();
        Preconditions.checkArgument(NodeUtil.isGet(getExprNode));
        state.extractBeforeStatement = thisVarNode = this.extractExpression(getExprNode.getFirstChild(), state.extractBeforeStatement);
        Node thisNameNode = thisVarNode.getFirstChild();
        Node functionNameNode = getVarNode.getFirstChild();
        Node newCall = IR.call(IR.getprop(functionNameNode.cloneNode(), IR.string("call")), thisNameNode.cloneNode()).srcref(call);
        call.removeFirstChild();
        if (call.hasChildren()) {
            newCall.addChildrenToBack(call.removeChildren());
        }
        Node callParent = call.getParent();
        callParent.replaceChild(call, newCall);
        return newCall;
    }

    public void setTempNamePrefix(String tempNamePrefix) {
        this.tempNamePrefix = tempNamePrefix;
    }

    private String getTempValueName() {
        return this.tempNamePrefix + "$$" + this.safeNameIdSupplier.get();
    }

    private String getTempConstantValueName() {
        String name = this.tempNamePrefix + "_const" + "$$" + this.safeNameIdSupplier.get();
        this.knownConstants.add(name);
        return name;
    }

    static Node findInjectionPoint(Node subExpression) {
        Node expressionRoot = ExpressionDecomposer.findExpressionRoot(subExpression);
        Preconditions.checkNotNull(expressionRoot);
        Node injectionPoint = expressionRoot;
        Node parent = injectionPoint.getParent();
        while (parent.isLabel()) {
            injectionPoint = parent;
            parent = injectionPoint.getParent();
        }
        Preconditions.checkState(NodeUtil.isStatementBlock(injectionPoint.getParent()));
        return injectionPoint;
    }

    private static boolean isConditionalOp(Node n) {
        switch (n.getType()) {
            case 98: 
            case 100: 
            case 101: {
                return true;
            }
        }
        return false;
    }

    static Node findExpressionRoot(Node subExpression) {
        Node child = subExpression;
        for (Node parent : child.getAncestors()) {
            int parentType = parent.getType();
            switch (parentType) {
                case 4: 
                case 108: 
                case 110: 
                case 118: 
                case 130: {
                    Preconditions.checkState(child == parent.getFirstChild());
                    return parent;
                }
                case 111: 
                case 112: 
                case 125: 
                case 126: 
                case 132: {
                    return null;
                }
            }
            child = parent;
        }
        throw new IllegalStateException("Unexpected AST structure.");
    }

    DecompositionType canExposeExpression(Node subExpression) {
        Node expressionRoot = ExpressionDecomposer.findExpressionRoot(subExpression);
        if (expressionRoot != null) {
            return this.isSubexpressionMovable(expressionRoot, subExpression);
        }
        return DecompositionType.UNDECOMPOSABLE;
    }

    private DecompositionType isSubexpressionMovable(Node expressionRoot, Node subExpression) {
        boolean requiresDecomposition = false;
        boolean seenSideEffects = NodeUtil.mayHaveSideEffects(subExpression);
        Node child = subExpression;
        for (Node parent : child.getAncestors()) {
            if (parent == expressionRoot) {
                return requiresDecomposition ? DecompositionType.DECOMPOSABLE : DecompositionType.MOVABLE;
            }
            int parentType = parent.getType();
            if (ExpressionDecomposer.isConditionalOp(parent)) {
                if (child != parent.getFirstChild()) {
                    requiresDecomposition = true;
                }
            } else if (!this.isSafeAssign(parent, seenSideEffects)) {
                for (Node n : parent.children()) {
                    if (n == child) break;
                    if (!this.isExpressionTreeUnsafe(n, seenSideEffects)) continue;
                    seenSideEffects = true;
                    requiresDecomposition = true;
                }
                Node first = parent.getFirstChild();
                if (requiresDecomposition && parent.isCall() && NodeUtil.isGet(first)) {
                    if (this.maybeExternMethod(first)) {
                        return DecompositionType.UNDECOMPOSABLE;
                    }
                    return DecompositionType.DECOMPOSABLE;
                }
            }
            child = parent;
        }
        throw new IllegalStateException("Unexpected.");
    }

    private boolean isSafeAssign(Node n, boolean seenSideEffects) {
        if (n.isAssign()) {
            Node lhs = n.getFirstChild();
            switch (lhs.getType()) {
                case 38: {
                    return true;
                }
                case 33: {
                    return !this.isExpressionTreeUnsafe(lhs.getFirstChild(), seenSideEffects);
                }
                case 35: {
                    return !this.isExpressionTreeUnsafe(lhs.getFirstChild(), seenSideEffects) && !this.isExpressionTreeUnsafe(lhs.getLastChild(), seenSideEffects);
                }
            }
        }
        return false;
    }

    private boolean isExpressionTreeUnsafe(Node n, boolean followingSideEffectsExist) {
        if (followingSideEffectsExist) {
            return NodeUtil.canBeSideEffected(n, this.knownConstants);
        }
        return NodeUtil.mayHaveSideEffects(n);
    }

    private static class DecompositionState {
        boolean sideEffects;
        Node extractBeforeStatement;

        private DecompositionState() {
        }
    }

    static enum DecompositionType {
        UNDECOMPOSABLE,
        MOVABLE,
        DECOMPOSABLE;

    }
}

