/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import org.jetbrains.jet.internal.com.google.javascript.jscomp.LightweightMessageFormatter;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.MessageFormatter;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.SourceExcerptProvider;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.VerboseMessageFormatter;

public enum ErrorFormat {
    LEGACY{

        @Override
        public MessageFormatter toFormatter(SourceExcerptProvider source, boolean colorize) {
            VerboseMessageFormatter formatter = new VerboseMessageFormatter(source);
            formatter.setColorize(colorize);
            return formatter;
        }
    }
    ,
    SINGLELINE{

        @Override
        public MessageFormatter toFormatter(SourceExcerptProvider source, boolean colorize) {
            LightweightMessageFormatter formatter = new LightweightMessageFormatter(source);
            formatter.setColorize(colorize);
            return formatter;
        }
    }
    ,
    MULTILINE{

        @Override
        public MessageFormatter toFormatter(SourceExcerptProvider source, boolean colorize) {
            LightweightMessageFormatter formatter = new LightweightMessageFormatter(source, SourceExcerptProvider.SourceExcerpt.REGION);
            formatter.setColorize(colorize);
            return formatter;
        }
    }
    ,
    SOURCELESS{

        @Override
        public MessageFormatter toFormatter(SourceExcerptProvider source, boolean colorize) {
            LightweightMessageFormatter formatter = LightweightMessageFormatter.withoutSource();
            formatter.setColorize(colorize);
            return formatter;
        }
    };


    public abstract MessageFormatter toFormatter(SourceExcerptProvider var1, boolean var2);
}

