/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.ImmutableSet;
import closurecompiler.internal.com.google.common.collect.LinkedHashMultimap;
import closurecompiler.internal.com.google.common.collect.Lists;
import closurecompiler.internal.com.google.common.collect.Maps;
import closurecompiler.internal.com.google.common.collect.Multimap;
import closurecompiler.internal.com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CheckLevel;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CodingConvention;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.ConcreteType;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DiagnosticType;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSError;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.TightenTypes;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.TypeValidator;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.graph.StandardUnionFind;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.graph.UnionFind;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.FunctionType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSTypeNative;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSTypeRegistry;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.ObjectType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.StaticScope;

class DisambiguateProperties<T>
implements CompilerPass {
    private static final Logger logger = Logger.getLogger(DisambiguateProperties.class.getName());
    private final AbstractCompiler compiler;
    private final TypeSystem<T> typeSystem;
    private Multimap<Object, JSError> invalidationMap;
    private final Map<String, CheckLevel> propertiesToErrorFor;
    private Map<String, Property> properties = Maps.newHashMap();

    static DisambiguateProperties<JSType> forJSTypeSystem(AbstractCompiler compiler, Map<String, CheckLevel> propertiesToErrorFor) {
        return new DisambiguateProperties<JSType>(compiler, new JSTypeSystem(compiler), propertiesToErrorFor);
    }

    static DisambiguateProperties<ConcreteType> forConcreteTypeSystem(AbstractCompiler compiler, TightenTypes tt, Map<String, CheckLevel> propertiesToErrorFor) {
        return new DisambiguateProperties<ConcreteType>(compiler, new ConcreteTypeSystem(tt, compiler.getCodingConvention()), propertiesToErrorFor);
    }

    private DisambiguateProperties(AbstractCompiler compiler, TypeSystem<T> typeSystem, Map<String, CheckLevel> propertiesToErrorFor) {
        this.compiler = compiler;
        this.typeSystem = typeSystem;
        this.propertiesToErrorFor = propertiesToErrorFor;
        this.invalidationMap = !this.propertiesToErrorFor.isEmpty() ? LinkedHashMultimap.create() : null;
    }

    @Override
    public void process(Node externs, Node root) {
        for (TypeValidator.TypeMismatch mis : this.compiler.getTypeValidator().getMismatches()) {
            this.addInvalidatingType(mis.typeA);
            this.addInvalidatingType(mis.typeB);
            this.recordInvalidationError(mis.typeA, mis.src);
            this.recordInvalidationError(mis.typeB, mis.src);
        }
        StaticScope<T> scope = this.typeSystem.getRootScope();
        NodeTraversal.traverse(this.compiler, externs, new FindExternProperties());
        NodeTraversal.traverse(this.compiler, root, new FindRenameableProperties());
        this.renameProperties();
    }

    private void recordInvalidationError(JSType t, JSError error) {
        if (!t.isObject()) {
            return;
        }
        if (t.isUnionType()) {
            for (JSType alt : t.toMaybeUnionType().getAlternates()) {
                this.recordInvalidationError(alt, error);
            }
            return;
        }
        if (this.invalidationMap != null) {
            this.invalidationMap.put(t, error);
        }
    }

    private void addInvalidatingType(JSType type) {
        if ((type = type.restrictByNotNullOrUndefined()).isUnionType()) {
            for (JSType alt : type.toMaybeUnionType().getAlternates()) {
                this.addInvalidatingType(alt);
            }
        } else if (type.isEnumElementType()) {
            this.addInvalidatingType(type.toMaybeEnumElementType().getPrimitiveType());
        } else {
            this.typeSystem.addInvalidatingType(type);
            ObjectType objType = ObjectType.cast(type);
            if (objType != null && objType.getImplicitPrototype() != null) {
                this.typeSystem.addInvalidatingType(objType.getImplicitPrototype());
            }
        }
    }

    protected Property getProperty(String name) {
        if (!this.properties.containsKey(name)) {
            this.properties.put(name, new Property(name));
        }
        return this.properties.get(name);
    }

    void renameProperties() {
        int propsRenamed = 0;
        int propsSkipped = 0;
        int instancesRenamed = 0;
        int instancesSkipped = 0;
        int singleTypeProps = 0;
        for (Property prop : this.properties.values()) {
            if (prop.shouldRename()) {
                Map propNames = this.buildPropNames(prop.getTypes(), prop.name);
                ++propsRenamed;
                prop.expandTypesToSkip();
                UnionFind types = prop.getTypes();
                for (Node node : prop.renameNodes) {
                    Object rootType = prop.rootTypes.get(node);
                    if (prop.shouldRename(rootType)) {
                        String newName = propNames.get(rootType);
                        node.setString(newName);
                        this.compiler.reportCodeChange();
                        ++instancesRenamed;
                        continue;
                    }
                    ++instancesSkipped;
                }
                continue;
            }
            if (prop.skipRenaming) {
                ++propsSkipped;
                continue;
            }
            ++singleTypeProps;
        }
        logger.fine("Renamed " + instancesRenamed + " instances of " + propsRenamed + " properties.");
        logger.fine("Skipped renaming " + instancesSkipped + " invalidated " + "properties, " + propsSkipped + " instances of properties " + "that were skipped for specific types and " + singleTypeProps + " properties that were referenced from only one type.");
    }

    private Map<T, String> buildPropNames(UnionFind<T> types, String name) {
        HashMap<T, String> names = Maps.newHashMap();
        for (Set<T> set : types.allEquivalenceClasses()) {
            Preconditions.checkState(!set.isEmpty());
            String typeName = null;
            for (T type : set) {
                if (typeName != null && type.toString().compareTo(typeName) >= 0) continue;
                typeName = type.toString();
            }
            String newName = "{...}".equals(typeName) ? name : typeName.replaceAll("[^\\w$]", "_") + "$" + name;
            for (T type : set) {
                names.put(type, newName);
            }
        }
        return names;
    }

    private static class ConcreteTypeSystem
    implements TypeSystem<ConcreteType> {
        private final TightenTypes tt;
        private int nextUniqueId;
        private CodingConvention codingConvention;
        private final Set<JSType> invalidatingTypes = Sets.newHashSet();
        private static final JSTypeNative[] nativeTypes = new JSTypeNative[]{JSTypeNative.BOOLEAN_OBJECT_TYPE, JSTypeNative.NUMBER_OBJECT_TYPE, JSTypeNative.STRING_OBJECT_TYPE};

        public ConcreteTypeSystem(TightenTypes tt, CodingConvention convention) {
            this.tt = tt;
            this.codingConvention = convention;
        }

        @Override
        public void addInvalidatingType(JSType type) {
            Preconditions.checkState(!type.isUnionType());
            this.invalidatingTypes.add(type);
        }

        @Override
        public StaticScope<ConcreteType> getRootScope() {
            return this.tt.getTopScope();
        }

        @Override
        public StaticScope<ConcreteType> getFunctionScope(Node decl) {
            ConcreteType.ConcreteFunctionType func = this.tt.getConcreteFunction(decl);
            return func != null ? func.getScope() : (StaticScope)null;
        }

        @Override
        public ConcreteType getType(StaticScope<ConcreteType> scope, Node node, String prop) {
            if (scope != null) {
                ConcreteType c = this.tt.inferConcreteType((TightenTypes.ConcreteScope)scope, node);
                return this.maybeAddAutoboxes(c, node, prop);
            }
            return null;
        }

        private ConcreteType maybeAddAutoboxes(ConcreteType cType, Node node, String prop) {
            JSType jsType = node.getJSType();
            if (jsType == null) {
                return cType;
            }
            if (jsType.isUnknownType()) {
                for (JSTypeNative nativeType : nativeTypes) {
                    ConcreteType.ConcreteInstanceType concrete = this.tt.getConcreteInstance(this.tt.getTypeRegistry().getNativeObjectType(nativeType));
                    if (concrete == null || concrete.getPropertyType(prop).isNone()) continue;
                    cType = cType.unionWith(concrete);
                }
                return cType;
            }
            return this.maybeAddAutoboxes(cType, jsType, prop);
        }

        private ConcreteType maybeAddAutoboxes(ConcreteType cType, JSType jsType, String prop) {
            if ((jsType = jsType.restrictByNotNullOrUndefined()).isUnionType()) {
                for (JSType alt : jsType.toMaybeUnionType().getAlternates()) {
                    cType = this.maybeAddAutoboxes(cType, alt, prop);
                }
                return cType;
            }
            if (jsType.isEnumElementType()) {
                return this.maybeAddAutoboxes(cType, jsType.toMaybeEnumElementType().getPrimitiveType(), prop);
            }
            if (jsType.autoboxesTo() != null) {
                JSType autoboxed = jsType.autoboxesTo();
                return cType.unionWith(this.tt.getConcreteInstance((ObjectType)autoboxed));
            }
            if (jsType.unboxesTo() != null) {
                return cType.unionWith(this.tt.getConcreteInstance((ObjectType)jsType));
            }
            return cType;
        }

        @Override
        public boolean isInvalidatingType(ConcreteType type) {
            return type == null || type.isAll() || type.isFunction() || type.isInstance() && this.invalidatingTypes.contains(type.toInstance().instanceType);
        }

        @Override
        public ImmutableSet<ConcreteType> getTypesToSkipForType(ConcreteType type) {
            return ImmutableSet.of(type);
        }

        @Override
        public boolean isTypeToSkip(ConcreteType type) {
            return type.isInstance() && !type.toInstance().isFunctionPrototype() && !type.toInstance().instanceType.isInstanceType();
        }

        @Override
        public ConcreteType restrictByNotNullOrUndefined(ConcreteType type) {
            return type;
        }

        @Override
        public Iterable<ConcreteType> getTypeAlternatives(ConcreteType type) {
            if (type.isUnion()) {
                return ((ConcreteType.ConcreteUnionType)type).getAlternatives();
            }
            return null;
        }

        @Override
        public ConcreteType getTypeWithProperty(String field, ConcreteType type) {
            if (type.isInstance()) {
                ConcreteType.ConcreteInstanceType instanceType = (ConcreteType.ConcreteInstanceType)type;
                return instanceType.getInstanceTypeWithProperty(field);
            }
            if (type.isFunction()) {
                if ("prototype".equals(field) || this.codingConvention.isSuperClassReference(field)) {
                    return type;
                }
            } else {
                if (type.isNone()) {
                    return new ConcreteType.ConcreteUniqueType(++this.nextUniqueId);
                }
                if (type.isUnion()) {
                    for (ConcreteType t : ((ConcreteType.ConcreteUnionType)type).getAlternatives()) {
                        ConcreteType ret = this.getTypeWithProperty(field, t);
                        if (ret == null) continue;
                        return ret;
                    }
                }
            }
            return null;
        }

        @Override
        public ConcreteType getInstanceFromPrototype(ConcreteType type) {
            ConcreteType.ConcreteInstanceType instanceType;
            if (type.isInstance() && (instanceType = (ConcreteType.ConcreteInstanceType)type).isFunctionPrototype()) {
                return instanceType.getConstructorType().getInstanceType();
            }
            return null;
        }

        @Override
        public void recordInterfaces(ConcreteType type, ConcreteType relatedType, Property p) {
        }
    }

    private static class JSTypeSystem
    implements TypeSystem<JSType> {
        private final Set<JSType> invalidatingTypes;
        private JSTypeRegistry registry;

        public JSTypeSystem(AbstractCompiler compiler) {
            this.registry = compiler.getTypeRegistry();
            this.invalidatingTypes = Sets.newHashSet(this.registry.getNativeType(JSTypeNative.ALL_TYPE), this.registry.getNativeType(JSTypeNative.NO_OBJECT_TYPE), this.registry.getNativeType(JSTypeNative.NO_TYPE), this.registry.getNativeType(JSTypeNative.FUNCTION_PROTOTYPE), this.registry.getNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE), this.registry.getNativeType(JSTypeNative.OBJECT_PROTOTYPE), this.registry.getNativeType(JSTypeNative.TOP_LEVEL_PROTOTYPE), this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE));
        }

        @Override
        public void addInvalidatingType(JSType type) {
            Preconditions.checkState(!type.isUnionType());
            this.invalidatingTypes.add(type);
        }

        @Override
        public StaticScope<JSType> getRootScope() {
            return null;
        }

        @Override
        public StaticScope<JSType> getFunctionScope(Node node) {
            return null;
        }

        @Override
        public JSType getType(StaticScope<JSType> scope, Node node, String prop) {
            if (node.getJSType() == null) {
                return this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            return node.getJSType();
        }

        @Override
        public boolean isInvalidatingType(JSType type) {
            if (type == null || this.invalidatingTypes.contains(type) || type.isUnknownType()) {
                return true;
            }
            ObjectType objType = ObjectType.cast(type);
            return objType != null && !objType.hasReferenceName();
        }

        @Override
        public ImmutableSet<JSType> getTypesToSkipForType(JSType type) {
            if ((type = type.restrictByNotNullOrUndefined()).isUnionType()) {
                HashSet<JSType> types = Sets.newHashSet(type);
                for (JSType alt : type.toMaybeUnionType().getAlternates()) {
                    types.addAll(this.getTypesToSkipForTypeNonUnion(type));
                }
                return ImmutableSet.copyOf(types);
            }
            if (type.isEnumElementType()) {
                return this.getTypesToSkipForType(type.toMaybeEnumElementType().getPrimitiveType());
            }
            return ImmutableSet.copyOf(this.getTypesToSkipForTypeNonUnion(type));
        }

        private Set<JSType> getTypesToSkipForTypeNonUnion(JSType type) {
            HashSet<JSType> types = Sets.newHashSet();
            JSType skipType = type;
            while (skipType != null) {
                types.add(skipType);
                ObjectType objSkipType = skipType.toObjectType();
                if (objSkipType == null) break;
                skipType = objSkipType.getImplicitPrototype();
            }
            return types;
        }

        @Override
        public boolean isTypeToSkip(JSType type) {
            return type.isEnumType() || type.autoboxesTo() != null;
        }

        @Override
        public JSType restrictByNotNullOrUndefined(JSType type) {
            return type.restrictByNotNullOrUndefined();
        }

        @Override
        public Iterable<JSType> getTypeAlternatives(JSType type) {
            if (type.isUnionType()) {
                return type.toMaybeUnionType().getAlternates();
            }
            ObjectType objType = type.toObjectType();
            if (objType != null && objType.getConstructor() != null && objType.getConstructor().isInterface()) {
                ArrayList<JSType> list = Lists.newArrayList();
                for (FunctionType impl : this.registry.getDirectImplementors(objType)) {
                    list.add(impl.getInstanceType());
                }
                return list;
            }
            return null;
        }

        @Override
        public ObjectType getTypeWithProperty(String field, JSType type) {
            ObjectType maybeType;
            if (type == null) {
                return null;
            }
            if (type.isEnumElementType()) {
                return this.getTypeWithProperty(field, type.toMaybeEnumElementType().getPrimitiveType());
            }
            if (!(type instanceof ObjectType)) {
                if (type.autoboxesTo() != null) {
                    type = type.autoboxesTo();
                } else {
                    return null;
                }
            }
            if ("prototype".equals(field)) {
                return null;
            }
            ObjectType foundType = null;
            ObjectType objType = ObjectType.cast(type);
            if (objType != null && objType.getConstructor() != null && objType.getConstructor().isInterface()) {
                ObjectType topInterface = FunctionType.getTopDefiningInterface(objType, field);
                if (topInterface != null && topInterface.getConstructor() != null) {
                    foundType = topInterface.getConstructor().getPrototype();
                }
            } else {
                while (objType != null && objType.getImplicitPrototype() != objType) {
                    if (objType.hasOwnProperty(field)) {
                        foundType = objType;
                    }
                    objType = objType.getImplicitPrototype();
                }
            }
            if (foundType == null && (maybeType = ObjectType.cast(this.registry.getGreatestSubtypeWithProperty(type, field))) != null && maybeType.hasOwnProperty(field)) {
                foundType = maybeType;
            }
            return foundType;
        }

        @Override
        public JSType getInstanceFromPrototype(JSType type) {
            ObjectType prototype;
            FunctionType owner;
            if (type.isFunctionPrototypeType() && ((owner = (prototype = (ObjectType)type).getOwnerFunction()).isConstructor() || owner.isInterface())) {
                return prototype.getOwnerFunction().getInstanceType();
            }
            return null;
        }

        @Override
        public void recordInterfaces(JSType type, JSType relatedType, Property p) {
            ObjectType objType = ObjectType.cast(type);
            if (objType != null) {
                FunctionType constructor = objType.isFunctionType() ? objType.toMaybeFunctionType() : (objType.isFunctionPrototypeType() ? objType.getOwnerFunction() : objType.getConstructor());
                while (constructor != null) {
                    for (ObjectType itype : constructor.getImplementedInterfaces()) {
                        ObjectType top = this.getTypeWithProperty(p.name, itype);
                        if (top != null) {
                            p.addType(itype, top, relatedType);
                        } else {
                            this.recordInterfaces(itype, relatedType, p);
                        }
                        if (!p.skipRenaming) continue;
                        return;
                    }
                    if (constructor.isInterface() || constructor.isConstructor()) {
                        constructor = constructor.getSuperClassConstructor();
                        continue;
                    }
                    constructor = null;
                }
            }
        }
    }

    private static interface TypeSystem<T> {
        public StaticScope<T> getRootScope();

        public StaticScope<T> getFunctionScope(Node var1);

        public T getType(StaticScope<T> var1, Node var2, String var3);

        public boolean isInvalidatingType(T var1);

        public void addInvalidatingType(JSType var1);

        public ImmutableSet<T> getTypesToSkipForType(T var1);

        public boolean isTypeToSkip(T var1);

        public T restrictByNotNullOrUndefined(T var1);

        public Iterable<T> getTypeAlternatives(T var1);

        public T getTypeWithProperty(String var1, T var2);

        public T getInstanceFromPrototype(T var1);

        public void recordInterfaces(T var1, T var2, Property var3);
    }

    private class FindRenameableProperties
    extends AbstractScopingCallback {
        private FindRenameableProperties() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isGetProp()) {
                this.handleGetProp(t, n);
            } else if (n.isObjectLit()) {
                this.handleObjectLit(t, n);
            }
        }

        private void handleGetProp(NodeTraversal t, Node n) {
            String name = n.getLastChild().getString();
            Object type = DisambiguateProperties.this.typeSystem.getType(this.getScope(), n.getFirstChild(), name);
            Property prop = DisambiguateProperties.this.getProperty(name);
            if (!prop.scheduleRenaming(n.getLastChild(), this.processProperty(t, prop, type, null)) && DisambiguateProperties.this.propertiesToErrorFor.containsKey(name)) {
                String suggestion = "";
                if (type instanceof JSType) {
                    JSType jsType = (JSType)type;
                    String qName = n.getFirstChild().getQualifiedName();
                    if (jsType.isAllType() || jsType.isUnknownType()) {
                        suggestion = n.getFirstChild().isThis() ? "The \"this\" object is unknown in the function,consider using @this" : "Consider casting " + qName + " if you know it's type.";
                    } else {
                        StringBuilder sb = new StringBuilder();
                        this.printErrorLocations(sb, jsType);
                        if (sb.length() != 0) {
                            suggestion = "Consider fixing errors for the following types: ";
                            suggestion = suggestion + sb.toString();
                        }
                    }
                }
                DisambiguateProperties.this.compiler.report(JSError.make(t.getSourceName(), n, (CheckLevel)((Object)DisambiguateProperties.this.propertiesToErrorFor.get(name)), Warnings.INVALIDATION, name, type == null ? "null" : type.toString(), n.toString(), suggestion));
            }
        }

        private void handleObjectLit(NodeTraversal t, Node n) {
            for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                String name = child.getString();
                Object type = DisambiguateProperties.this.typeSystem.getType(this.getScope(), n, name);
                Property prop = DisambiguateProperties.this.getProperty(name);
                if (prop.scheduleRenaming(child, this.processProperty(t, prop, type, null)) || !DisambiguateProperties.this.propertiesToErrorFor.containsKey(name)) continue;
                DisambiguateProperties.this.compiler.report(JSError.make(t.getSourceName(), child, (CheckLevel)((Object)DisambiguateProperties.this.propertiesToErrorFor.get(name)), Warnings.INVALIDATION, name, type == null ? "null" : type.toString(), n.toString(), ""));
            }
        }

        private void printErrorLocations(StringBuilder sb, JSType t) {
            if (!t.isObject() || t.isAllType() || t.isUnionType()) {
                return;
            }
            if (t.isUnionType()) {
                for (JSType alt : t.toMaybeUnionType().getAlternates()) {
                    this.printErrorLocations(sb, alt);
                }
                return;
            }
            for (JSError error : DisambiguateProperties.this.invalidationMap.get(t)) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(t.toString());
                sb.append(" at ");
                sb.append(error.sourceName);
                sb.append(":");
                sb.append(error.lineNumber);
            }
        }

        private T processProperty(NodeTraversal t, Property prop, T type, T relatedType) {
            type = DisambiguateProperties.this.typeSystem.restrictByNotNullOrUndefined(type);
            if (prop.skipRenaming || DisambiguateProperties.this.typeSystem.isInvalidatingType(type)) {
                return null;
            }
            Iterable alternatives = DisambiguateProperties.this.typeSystem.getTypeAlternatives(type);
            if (alternatives != null) {
                Object firstType = relatedType;
                for (Object subType : alternatives) {
                    Object lastType = this.processProperty(t, prop, subType, firstType);
                    if (lastType == null) continue;
                    firstType = firstType == null ? lastType : firstType;
                }
                return firstType;
            }
            Object topType = DisambiguateProperties.this.typeSystem.getTypeWithProperty(prop.name, type);
            if (DisambiguateProperties.this.typeSystem.isInvalidatingType(topType)) {
                return null;
            }
            prop.addType(type, topType, relatedType);
            return topType;
        }
    }

    private class FindExternProperties
    extends AbstractScopingCallback {
        private FindExternProperties() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isGetProp()) {
                String field = n.getLastChild().getString();
                Object type = DisambiguateProperties.this.typeSystem.getType(this.getScope(), n.getFirstChild(), field);
                Property prop = DisambiguateProperties.this.getProperty(field);
                if (DisambiguateProperties.this.typeSystem.isInvalidatingType(type)) {
                    prop.invalidate();
                } else {
                    prop.addTypeToSkip(type);
                    type = DisambiguateProperties.this.typeSystem.getInstanceFromPrototype(type);
                    if (type != null) {
                        prop.getTypes().add(type);
                        prop.typesToSkip.add(type);
                    }
                }
            }
        }
    }

    private abstract class AbstractScopingCallback
    implements NodeTraversal.ScopedCallback {
        protected final Stack<StaticScope<T>> scopes = new Stack();

        private AbstractScopingCallback() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return true;
        }

        @Override
        public void enterScope(NodeTraversal t) {
            if (t.inGlobalScope()) {
                this.scopes.push(DisambiguateProperties.this.typeSystem.getRootScope());
            } else {
                this.scopes.push(DisambiguateProperties.this.typeSystem.getFunctionScope(t.getScopeRoot()));
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
            this.scopes.pop();
        }

        protected StaticScope<T> getScope() {
            return this.scopes.peek();
        }
    }

    private class Property {
        final String name;
        private UnionFind<T> types;
        Set<T> typesToSkip = Sets.newHashSet();
        boolean skipRenaming;
        Set<Node> renameNodes = Sets.newHashSet();
        final Map<Node, T> rootTypes = Maps.newHashMap();

        Property(String name) {
            this.name = name;
        }

        UnionFind<T> getTypes() {
            if (this.types == null) {
                this.types = new StandardUnionFind();
            }
            return this.types;
        }

        boolean addType(T type, T top, T relatedType) {
            Preconditions.checkState(!this.skipRenaming, "Attempt to record skipped property: %s", this.name);
            if (DisambiguateProperties.this.typeSystem.isInvalidatingType(top)) {
                this.invalidate();
                return false;
            }
            if (DisambiguateProperties.this.typeSystem.isTypeToSkip(top)) {
                this.addTypeToSkip(top);
            }
            if (relatedType == null) {
                this.getTypes().add(top);
            } else {
                this.getTypes().union(top, relatedType);
            }
            DisambiguateProperties.this.typeSystem.recordInterfaces(type, top, this);
            return true;
        }

        void addTypeToSkip(T type) {
            for (Object skipType : DisambiguateProperties.this.typeSystem.getTypesToSkipForType(type)) {
                this.typesToSkip.add(skipType);
                this.getTypes().union(skipType, type);
            }
        }

        void expandTypesToSkip() {
            block4: {
                int originalTypesSize;
                if (!this.shouldRename()) break block4;
                int count = 0;
                do {
                    Preconditions.checkState(++count < 10, "Stuck in loop expanding types to skip.");
                    HashSet rootTypesToSkip = Sets.newHashSet();
                    for (Object subType : this.typesToSkip) {
                        rootTypesToSkip.add(this.types.find(subType));
                    }
                    this.typesToSkip.addAll(rootTypesToSkip);
                    HashSet<Object> newTypesToSkip = Sets.newHashSet();
                    Set allTypes = this.types.elements();
                    originalTypesSize = allTypes.size();
                    for (Object subType : allTypes) {
                        if (this.typesToSkip.contains(subType) || !this.typesToSkip.contains(this.types.find(subType))) continue;
                        newTypesToSkip.add(subType);
                    }
                    for (Object newType : newTypesToSkip) {
                        this.addTypeToSkip(newType);
                    }
                } while (this.types.elements().size() != originalTypesSize);
            }
        }

        boolean shouldRename() {
            return !this.skipRenaming && this.types != null && this.types.allEquivalenceClasses().size() > 1;
        }

        boolean shouldRename(T type) {
            return !this.skipRenaming && !this.typesToSkip.contains(type);
        }

        boolean invalidate() {
            boolean changed = !this.skipRenaming;
            this.skipRenaming = true;
            this.types = null;
            return changed;
        }

        boolean scheduleRenaming(Node node, T type) {
            if (!this.skipRenaming) {
                if (DisambiguateProperties.this.typeSystem.isInvalidatingType(type)) {
                    this.invalidate();
                    return false;
                }
                this.renameNodes.add(node);
                this.rootTypes.put(node, type);
            }
            return true;
        }
    }

    static class Warnings {
        static final DiagnosticType INVALIDATION = DiagnosticType.disabled("JSC_INVALIDATION", "Property disambiguator skipping all instances of property {0} because of type {1} node {2}. {3}");

        Warnings() {
        }
    }
}

