/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import java.io.Serializable;
import java.text.MessageFormat;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CheckLevel;

public class DiagnosticType
implements Serializable,
Comparable<DiagnosticType> {
    public final String key;
    public final MessageFormat format;
    public final CheckLevel defaultLevel;
    public CheckLevel level;

    public static DiagnosticType error(String name, String descriptionFormat) {
        return DiagnosticType.make(name, CheckLevel.ERROR, descriptionFormat);
    }

    public static DiagnosticType warning(String name, String descriptionFormat) {
        return DiagnosticType.make(name, CheckLevel.WARNING, descriptionFormat);
    }

    public static DiagnosticType disabled(String name, String descriptionFormat) {
        return DiagnosticType.make(name, CheckLevel.OFF, descriptionFormat);
    }

    public static DiagnosticType make(String name, CheckLevel level, String descriptionFormat) {
        return new DiagnosticType(name, level, new MessageFormat(descriptionFormat));
    }

    private DiagnosticType(String key, CheckLevel level, MessageFormat format) {
        this.key = key;
        this.defaultLevel = level;
        this.format = format;
        this.level = this.defaultLevel;
    }

    public boolean equals(Object type) {
        return type instanceof DiagnosticType && ((DiagnosticType)type).key.equals(this.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public int compareTo(DiagnosticType diagnosticType) {
        return this.key.compareTo(diagnosticType.key);
    }

    public String toString() {
        return this.key + ": " + this.format.toPattern();
    }
}

