/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.collect.ImmutableSet;
import closurecompiler.internal.com.google.common.collect.Maps;
import closurecompiler.internal.com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DiagnosticType;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSError;

public class DiagnosticGroup
implements Serializable {
    private final Set<DiagnosticType> types;
    private final String name;
    private static final Map<DiagnosticType, DiagnosticGroup> singletons = Maps.newHashMap();

    DiagnosticGroup(String name, DiagnosticType ... types) {
        this.name = name;
        this.types = ImmutableSet.copyOf(Arrays.asList(types));
    }

    public DiagnosticGroup(DiagnosticType ... types) {
        this((String)null, types);
    }

    private DiagnosticGroup(DiagnosticType type) {
        this.name = null;
        this.types = ImmutableSet.of(type);
    }

    public static DiagnosticGroup forType(DiagnosticType type) {
        if (!singletons.containsKey(type)) {
            singletons.put(type, new DiagnosticGroup(type));
        }
        return singletons.get(type);
    }

    public DiagnosticGroup(DiagnosticGroup ... groups) {
        this((String)null, groups);
    }

    public DiagnosticGroup(String name, DiagnosticGroup ... groups) {
        HashSet<DiagnosticType> set = Sets.newHashSet();
        for (DiagnosticGroup group : groups) {
            set.addAll(group.types);
        }
        this.name = name;
        this.types = ImmutableSet.copyOf(set);
    }

    public boolean matches(JSError error) {
        return this.matches(error.getType());
    }

    public boolean matches(DiagnosticType type) {
        return this.types.contains(type);
    }

    boolean isSubGroup(DiagnosticGroup group) {
        for (DiagnosticType type : group.types) {
            if (this.matches(type)) continue;
            return false;
        }
        return true;
    }

    public Iterable<DiagnosticType> getTypes() {
        return this.types;
    }

    public String toString() {
        return this.name == null ? super.toString() : "DiagnosticGroup<" + this.name + ">";
    }
}

