/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CodingConvention;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DefinitionSite;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DefinitionsRemover;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSModule;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSModuleGraph;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.OptimizeCalls;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.SimpleDefinitionFinder;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.SpecializationAwareCompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.SpecializeModule;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.UseSite;
import org.jetbrains.jet.internal.com.google.javascript.rhino.IR;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.FunctionType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSTypeNative;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSTypeRegistry;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.ObjectType;

class DevirtualizePrototypeMethods
implements OptimizeCalls.CallGraphCompilerPass,
SpecializationAwareCompilerPass {
    private final AbstractCompiler compiler;
    private SpecializeModule.SpecializationState specializationState;

    DevirtualizePrototypeMethods(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void enableSpecialization(SpecializeModule.SpecializationState state) {
        this.specializationState = state;
    }

    @Override
    public void process(Node externs, Node root) {
        SimpleDefinitionFinder defFinder = new SimpleDefinitionFinder(this.compiler);
        defFinder.process(externs, root);
        this.process(externs, root, defFinder);
    }

    @Override
    public void process(Node externs, Node root, SimpleDefinitionFinder definitions) {
        for (DefinitionSite defSite : definitions.getDefinitionSites()) {
            this.rewriteDefinitionIfEligible(defSite, definitions);
        }
    }

    private static boolean isCall(UseSite site) {
        Node node = site.node;
        Node parent = node.getParent();
        return parent.getFirstChild() == node && parent.isCall();
    }

    private static boolean isPrototypeMethodDefinition(Node node) {
        Node parent = node.getParent();
        if (parent == null) {
            return false;
        }
        Node gramp = parent.getParent();
        if (gramp == null || parent.getFirstChild() != node || !NodeUtil.isExprAssign(gramp)) {
            return false;
        }
        Node functionNode = parent.getLastChild();
        if (functionNode == null || !functionNode.isFunction()) {
            return false;
        }
        if (!node.isGetProp()) {
            return false;
        }
        Node nameNode = node.getFirstChild();
        return nameNode.isGetProp() && nameNode.getLastChild().getString().equals("prototype");
    }

    private String getRewrittenMethodName(String orginalMethodName) {
        return "JSCompiler_StaticMethods_" + orginalMethodName;
    }

    private void rewriteDefinitionIfEligible(DefinitionSite defSite, SimpleDefinitionFinder defFinder) {
        if (defSite.inExterns || !defSite.inGlobalScope || !this.isEligibleDefinition(defFinder, defSite)) {
            return;
        }
        Node node = defSite.node;
        if (!DevirtualizePrototypeMethods.isPrototypeMethodDefinition(node)) {
            return;
        }
        for (Node ancestor = node.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            if (!NodeUtil.isControlStructure(ancestor)) continue;
            return;
        }
        String newMethodName = this.getRewrittenMethodName(node.getLastChild().getString());
        this.rewriteDefinition(node, newMethodName);
        this.rewriteCallSites(defFinder, defSite.definition, newMethodName);
    }

    private boolean isEligibleDefinition(SimpleDefinitionFinder defFinder, DefinitionSite definitionSite) {
        DefinitionsRemover.Definition definition = definitionSite.definition;
        JSModule definitionModule = definitionSite.module;
        Node rValue = definition.getRValue();
        if (rValue == null || !rValue.isFunction() || NodeUtil.isVarArgsFunction(rValue)) {
            return false;
        }
        Node lValue = definition.getLValue();
        if (lValue == null || !lValue.isGetProp()) {
            return false;
        }
        CodingConvention codingConvention = this.compiler.getCodingConvention();
        if (codingConvention.isExported(lValue.getLastChild().getString())) {
            return false;
        }
        Collection<UseSite> useSites = defFinder.getUseSites(definition);
        if (useSites.isEmpty()) {
            return false;
        }
        JSModuleGraph moduleGraph = this.compiler.getModuleGraph();
        for (UseSite site : useSites) {
            if (!DevirtualizePrototypeMethods.isCall(site)) {
                return false;
            }
            Node nameNode = site.node;
            if (this.specializationState != null && !this.specializationState.canFixupSpecializedFunctionContainingNode(nameNode)) {
                return false;
            }
            Collection<DefinitionsRemover.Definition> singleSiteDefinitions = defFinder.getDefinitionsReferencedAt(nameNode);
            if (singleSiteDefinitions.size() > 1) {
                return false;
            }
            Preconditions.checkState(!singleSiteDefinitions.isEmpty());
            Preconditions.checkState(singleSiteDefinitions.contains(definition));
            JSModule callModule = site.module;
            if (definitionModule == callModule || callModule != null && moduleGraph.dependsOn(callModule, definitionModule)) continue;
            return false;
        }
        return true;
    }

    private void rewriteCallSites(SimpleDefinitionFinder defFinder, DefinitionsRemover.Definition definition, String newMethodName) {
        Collection<UseSite> useSites = defFinder.getUseSites(definition);
        for (UseSite site : useSites) {
            Node node = site.node;
            Node parent = node.getParent();
            Node objectNode = node.getFirstChild();
            node.removeChild(objectNode);
            parent.replaceChild(node, objectNode);
            parent.addChildToFront(IR.name(newMethodName).srcref(node));
            Preconditions.checkState(parent.isCall());
            parent.putBooleanProp(50, true);
            this.compiler.reportCodeChange();
            if (this.specializationState == null) continue;
            this.specializationState.reportSpecializedFunctionContainingNode(parent);
        }
    }

    private void rewriteDefinition(Node node, String newMethodName) {
        Node parent = node.getParent();
        Node functionNode = parent.getLastChild();
        Node expr = parent.getParent();
        Node block = expr.getParent();
        Node newNameNode = IR.name(newMethodName).copyInformationFrom(parent.getFirstChild());
        if (this.specializationState != null) {
            this.specializationState.reportRemovedFunction(functionNode, block);
        }
        parent.removeChild(functionNode);
        newNameNode.addChildToFront(functionNode);
        block.replaceChild(expr, IR.var(newNameNode));
        String self = newMethodName + "$self";
        Node argList = functionNode.getFirstChild().getNext();
        argList.addChildToFront(IR.name(self).copyInformationFrom(functionNode));
        Node body = functionNode.getLastChild();
        this.replaceReferencesToThis(body, self);
        this.fixFunctionType(functionNode);
        this.compiler.reportCodeChange();
    }

    private void fixFunctionType(Node functionNode) {
        FunctionType type = JSType.toMaybeFunctionType(functionNode.getJSType());
        if (type != null) {
            JSTypeRegistry typeRegistry = this.compiler.getTypeRegistry();
            ArrayList<JSType> parameterTypes = Lists.newArrayList();
            parameterTypes.add(type.getTypeOfThis());
            for (Node param : type.getParameters()) {
                parameterTypes.add(param.getJSType());
            }
            ObjectType thisType = typeRegistry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
            JSType returnType = type.getReturnType();
            JSType newType = typeRegistry.createFunctionType(thisType, returnType, parameterTypes);
            functionNode.setJSType(newType);
        }
    }

    private void replaceReferencesToThis(Node node, String name) {
        if (node.isFunction()) {
            return;
        }
        for (Node child : node.children()) {
            if (child.isThis()) {
                Node newName = IR.name(name);
                newName.setJSType(child.getJSType());
                node.replaceChild(child, newName);
                continue;
            }
            this.replaceReferencesToThis(child, name);
        }
    }
}

