/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.rhino.IR;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Token;

class DefinitionsRemover {
    DefinitionsRemover() {
    }

    static Definition getDefinition(Node n, boolean isExtern) {
        Node parent = n.getParent();
        if (parent == null) {
            return null;
        }
        if (NodeUtil.isVarDeclaration(n) && n.hasChildren()) {
            return new VarDefinition(n, isExtern);
        }
        if (parent.isFunction() && parent.getFirstChild() == n) {
            if (!NodeUtil.isFunctionExpression(parent)) {
                return new NamedFunctionDefinition(parent, isExtern);
            }
            if (!n.getString().equals("")) {
                return new FunctionExpressionDefinition(parent, isExtern);
            }
        } else {
            if (parent.isAssign() && parent.getFirstChild() == n) {
                return new AssignmentDefinition(parent, isExtern);
            }
            if (NodeUtil.isObjectLitKey(n, parent)) {
                return new ObjectLiteralPropertyDefinition(parent, n, n.getFirstChild(), isExtern);
            }
            if (parent.isParamList()) {
                Node function = parent.getParent();
                return new FunctionArgumentDefinition(function, n, isExtern);
            }
        }
        return null;
    }

    static boolean isDefinitionNode(Node n) {
        Node parent = n.getParent();
        if (parent == null) {
            return false;
        }
        if (NodeUtil.isVarDeclaration(n) && n.hasChildren()) {
            return true;
        }
        if (parent.isFunction() && parent.getFirstChild() == n) {
            if (!NodeUtil.isFunctionExpression(parent)) {
                return true;
            }
            if (!n.getString().equals("")) {
                return true;
            }
        } else {
            if (parent.isAssign() && parent.getFirstChild() == n) {
                return true;
            }
            if (NodeUtil.isObjectLitKey(n, parent)) {
                return true;
            }
            if (parent.isParamList()) {
                return true;
            }
        }
        return false;
    }

    static final class VarDefinition
    extends Definition {
        private final Node name;

        VarDefinition(Node node, boolean inExterns) {
            super(inExterns);
            Preconditions.checkArgument(NodeUtil.isVarDeclaration(node));
            Preconditions.checkArgument(node.hasChildren(), "VAR Declaration of %sshould be assigned a value.", node.getString());
            this.name = node;
        }

        @Override
        public void performRemove() {
            Node var = this.name.getParent();
            Preconditions.checkState(var.getFirstChild() == var.getLastChild(), "AST should be normalized first");
            Node parent = var.getParent();
            Node rValue = this.name.removeFirstChild();
            Preconditions.checkState(!parent.isFor());
            parent.replaceChild(var, NodeUtil.newExpr(rValue));
        }

        @Override
        public Node getLValue() {
            return this.name;
        }

        @Override
        public Node getRValue() {
            return this.name.getFirstChild();
        }
    }

    static final class ObjectLiteralPropertyDefinition
    extends Definition {
        private final Node literal;
        private final Node name;
        private final Node value;

        ObjectLiteralPropertyDefinition(Node lit, Node name, Node value, boolean isExtern) {
            super(isExtern);
            this.literal = lit;
            this.name = name;
            this.value = value;
        }

        @Override
        public void performRemove() {
            this.literal.removeChild(this.name);
        }

        @Override
        public Node getLValue() {
            switch (this.name.getType()) {
                case 40: 
                case 147: 
                case 148: {
                    return IR.getprop(IR.objectlit(new Node[0]), IR.string(this.name.getString()));
                }
            }
            throw new IllegalStateException("unexpected");
        }

        @Override
        public Node getRValue() {
            return this.value;
        }
    }

    static final class AssignmentDefinition
    extends Definition {
        private final Node assignment;

        AssignmentDefinition(Node node, boolean inExterns) {
            super(inExterns);
            Preconditions.checkArgument(node.isAssign());
            this.assignment = node;
        }

        @Override
        public void performRemove() {
            Node parent = this.assignment.getParent();
            Node last = this.assignment.getLastChild();
            this.assignment.removeChild(last);
            parent.replaceChild(this.assignment, last);
        }

        @Override
        public Node getLValue() {
            return this.assignment.getFirstChild();
        }

        @Override
        public Node getRValue() {
            return this.assignment.getLastChild();
        }
    }

    static final class FunctionExpressionDefinition
    extends FunctionDefinition {
        FunctionExpressionDefinition(Node node, boolean inExterns) {
            super(node, inExterns);
            Preconditions.checkArgument(NodeUtil.isFunctionExpression(node));
        }

        @Override
        public void performRemove() {
            this.function.replaceChild(this.function.getFirstChild(), IR.name(""));
        }
    }

    static final class NamedFunctionDefinition
    extends FunctionDefinition {
        NamedFunctionDefinition(Node node, boolean inExterns) {
            super(node, inExterns);
        }

        @Override
        public void performRemove() {
            this.function.detachFromParent();
        }
    }

    static abstract class FunctionDefinition
    extends Definition {
        protected final Node function;

        FunctionDefinition(Node node, boolean inExterns) {
            super(inExterns);
            Preconditions.checkArgument(node.isFunction());
            this.function = node;
        }

        @Override
        public Node getLValue() {
            return this.function.getFirstChild();
        }

        @Override
        public Node getRValue() {
            return this.function;
        }
    }

    static final class FunctionArgumentDefinition
    extends IncompleteDefinition {
        FunctionArgumentDefinition(Node function, Node argumentName, boolean inExterns) {
            super(argumentName, inExterns);
            Preconditions.checkArgument(function.isFunction());
            Preconditions.checkArgument(argumentName.isName());
        }

        @Override
        public void performRemove() {
            throw new IllegalArgumentException("Can't remove a FunctionArgumentDefinition");
        }
    }

    static final class ExternalNameOnlyDefinition
    extends IncompleteDefinition {
        ExternalNameOnlyDefinition(Node lValue) {
            super(lValue, true);
        }

        @Override
        public void performRemove() {
            throw new IllegalArgumentException("Can't remove external name-only definition");
        }
    }

    static final class UnknownDefinition
    extends IncompleteDefinition {
        UnknownDefinition(Node lValue, boolean inExterns) {
            super(lValue, inExterns);
        }

        @Override
        public void performRemove() {
            throw new IllegalArgumentException("Can't remove an UnknownDefinition");
        }
    }

    static abstract class IncompleteDefinition
    extends Definition {
        private static final Set<Integer> ALLOWED_TYPES = ImmutableSet.of(Integer.valueOf(38), Integer.valueOf(33), Integer.valueOf(35));
        private final Node lValue;

        IncompleteDefinition(Node lValue, boolean inExterns) {
            super(inExterns);
            Preconditions.checkNotNull(lValue);
            Preconditions.checkArgument(ALLOWED_TYPES.contains(lValue.getType()), "Unexpected lValue type %s", Token.name(lValue.getType()));
            this.lValue = lValue;
        }

        @Override
        public Node getLValue() {
            return this.lValue;
        }

        @Override
        public Node getRValue() {
            return null;
        }
    }

    static abstract class Definition {
        private final boolean isExtern;

        Definition(boolean isExtern) {
            this.isExtern = isExtern;
        }

        public void remove() {
            if (this.isExtern) {
                throw new IllegalStateException("Attempt to remove() an extern definition.");
            }
            this.performRemove();
        }

        protected abstract void performRemove();

        public abstract Node getLValue();

        public abstract Node getRValue();

        public boolean isExtern() {
            return this.isExtern;
        }
    }
}

