/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AnalyzePrototypeProperties;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DiagnosticType;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSError;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSModule;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSModuleGraph;
import org.jetbrains.jet.internal.com.google.javascript.rhino.IR;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class CrossModuleMethodMotion
implements CompilerPass {
    static final DiagnosticType NULL_COMMON_MODULE_ERROR = DiagnosticType.error("JSC_INTERNAL_ERROR_MODULE_DEPEND", "null deepest common module");
    private final AbstractCompiler compiler;
    private final IdGenerator idGenerator;
    private final AnalyzePrototypeProperties analyzer;
    private final JSModuleGraph moduleGraph;

    CrossModuleMethodMotion(AbstractCompiler compiler, IdGenerator idGenerator, boolean canModifyExterns) {
        this.compiler = compiler;
        this.idGenerator = idGenerator;
        this.moduleGraph = compiler.getModuleGraph();
        this.analyzer = new AnalyzePrototypeProperties(compiler, this.moduleGraph, canModifyExterns, false);
    }

    @Override
    public void process(Node externRoot, Node root) {
        if (this.moduleGraph != null && this.moduleGraph.getModuleCount() > 1) {
            this.analyzer.process(externRoot, root);
            this.moveMethods(this.analyzer.getAllNameInfo());
        }
    }

    private void moveMethods(Collection<AnalyzePrototypeProperties.NameInfo> allNameInfo) {
        boolean hasStubDeclaration = this.idGenerator.hasGeneratedAnyIds();
        for (AnalyzePrototypeProperties.NameInfo nameInfo : allNameInfo) {
            if (!nameInfo.isReferenced() || nameInfo.readsClosureVariables()) continue;
            JSModule deepestCommonModuleRef = nameInfo.getDeepestCommonModuleRef();
            if (deepestCommonModuleRef == null) {
                this.compiler.report(JSError.make(NULL_COMMON_MODULE_ERROR, new String[0]));
                continue;
            }
            Iterator<AnalyzePrototypeProperties.Symbol> declarations = nameInfo.getDeclarations().descendingIterator();
            while (declarations.hasNext()) {
                Node valueParent;
                AnalyzePrototypeProperties.Property prop;
                AnalyzePrototypeProperties.Symbol symbol = declarations.next();
                if (!(symbol instanceof AnalyzePrototypeProperties.Property) || (prop = (AnalyzePrototypeProperties.Property)symbol).getRootVar() == null || !prop.getRootVar().isGlobal()) continue;
                Node value = prop.getValue();
                if (!this.moduleGraph.dependsOn(deepestCommonModuleRef, prop.getModule()) || !value.isFunction() || (valueParent = value.getParent()).isGetterDef() || valueParent.isSetterDef()) continue;
                Node proto = prop.getPrototype();
                int stubId = this.idGenerator.newId();
                Node stubCall = IR.call(IR.name("JSCompiler_stubMethod"), IR.number(stubId)).copyInformationFromForTree(value);
                stubCall.putBooleanProp(50, true);
                valueParent.replaceChild(value, stubCall);
                Node unstubParent = this.compiler.getNodeForCodeInsertion(deepestCommonModuleRef);
                Node unstubCall = IR.call(IR.name("JSCompiler_unstubMethod"), IR.number(stubId), value);
                unstubCall.putBooleanProp(50, true);
                unstubParent.addChildToFront(IR.exprResult(IR.assign(IR.getprop(proto.cloneTree(), IR.string(nameInfo.name)), unstubCall)).copyInformationFromForTree(value));
                this.compiler.reportCodeChange();
            }
        }
        if (!hasStubDeclaration && this.idGenerator.hasGeneratedAnyIds()) {
            Node declarations = this.compiler.parseSyntheticCode("var JSCompiler_stubMap = [];function JSCompiler_stubMethod(JSCompiler_stubMethod_id) {  return function() {    return JSCompiler_stubMap[JSCompiler_stubMethod_id].apply(        this, arguments);  };}function JSCompiler_unstubMethod(    JSCompiler_unstubMethod_id, JSCompiler_unstubMethod_body) {  return JSCompiler_stubMap[JSCompiler_unstubMethod_id] =       JSCompiler_unstubMethod_body;}");
            this.compiler.getNodeForCodeInsertion(null).addChildrenToFront(declarations.removeChildren());
        }
    }

    static class IdGenerator
    implements Serializable {
        private int currentId = 0;

        IdGenerator() {
        }

        boolean hasGeneratedAnyIds() {
            return this.currentId != 0;
        }

        int newId() {
            return this.currentId++;
        }
    }
}

