/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import java.util.Comparator;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.graph.DiGraph;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class ControlFlowGraph<N>
extends LinkedDirectedGraph<N, Branch> {
    private final DiGraph.DiGraphNode<N, Branch> implicitReturn = this.createDirectedGraphNode(null);
    private final DiGraph.DiGraphNode<N, Branch> entry;

    ControlFlowGraph(N entry, boolean nodeAnnotations, boolean edgeAnnotations) {
        super(nodeAnnotations, edgeAnnotations);
        this.entry = this.createDirectedGraphNode(entry);
    }

    public DiGraph.DiGraphNode<N, Branch> getImplicitReturn() {
        return this.implicitReturn;
    }

    public DiGraph.DiGraphNode<N, Branch> getEntry() {
        return this.entry;
    }

    public boolean isImplicitReturn(DiGraph.DiGraphNode<N, Branch> node) {
        return node == this.implicitReturn;
    }

    public void connectToImplicitReturn(N srcValue, Branch edgeValue) {
        super.connect(srcValue, edgeValue, null);
    }

    public Comparator<DiGraph.DiGraphNode<N, Branch>> getOptionalNodeComparator(boolean isForward) {
        return null;
    }

    public static boolean isEnteringNewCfgNode(Node n) {
        Node parent = n.getParent();
        switch (parent.getType()) {
            case 77: 
            case 125: 
            case 132: {
                return true;
            }
            case 105: {
                return n != parent.getFirstChild().getNext();
            }
            case 108: 
            case 113: 
            case 114: {
                return NodeUtil.getConditionExpression(parent) != n;
            }
            case 115: {
                if (NodeUtil.isForIn(parent)) {
                    return n == parent.getLastChild();
                }
                return NodeUtil.getConditionExpression(parent) != n;
            }
            case 110: 
            case 111: 
            case 119: 
            case 120: {
                return n != parent.getFirstChild();
            }
        }
        return false;
    }

    public static abstract class AbstractCfgNodeTraversalCallback
    implements NodeTraversal.Callback {
        @Override
        public final boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            if (parent == null) {
                return true;
            }
            return !ControlFlowGraph.isEnteringNewCfgNode(n);
        }
    }

    public static enum Branch {
        ON_TRUE,
        ON_FALSE,
        UNCOND,
        ON_EX,
        SYN_BLOCK;


        public boolean isConditional() {
            return this == ON_TRUE || this == ON_FALSE;
        }
    }
}

