/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Joiner;
import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.Lists;
import closurecompiler.internal.com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.LatticeElement;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.FunctionType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSTypeRegistry;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.ObjectType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.StaticScope;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.StaticSlot;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.UnknownType;

abstract class ConcreteType
implements LatticeElement {
    static final ConcreteType NONE = new ConcreteNoneType();
    static final ConcreteType ALL = new ConcreteAll();
    private static final List<ConcreteFunctionType> NO_FUNCTIONS = Lists.newArrayList();
    private static final List<ConcreteInstanceType> NO_INSTANCES = Lists.newArrayList();
    private static final List<StaticSlot<ConcreteType>> NO_SLOTS = Lists.newArrayList();

    ConcreteType() {
    }

    protected static ConcreteType createForTypes(Collection<ConcreteType> types) {
        if (types == null || types.size() == 0) {
            return NONE;
        }
        if (types.size() == 1) {
            return types.iterator().next();
        }
        return new ConcreteUnionType(Sets.newHashSet(types));
    }

    boolean isNone() {
        return false;
    }

    boolean isFunction() {
        return false;
    }

    boolean isInstance() {
        return false;
    }

    boolean isUnion() {
        return false;
    }

    boolean isAll() {
        return false;
    }

    boolean isSingleton() {
        return !this.isNone() && !this.isUnion() && !this.isAll();
    }

    ConcreteFunctionType toFunction() {
        return null;
    }

    ConcreteInstanceType toInstance() {
        return null;
    }

    ConcreteUnionType toUnion() {
        return null;
    }

    StaticScope<ConcreteType> getScope() {
        return null;
    }

    ConcreteType unionWith(ConcreteType other) {
        Preconditions.checkState(this.isSingleton());
        if (!other.isSingleton()) {
            return other.unionWith(this);
        }
        if (this.equals(other)) {
            return this;
        }
        return new ConcreteUnionType(this, other);
    }

    ConcreteType intersectWith(ConcreteType other) {
        if (!other.isSingleton()) {
            return other.intersectWith(this);
        }
        if (this.equals(other)) {
            return this;
        }
        return NONE;
    }

    private <C> List<C> getMatchingTypes(TypeFilter<C> filter) {
        Object type = null;
        if (this.isUnion()) {
            ArrayList<Object> list = Lists.newArrayList();
            for (ConcreteType alt : this.toUnion().getAlternatives()) {
                C c = filter.filter(alt);
                type = c;
                if (c == null) continue;
                list.add(type);
            }
            return list;
        }
        C c = filter.filter(this);
        type = c;
        if (c != null) {
            ArrayList<Object> list = Lists.newArrayList();
            list.add(type);
            return list;
        }
        return filter.emptyList;
    }

    List<ConcreteFunctionType> getFunctions() {
        return this.getMatchingTypes(new TypeFilter<ConcreteFunctionType>(NO_FUNCTIONS){

            @Override
            public ConcreteFunctionType filter(ConcreteType type) {
                return type.isFunction() ? type.toFunction() : null;
            }
        });
    }

    List<ConcreteInstanceType> getInstances() {
        return this.getMatchingTypes(new TypeFilter<ConcreteInstanceType>(NO_INSTANCES){

            @Override
            public ConcreteInstanceType filter(ConcreteType type) {
                return type.isInstance() ? type.toInstance() : null;
            }
        });
    }

    List<ConcreteInstanceType> getFunctionInstanceTypes() {
        return this.getMatchingTypes(new TypeFilter<ConcreteInstanceType>(NO_INSTANCES){

            @Override
            public ConcreteInstanceType filter(ConcreteType type) {
                if (type.isFunction()) {
                    return type.toFunction().getInstanceType();
                }
                return null;
            }
        });
    }

    List<ConcreteInstanceType> getPrototypeTypes() {
        return this.getMatchingTypes(new TypeFilter<ConcreteInstanceType>(NO_INSTANCES){

            @Override
            public ConcreteInstanceType filter(ConcreteType type) {
                if (type.isInstance() && type.toInstance().isFunctionPrototype()) {
                    return type.toInstance();
                }
                return null;
            }
        });
    }

    List<ConcreteFunctionType> getSuperclassTypes() {
        return this.getMatchingTypes(new TypeFilter<ConcreteFunctionType>(NO_FUNCTIONS){

            @Override
            public ConcreteFunctionType filter(ConcreteType type) {
                return type.isFunction() && type.toFunction().getSuperclassType() != null ? type.toFunction().getSuperclassType() : null;
            }
        });
    }

    List<StaticSlot<ConcreteType>> getPropertySlots(final String name) {
        return this.getMatchingTypes(new TypeFilter<StaticSlot<ConcreteType>>(NO_SLOTS){

            @Override
            public StaticSlot<ConcreteType> filter(ConcreteType type) {
                StaticSlot<ConcreteType> slot = null;
                if (type.isInstance()) {
                    slot = type.toInstance().getPropertySlot(name);
                }
                return slot;
            }
        });
    }

    ConcreteType getPropertyType(String name) {
        ConcreteType ret = NONE;
        for (StaticSlot<ConcreteType> slot : this.getPropertySlots(name)) {
            ret = ret.unionWith(slot.getType());
        }
        return ret;
    }

    static interface Factory {
        public ConcreteFunctionType createConcreteFunction(Node var1, StaticScope<ConcreteType> var2);

        public ConcreteInstanceType createConcreteInstance(ObjectType var1);

        public ConcreteFunctionType getConcreteFunction(FunctionType var1);

        public ConcreteInstanceType getConcreteInstance(ObjectType var1);

        public StaticScope<ConcreteType> createFunctionScope(Node var1, StaticScope<ConcreteType> var2);

        public StaticScope<ConcreteType> createInstanceScope(ObjectType var1);

        public JSTypeRegistry getTypeRegistry();
    }

    static class ConcreteUniqueType
    extends ConcreteType {
        private final int id;

        ConcreteUniqueType(int id) {
            this.id = id;
            Preconditions.checkArgument(id >= 0);
        }

        public boolean equals(Object o) {
            return o instanceof ConcreteUniqueType && this.id == ((ConcreteUniqueType)o).id;
        }

        public int hashCode() {
            return ConcreteUniqueType.class.hashCode() ^ this.id;
        }

        public String toString() {
            return "Unique$" + this.id;
        }
    }

    private static class ConcreteAll
    extends ConcreteType {
        private ConcreteAll() {
        }

        @Override
        boolean isAll() {
            return true;
        }

        @Override
        ConcreteType unionWith(ConcreteType other) {
            return this;
        }

        @Override
        ConcreteType intersectWith(ConcreteType other) {
            return other;
        }

        public String toString() {
            return "*";
        }
    }

    static class ConcreteUnionType
    extends ConcreteType {
        private final Set<ConcreteType> alternatives;

        ConcreteUnionType(ConcreteType ... alternatives) {
            this(Sets.newHashSet(alternatives));
        }

        ConcreteUnionType(Set<ConcreteType> alternatives) {
            Preconditions.checkArgument(alternatives.size() > 1);
            this.alternatives = alternatives;
        }

        @Override
        boolean isUnion() {
            return true;
        }

        @Override
        ConcreteUnionType toUnion() {
            return this;
        }

        @Override
        ConcreteType unionWith(ConcreteType other) {
            if (other.isSingleton()) {
                if (this.alternatives.contains(other)) {
                    return this;
                }
                HashSet<ConcreteType> alts = Sets.newHashSet(this.alternatives);
                alts.add(other);
                return new ConcreteUnionType(alts);
            }
            if (other.isUnion()) {
                ConcreteUnionType otherUnion = other.toUnion();
                if (this.alternatives.containsAll(otherUnion.alternatives)) {
                    return this;
                }
                if (otherUnion.alternatives.containsAll(this.alternatives)) {
                    return otherUnion;
                }
                HashSet<ConcreteType> alts = Sets.newHashSet(this.alternatives);
                alts.addAll(otherUnion.alternatives);
                return new ConcreteUnionType(alts);
            }
            Preconditions.checkArgument(other.isNone() || other.isAll());
            return other.unionWith(this);
        }

        @Override
        ConcreteType intersectWith(ConcreteType other) {
            if (other.isSingleton()) {
                if (this.alternatives.contains(other)) {
                    return other;
                }
                return NONE;
            }
            if (other.isUnion()) {
                HashSet<ConcreteType> types = Sets.newHashSet(this.alternatives);
                types.retainAll(other.toUnion().alternatives);
                return ConcreteUnionType.createForTypes(types);
            }
            Preconditions.checkArgument(other.isNone() || other.isAll());
            return other.intersectWith(this);
        }

        Set<ConcreteType> getAlternatives() {
            return this.alternatives;
        }

        public boolean equals(Object obj) {
            return obj instanceof ConcreteUnionType && ((Object)this.alternatives).equals(((ConcreteUnionType)obj).alternatives);
        }

        public int hashCode() {
            return ((Object)this.alternatives).hashCode() ^ 0x5F6E7D8C;
        }

        public String toString() {
            ArrayList<String> names = Lists.newArrayList();
            for (ConcreteType type : this.alternatives) {
                names.add(type.toString());
            }
            Collections.sort(names);
            return "(" + Joiner.on(",").join(names) + ")";
        }
    }

    static class ConcreteInstanceType
    extends ConcreteType {
        private final Factory factory;
        public final ObjectType instanceType;
        private ConcreteInstanceType prototype;
        private StaticScope<ConcreteType> scope;

        ConcreteInstanceType(Factory factory, ObjectType instanceType) {
            this.factory = factory;
            this.instanceType = instanceType;
            Preconditions.checkArgument(!(instanceType instanceof UnknownType));
        }

        @Override
        boolean isInstance() {
            return true;
        }

        @Override
        ConcreteInstanceType toInstance() {
            return this;
        }

        boolean isFunctionPrototype() {
            return this.instanceType.isFunctionPrototypeType();
        }

        StaticSlot<ConcreteType> getPropertySlot(String propName) {
            return this.getScope().getSlot(propName);
        }

        ConcreteInstanceType getInstanceTypeWithProperty(String propName) {
            if (this.getScope().getOwnSlot(propName) != null) {
                if (this.instanceType.getConstructor() != null) {
                    return this.getConstructorType().getPrototypeType();
                }
                return this;
            }
            if (this.getImplicitPrototype() != null) {
                return this.getImplicitPrototype().getInstanceTypeWithProperty(propName);
            }
            return null;
        }

        ConcreteInstanceType getImplicitPrototype() {
            ObjectType proto;
            if (this.prototype == null && this.instanceType.getImplicitPrototype() != null && (proto = this.instanceType.getImplicitPrototype()) != this.instanceType && !(proto instanceof UnknownType)) {
                this.prototype = this.factory.createConcreteInstance(proto);
            }
            return this.prototype;
        }

        ConcreteFunctionType getConstructorType() {
            if (this.instanceType.isFunctionPrototypeType()) {
                return this.factory.getConcreteFunction(this.instanceType.getOwnerFunction());
            }
            FunctionType constructor = this.instanceType.getConstructor();
            return constructor != null ? this.factory.getConcreteFunction(constructor) : null;
        }

        @Override
        StaticScope<ConcreteType> getScope() {
            if (this.scope == null) {
                this.scope = this.factory.createInstanceScope(this.instanceType);
            }
            return this.scope;
        }

        public String toString() {
            return this.instanceType.toString();
        }
    }

    static class ConcreteFunctionType
    extends ConcreteType {
        private final Factory factory;
        private final Node declaration;
        private final StaticScope<ConcreteType> parentScope;
        private StaticScope<ConcreteType> bodyScope;
        private ConcreteInstanceType instanceType;
        private ConcreteInstanceType prototypeType;

        ConcreteFunctionType(Factory factory, Node declaration, StaticScope<ConcreteType> parentScope) {
            this.factory = factory;
            this.declaration = declaration;
            this.parentScope = parentScope;
            Preconditions.checkArgument(declaration.isFunction());
            Preconditions.checkArgument(declaration.getJSType() != null);
            Preconditions.checkArgument(declaration.getJSType().isFunctionType());
        }

        @Override
        boolean isFunction() {
            return true;
        }

        @Override
        ConcreteFunctionType toFunction() {
            return this;
        }

        StaticSlot<ConcreteType> getCallSlot() {
            return this.getScope().getOwnSlot(":call");
        }

        StaticSlot<ConcreteType> getThisSlot() {
            return this.getScope().getOwnSlot(":this");
        }

        StaticSlot<ConcreteType> getReturnSlot() {
            return this.getScope().getOwnSlot(":return");
        }

        StaticSlot<ConcreteType> getParameterSlot(int index) {
            return this.getScope().getOwnSlot(this.getParameterName(index));
        }

        private String getParameterName(int index) {
            int count = 0;
            for (Node n = this.getFirstParameter(); n != null; n = n.getNext()) {
                if (count++ != index) continue;
                return n.getString();
            }
            return null;
        }

        private Node getFirstParameter() {
            return this.declaration.getFirstChild().getNext().getFirstChild();
        }

        public FunctionType getJSType() {
            return JSType.toMaybeFunctionType(this.declaration.getJSType());
        }

        ConcreteInstanceType getInstanceType() {
            if (this.instanceType == null && this.getJSType().isConstructor()) {
                this.instanceType = this.factory.createConcreteInstance(this.getJSType().getInstanceType());
            }
            return this.instanceType;
        }

        ConcreteInstanceType getPrototypeType() {
            if (this.prototypeType == null) {
                this.prototypeType = this.factory.createConcreteInstance(this.getJSType().getPrototype());
            }
            return this.prototypeType;
        }

        ConcreteFunctionType getSuperclassType() {
            FunctionType superConstructor = this.getJSType().getSuperClassConstructor();
            return superConstructor != null ? this.factory.getConcreteFunction(superConstructor) : null;
        }

        @Override
        StaticScope<ConcreteType> getScope() {
            if (this.bodyScope == null) {
                this.bodyScope = this.factory.createFunctionScope(this.declaration, this.parentScope);
            }
            return this.bodyScope;
        }

        public String toString() {
            boolean hasKnownTypeOfThis;
            StringBuilder b = new StringBuilder(32);
            b.append("function (");
            boolean bl = hasKnownTypeOfThis = !this.getThisSlot().getType().isNone();
            if (hasKnownTypeOfThis) {
                b.append("this:");
                b.append(this.getThisSlot().getType().toString());
            }
            Node n = this.getFirstParameter();
            if (hasKnownTypeOfThis && n != null) {
                b.append(", ");
            }
            int i = 0;
            while (n != null) {
                String paramName = n.getString();
                StaticSlot<ConcreteType> var = this.getScope().getOwnSlot(paramName);
                b.append(var.getType());
                this.getParameterSlot(i).getType();
                if (n.getNext() != null) {
                    b.append(", ");
                }
                ++i;
                n = n.getNext();
            }
            b.append(")");
            if (this.getReturnSlot().getType() != null) {
                b.append(": ");
                b.append(this.getReturnSlot().getType().toString());
            }
            return b.toString();
        }
    }

    private static class ConcreteNoneType
    extends ConcreteType {
        private ConcreteNoneType() {
        }

        @Override
        boolean isNone() {
            return true;
        }

        @Override
        ConcreteType unionWith(ConcreteType other) {
            return other;
        }

        @Override
        ConcreteType intersectWith(ConcreteType other) {
            return NONE;
        }

        public String toString() {
            return "()";
        }
    }

    abstract class TypeFilter<C> {
        final List<C> emptyList;

        TypeFilter(List<C> emptyList) {
            this.emptyList = emptyList;
        }

        protected abstract C filter(ConcreteType var1);
    }
}

