/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Joiner;
import closurecompiler.internal.com.google.common.collect.Lists;
import closurecompiler.internal.com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CheckLevel;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DiagnosticGroup;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DiagnosticType;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSError;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.WarningsGuard;

public class ComposeWarningsGuard
extends WarningsGuard {
    private final Map<WarningsGuard, Integer> orderOfAddition = Maps.newHashMap();
    private int numberOfAdds = 0;
    private final Comparator<WarningsGuard> guardComparator = new GuardComparator(this.orderOfAddition);
    private final TreeSet<WarningsGuard> guards = new TreeSet<WarningsGuard>(this.guardComparator);

    public ComposeWarningsGuard(List<WarningsGuard> guards) {
        this.addGuards(guards);
    }

    public ComposeWarningsGuard(WarningsGuard ... guards) {
        this(Lists.newArrayList(guards));
    }

    void addGuard(WarningsGuard guard) {
        if (guard instanceof ComposeWarningsGuard) {
            this.addGuards(((ComposeWarningsGuard)guard).guards.descendingSet());
        } else {
            ++this.numberOfAdds;
            this.orderOfAddition.put(guard, this.numberOfAdds);
            this.guards.remove(guard);
            this.guards.add(guard);
        }
    }

    private void addGuards(Iterable<WarningsGuard> guards) {
        for (WarningsGuard guard : guards) {
            this.addGuard(guard);
        }
    }

    @Override
    public CheckLevel level(JSError error) {
        for (WarningsGuard guard : this.guards) {
            CheckLevel newLevel = guard.level(error);
            if (newLevel == null) continue;
            return newLevel;
        }
        return null;
    }

    @Override
    public boolean disables(DiagnosticGroup group) {
        block0: for (DiagnosticType type : group.getTypes()) {
            DiagnosticGroup singleton = DiagnosticGroup.forType(type);
            for (WarningsGuard guard : this.guards) {
                if (guard.disables(singleton)) continue block0;
                if (!guard.enables(singleton)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean enables(DiagnosticGroup group) {
        for (WarningsGuard guard : this.guards) {
            if (guard.enables(group)) {
                return true;
            }
            if (!guard.disables(group)) continue;
            return false;
        }
        return false;
    }

    public String toString() {
        return Joiner.on(", ").join(this.guards);
    }

    private static class GuardComparator
    implements Serializable,
    Comparator<WarningsGuard> {
        private final Map<WarningsGuard, Integer> orderOfAddition;

        private GuardComparator(Map<WarningsGuard, Integer> orderOfAddition) {
            this.orderOfAddition = orderOfAddition;
        }

        @Override
        public int compare(WarningsGuard a, WarningsGuard b) {
            int priorityDiff = a.getPriority() - b.getPriority();
            if (priorityDiff != 0) {
                return priorityDiff;
            }
            return this.orderOfAddition.get(b) - this.orderOfAddition.get(a);
        }
    }
}

