/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.Lists;
import closurecompiler.internal.com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.Scope;
import org.jetbrains.jet.internal.com.google.javascript.rhino.JSDocInfo;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class CollapseVariableDeclarations
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final List<Collapse> collapses = Lists.newArrayList();
    private final Set<Node> nodesToCollapse = Sets.newHashSet();

    CollapseVariableDeclarations(AbstractCompiler compiler) {
        Preconditions.checkState(!compiler.getLifeCycleStage().isNormalized());
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        this.collapses.clear();
        this.nodesToCollapse.clear();
        NodeTraversal.traverse(this.compiler, root, new GatherCollapses());
        if (!this.collapses.isEmpty()) {
            this.applyCollapses();
            this.compiler.reportCodeChange();
        }
    }

    private void applyCollapses() {
        for (Collapse collapse : this.collapses) {
            Node var = new Node(118);
            var.copyInformationFrom(collapse.startNode);
            collapse.parent.addChildBefore(var, collapse.startNode);
            boolean redeclaration = false;
            Node n = collapse.startNode;
            while (n != collapse.endNode) {
                Node next = n.getNext();
                Preconditions.checkState(var.getNext() == n);
                collapse.parent.removeChildAfter(var);
                if (n.isVar()) {
                    while (n.hasChildren()) {
                        var.addChildToBack(n.removeFirstChild());
                    }
                } else {
                    Node assign = n.getFirstChild();
                    Node lhs = assign.getFirstChild();
                    Preconditions.checkState(lhs.isName());
                    Node rhs = assign.getLastChild();
                    lhs.addChildToBack(rhs.detachFromParent());
                    var.addChildToBack(lhs.detachFromParent());
                    redeclaration = true;
                }
                n = next;
            }
            if (!redeclaration) continue;
            JSDocInfo info = new JSDocInfo();
            info.addSuppression("duplicate");
            var.setJSDocInfo(info);
        }
    }

    private class GatherCollapses
    extends NodeTraversal.AbstractPostOrderCallback {
        private final Set<Scope.Var> blacklistedVars = Sets.newHashSet();

        private GatherCollapses() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isVar()) {
                this.blacklistStubVars(t, n);
            }
            if (!n.isVar() && !this.canBeRedeclared(n, t.getScope())) {
                return;
            }
            if (CollapseVariableDeclarations.this.nodesToCollapse.contains(n)) {
                return;
            }
            if (parent.isIf()) {
                return;
            }
            Node varNode = n;
            boolean hasVar = n.isVar();
            boolean hasNodesToCollapse = false;
            for (n = n.getNext(); n != null && (n.isVar() || this.canBeRedeclared(n, t.getScope())); n = n.getNext()) {
                if (n.isVar()) {
                    this.blacklistStubVars(t, n);
                    hasVar = true;
                }
                CollapseVariableDeclarations.this.nodesToCollapse.add(n);
                hasNodesToCollapse = true;
            }
            if (hasNodesToCollapse && hasVar) {
                CollapseVariableDeclarations.this.nodesToCollapse.add(varNode);
                CollapseVariableDeclarations.this.collapses.add(new Collapse(varNode, n, parent));
            }
        }

        private void blacklistStubVars(NodeTraversal t, Node varNode) {
            for (Node child = varNode.getFirstChild(); child != null; child = child.getNext()) {
                if (child.getFirstChild() != null) continue;
                this.blacklistedVars.add(t.getScope().getVar(child.getString()));
            }
        }

        private boolean canBeRedeclared(Node n, Scope s) {
            if (!NodeUtil.isExprAssign(n)) {
                return false;
            }
            Node assign = n.getFirstChild();
            Node lhs = assign.getFirstChild();
            if (!lhs.isName()) {
                return false;
            }
            Scope.Var var = s.getVar(lhs.getString());
            return var != null && var.getScope() == s && !this.blacklistedVars.contains(var);
        }
    }

    private static class Collapse {
        final Node startNode;
        final Node endNode;
        final Node parent;

        Collapse(Node startNode, Node endNode, Node parent) {
            this.startNode = startNode;
            this.endNode = endNode;
            this.parent = parent;
        }
    }
}

