/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class CollapseAnonymousFunctions
implements CompilerPass {
    private final AbstractCompiler compiler;

    public CollapseAnonymousFunctions(AbstractCompiler compiler) {
        Preconditions.checkArgument(compiler.getLifeCycleStage().isNormalized());
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new Callback());
    }

    private class Callback
    extends NodeTraversal.AbstractPostOrderCallback {
        private Callback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!n.isVar()) {
                return;
            }
            Node grandparent = parent.getParent();
            if (!(parent.isScript() || grandparent != null && grandparent.isFunction() && parent.isBlock())) {
                return;
            }
            Preconditions.checkState(n.hasOneChild());
            Node name = n.getFirstChild();
            Node value = name.getFirstChild();
            if (value != null && value.isFunction() && !this.isRecursiveFunction(value)) {
                Node fnName = value.getFirstChild();
                fnName.setString(name.getString());
                NodeUtil.copyNameAnnotations(name, fnName);
                name.removeChild(value);
                parent.replaceChild(n, value);
                if (!t.inGlobalScope() && NodeUtil.isHoistedFunctionDeclaration(value)) {
                    parent.addChildToFront(value.detachFromParent());
                }
                CollapseAnonymousFunctions.this.compiler.reportCodeChange();
            }
        }

        private boolean isRecursiveFunction(Node function) {
            Node name = function.getFirstChild();
            if (name.getString().isEmpty()) {
                return false;
            }
            Node args = name.getNext();
            Node body = args.getNext();
            return this.containsName(body, name.getString());
        }

        private boolean containsName(Node n, String name) {
            if (n.isName() && n.getString().equals(name)) {
                return true;
            }
            for (Node child : n.children()) {
                if (!this.containsName(child, name)) continue;
                return true;
            }
            return false;
        }
    }
}

