/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Function;
import closurecompiler.internal.com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.ChainableReverseAbstractInterpreter;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CodingConvention;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.FlowScope;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.FunctionType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSTypeNative;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSTypeRegistry;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.ObjectType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.Visitor;

class ClosureReverseAbstractInterpreter
extends ChainableReverseAbstractInterpreter {
    private final Visitor<JSType> restrictToArrayVisitor = new ChainableReverseAbstractInterpreter.RestrictByTrueTypeOfResultVisitor(){

        @Override
        protected JSType caseTopType(JSType topType) {
            return topType;
        }

        @Override
        public JSType caseObjectType(ObjectType type) {
            JSType arrayType = ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.ARRAY_TYPE);
            return arrayType.isSubtype(type) ? arrayType : null;
        }
    };
    private final Visitor<JSType> restrictToNotArrayVisitor = new ChainableReverseAbstractInterpreter.RestrictByFalseTypeOfResultVisitor(){

        @Override
        public JSType caseObjectType(ObjectType type) {
            return type.isSubtype(ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.ARRAY_TYPE)) ? null : type;
        }
    };
    private final Visitor<JSType> restrictToObjectVisitor = new ChainableReverseAbstractInterpreter.RestrictByTrueTypeOfResultVisitor(){

        @Override
        protected JSType caseTopType(JSType topType) {
            return ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }

        @Override
        public JSType caseObjectType(ObjectType type) {
            return type;
        }

        @Override
        public JSType caseFunctionType(FunctionType type) {
            return type;
        }
    };
    private final Visitor<JSType> restrictToNotObjectVisitor = new ChainableReverseAbstractInterpreter.RestrictByFalseTypeOfResultVisitor(){

        @Override
        public JSType caseObjectType(ObjectType type) {
            return null;
        }

        @Override
        public JSType caseFunctionType(FunctionType type) {
            return null;
        }
    };
    private Map<String, Function<TypeRestriction, JSType>> restricters = new ImmutableMap.Builder<String, 13>().put("isDef", new Function<TypeRestriction, JSType>(){

        @Override
        public JSType apply(TypeRestriction p) {
            if (p.outcome) {
                return ClosureReverseAbstractInterpreter.this.getRestrictedWithoutUndefined(p.type);
            }
            return null;
        }
    }).put("isNull", new Function<TypeRestriction, JSType>(){

        @Override
        public JSType apply(TypeRestriction p) {
            if (p.outcome) {
                return ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NULL_TYPE);
            }
            return ClosureReverseAbstractInterpreter.this.getRestrictedWithoutNull(p.type);
        }
    }).put("isDefAndNotNull", new Function<TypeRestriction, JSType>(){

        @Override
        public JSType apply(TypeRestriction p) {
            if (p.outcome) {
                return ClosureReverseAbstractInterpreter.this.getRestrictedWithoutUndefined(ClosureReverseAbstractInterpreter.this.getRestrictedWithoutNull(p.type));
            }
            return null;
        }
    }).put("isString", new Function<TypeRestriction, JSType>(){

        @Override
        public JSType apply(TypeRestriction p) {
            return ClosureReverseAbstractInterpreter.this.getRestrictedByTypeOfResult(p.type, "string", p.outcome);
        }
    }).put("isBoolean", new Function<TypeRestriction, JSType>(){

        @Override
        public JSType apply(TypeRestriction p) {
            return ClosureReverseAbstractInterpreter.this.getRestrictedByTypeOfResult(p.type, "boolean", p.outcome);
        }
    }).put("isNumber", new Function<TypeRestriction, JSType>(){

        @Override
        public JSType apply(TypeRestriction p) {
            return ClosureReverseAbstractInterpreter.this.getRestrictedByTypeOfResult(p.type, "number", p.outcome);
        }
    }).put("isFunction", new Function<TypeRestriction, JSType>(){

        @Override
        public JSType apply(TypeRestriction p) {
            return ClosureReverseAbstractInterpreter.this.getRestrictedByTypeOfResult(p.type, "function", p.outcome);
        }
    }).put("isArray", new Function<TypeRestriction, JSType>(){

        @Override
        public JSType apply(TypeRestriction p) {
            if (p.type == null) {
                return p.outcome ? ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.ARRAY_TYPE) : null;
            }
            Visitor visitor = p.outcome ? ClosureReverseAbstractInterpreter.this.restrictToArrayVisitor : ClosureReverseAbstractInterpreter.this.restrictToNotArrayVisitor;
            return (JSType)p.type.visit(visitor);
        }
    }).put("isObject", new Function<TypeRestriction, JSType>(){

        @Override
        public JSType apply(TypeRestriction p) {
            if (p.type == null) {
                return p.outcome ? ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.OBJECT_TYPE) : null;
            }
            Visitor visitor = p.outcome ? ClosureReverseAbstractInterpreter.this.restrictToObjectVisitor : ClosureReverseAbstractInterpreter.this.restrictToNotObjectVisitor;
            return (JSType)p.type.visit(visitor);
        }
    }).build();

    ClosureReverseAbstractInterpreter(CodingConvention convention, JSTypeRegistry typeRegistry) {
        super(convention, typeRegistry);
    }

    @Override
    public FlowScope getPreciserScopeKnowingConditionOutcome(Node condition, FlowScope blindScope, boolean outcome) {
        if (condition.isCall() && condition.getChildCount() == 2) {
            Node callee = condition.getFirstChild();
            Node param = condition.getLastChild();
            if (callee.isGetProp() && param.isQualifiedName()) {
                Function<TypeRestriction, JSType> restricter;
                JSType paramType = this.getTypeIfRefinable(param, blindScope);
                Node left = callee.getFirstChild();
                Node right = callee.getLastChild();
                if (left.isName() && "goog".equals(left.getString()) && right.isString() && (restricter = this.restricters.get(right.getString())) != null) {
                    return this.restrictParameter(param, paramType, blindScope, restricter, outcome);
                }
            }
        }
        return this.nextPreciserScopeKnowingConditionOutcome(condition, blindScope, outcome);
    }

    private FlowScope restrictParameter(Node parameter, JSType type, FlowScope blindScope, Function<TypeRestriction, JSType> restriction, boolean outcome) {
        if ((type = restriction.apply(new TypeRestriction(type, outcome))) != null) {
            FlowScope informed = blindScope.createChildFlowScope();
            this.declareNameInScope(informed, parameter, type);
            return informed;
        }
        return blindScope;
    }

    private static class TypeRestriction {
        private final JSType type;
        private final boolean outcome;

        private TypeRestriction(JSType type, boolean outcome) {
            this.type = type;
            this.outcome = outcome;
        }
    }
}

