/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.ImmutableList;
import closurecompiler.internal.com.google.common.collect.ImmutableSet;
import closurecompiler.internal.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CodingConvention;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CodingConventions;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DiagnosticType;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSError;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.FunctionType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSTypeNative;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.ObjectType;

public class ClosureCodingConvention
extends CodingConventions.Proxy {
    static final DiagnosticType OBJECTLIT_EXPECTED = DiagnosticType.warning("JSC_REFLECT_OBJECTLIT_EXPECTED", "Object literal expected as second argument");
    private final Set<String> propertyTestFunctions = ImmutableSet.of("goog.isDef", "goog.isNull", "goog.isDefAndNotNull", "goog.isString", "goog.isNumber", "goog.isBoolean", new String[]{"goog.isFunction", "goog.isArray", "goog.isObject"});

    public ClosureCodingConvention() {
        this(CodingConventions.getDefault());
    }

    public ClosureCodingConvention(CodingConvention wrapped) {
        super(wrapped);
    }

    @Override
    public void applySubclassRelationship(FunctionType parentCtor, FunctionType childCtor, CodingConvention.SubclassType type) {
        if (type == CodingConvention.SubclassType.INHERITS) {
            childCtor.defineDeclaredProperty("superClass_", parentCtor.getPrototype(), childCtor.getSource());
            childCtor.getPrototype().defineDeclaredProperty("constructor", childCtor, childCtor.getSource());
        }
    }

    @Override
    public CodingConvention.SubclassRelationship getClassesDefinedByCall(Node callNode) {
        Node callName = callNode.getFirstChild();
        CodingConvention.SubclassType type = this.typeofClassDefiningName(callName);
        if (type != null) {
            boolean isDeprecatedCall;
            Node subclass = null;
            Node superclass = callNode.getLastChild();
            boolean bl = isDeprecatedCall = callNode.getChildCount() == 2 && callName.isGetProp();
            if (isDeprecatedCall) {
                subclass = callName.getFirstChild();
            } else if (callNode.getChildCount() == 3) {
                subclass = callName.getNext();
            } else {
                return null;
            }
            if (type == CodingConvention.SubclassType.MIXIN) {
                if (!this.endsWithPrototype(superclass)) {
                    return null;
                }
                if (!isDeprecatedCall) {
                    if (!this.endsWithPrototype(subclass)) {
                        return null;
                    }
                    subclass = subclass.getFirstChild();
                }
                superclass = superclass.getFirstChild();
            }
            if (subclass != null && subclass.isUnscopedQualifiedName() && superclass.isUnscopedQualifiedName()) {
                return new CodingConvention.SubclassRelationship(type, subclass, superclass);
            }
        }
        return null;
    }

    private CodingConvention.SubclassType typeofClassDefiningName(Node callName) {
        String name;
        int dollarIndex;
        String methodName = null;
        if (callName.isGetProp()) {
            methodName = callName.getLastChild().getString();
        } else if (callName.isName() && (dollarIndex = (name = callName.getString()).lastIndexOf(36)) != -1) {
            methodName = name.substring(dollarIndex + 1);
        }
        if (methodName != null) {
            if (methodName.equals("inherits")) {
                return CodingConvention.SubclassType.INHERITS;
            }
            if (methodName.equals("mixin")) {
                return CodingConvention.SubclassType.MIXIN;
            }
        }
        return null;
    }

    @Override
    public boolean isSuperClassReference(String propertyName) {
        return "superClass_".equals(propertyName);
    }

    private boolean endsWithPrototype(Node qualifiedName) {
        return qualifiedName.isGetProp() && qualifiedName.getLastChild().getString().equals("prototype");
    }

    @Override
    public String extractClassNameIfProvide(Node node, Node parent) {
        return ClosureCodingConvention.extractClassNameIfGoog(node, parent, "goog.provide");
    }

    @Override
    public String extractClassNameIfRequire(Node node, Node parent) {
        return ClosureCodingConvention.extractClassNameIfGoog(node, parent, "goog.require");
    }

    private static String extractClassNameIfGoog(Node node, Node parent, String functionName) {
        Node target;
        String qualifiedName;
        Node callee;
        String className = null;
        if (NodeUtil.isExprCall(parent) && (callee = node.getFirstChild()) != null && callee.isGetProp() && functionName.equals(qualifiedName = callee.getQualifiedName()) && (target = callee.getNext()) != null && target.isString()) {
            className = target.getString();
        }
        return className;
    }

    @Override
    public String getExportPropertyFunction() {
        return "goog.exportProperty";
    }

    @Override
    public String getExportSymbolFunction() {
        return "goog.exportSymbol";
    }

    @Override
    public List<String> identifyTypeDeclarationCall(Node n) {
        Node typeArray;
        Node callName = n.getFirstChild();
        if ("goog.addDependency".equals(callName.getQualifiedName()) && n.getChildCount() >= 3 && (typeArray = callName.getNext().getNext()).isArrayLit()) {
            ArrayList<String> typeNames = Lists.newArrayList();
            for (Node name = typeArray.getFirstChild(); name != null; name = name.getNext()) {
                if (!name.isString()) continue;
                typeNames.add(name.getString());
            }
            return typeNames;
        }
        return null;
    }

    @Override
    public String getAbstractMethodName() {
        return "goog.abstractMethod";
    }

    @Override
    public String getSingletonGetterClassName(Node callNode) {
        Node callArg = callNode.getFirstChild();
        String callName = callArg.getQualifiedName();
        if (!"goog.addSingletonGetter".equals(callName) && !"goog$addSingletonGetter".equals(callName) || callNode.getChildCount() != 2) {
            return null;
        }
        return callArg.getNext().getQualifiedName();
    }

    @Override
    public void applySingletonGetter(FunctionType functionType, FunctionType getterType, ObjectType objectType) {
        functionType.defineDeclaredProperty("getInstance", getterType, functionType.getSource());
        functionType.defineDeclaredProperty("instance_", objectType, functionType.getSource());
    }

    @Override
    public String getGlobalObject() {
        return "goog.global";
    }

    @Override
    public boolean isPropertyTestFunction(Node call) {
        Preconditions.checkArgument(call.isCall());
        return this.propertyTestFunctions.contains(call.getFirstChild().getQualifiedName());
    }

    @Override
    public CodingConvention.ObjectLiteralCast getObjectLiteralCast(NodeTraversal t, Node callNode) {
        Preconditions.checkArgument(callNode.isCall());
        Node callName = callNode.getFirstChild();
        if (!"goog.reflect.object".equals(callName.getQualifiedName()) || callNode.getChildCount() != 3) {
            return null;
        }
        Node typeNode = callName.getNext();
        if (!typeNode.isQualifiedName()) {
            return null;
        }
        Node objectNode = typeNode.getNext();
        if (!objectNode.isObjectLit()) {
            t.getCompiler().report(JSError.make(t.getSourceName(), callNode, OBJECTLIT_EXPECTED, new String[0]));
            return null;
        }
        return new CodingConvention.ObjectLiteralCast(typeNode.getQualifiedName(), typeNode.getNext());
    }

    @Override
    public boolean isOptionalParameter(Node parameter) {
        return false;
    }

    @Override
    public boolean isVarArgsParameter(Node parameter) {
        return false;
    }

    @Override
    public boolean isPrivate(String name) {
        return false;
    }

    @Override
    public Collection<CodingConvention.AssertionFunctionSpec> getAssertionFunctions() {
        return ImmutableList.of(new CodingConvention.AssertionFunctionSpec("goog.asserts.assert"), new CodingConvention.AssertionFunctionSpec("goog.asserts.assertNumber", JSTypeNative.NUMBER_TYPE), new CodingConvention.AssertionFunctionSpec("goog.asserts.assertString", JSTypeNative.STRING_TYPE), new CodingConvention.AssertionFunctionSpec("goog.asserts.assertFunction", JSTypeNative.FUNCTION_INSTANCE_TYPE), new CodingConvention.AssertionFunctionSpec("goog.asserts.assertObject", JSTypeNative.OBJECT_TYPE), new CodingConvention.AssertionFunctionSpec("goog.asserts.assertArray", JSTypeNative.ARRAY_TYPE), new CodingConvention.AssertionFunctionSpec("goog.asserts.assertInstanceof", JSTypeNative.OBJECT_TYPE));
    }

    @Override
    public CodingConvention.Bind describeFunctionBind(Node n) {
        CodingConvention.Bind result = super.describeFunctionBind(n);
        if (result != null) {
            return result;
        }
        if (!n.isCall()) {
            return null;
        }
        Node callTarget = n.getFirstChild();
        String name = callTarget.getQualifiedName();
        if (name != null) {
            if (name.equals("goog.bind") || name.equals("goog$bind")) {
                Node fn = callTarget.getNext();
                if (fn == null) {
                    return null;
                }
                Node thisValue = this.safeNext(fn);
                Node parameters = this.safeNext(thisValue);
                return new CodingConvention.Bind(fn, thisValue, parameters);
            }
            if (name.equals("goog.partial") || name.equals("goog$partial")) {
                Node fn = callTarget.getNext();
                if (fn == null) {
                    return null;
                }
                Node thisValue = null;
                Node parameters = this.safeNext(fn);
                return new CodingConvention.Bind(fn, thisValue, parameters);
            }
        }
        return null;
    }

    private Node safeNext(Node n) {
        if (n != null) {
            return n.getNext();
        }
        return null;
    }
}

