/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.collect.ImmutableList;
import closurecompiler.internal.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerOptions;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DefaultPassConfig;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.FieldCleanupPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.GlobalVarReferenceMap;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.HotSwapCompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.MemoizedScopeCreator;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.PassConfig;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.PassFactory;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.Scope;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.ScopeCreator;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.FunctionType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSType;

class CleanupPasses
extends PassConfig {
    private PassConfig.State state;
    final PassFactory fieldCleanupPassFactory = new DefaultPassConfig.HotSwapPassFactory("FieldCleaupPassFactory", false){

        @Override
        protected HotSwapCompilerPass createInternal(AbstractCompiler compiler) {
            return new FieldCleanupPass(compiler);
        }
    };
    final PassFactory scopeCleanupPassFactory = new DefaultPassConfig.HotSwapPassFactory("ScopeCleanupPassFactory", false){

        @Override
        protected HotSwapCompilerPass createInternal(AbstractCompiler compiler) {
            return new MemoizedScopeCleanupPass(compiler);
        }
    };
    final PassFactory globalVarRefCleanupPassFactory = new DefaultPassConfig.HotSwapPassFactory("GlobalVarRefCleanupPassFactory", false){

        @Override
        protected HotSwapCompilerPass createInternal(AbstractCompiler compiler) {
            return new GlobalVarReferenceMap.GlobalVarRefCleanupPass(compiler);
        }
    };

    public CleanupPasses(CompilerOptions options) {
        super(options);
    }

    @Override
    protected List<PassFactory> getChecks() {
        ArrayList<PassFactory> checks = Lists.newArrayList();
        checks.add(this.fieldCleanupPassFactory);
        checks.add(this.scopeCleanupPassFactory);
        checks.add(this.globalVarRefCleanupPassFactory);
        return checks;
    }

    @Override
    PassConfig.State getIntermediateState() {
        return this.state;
    }

    @Override
    protected List<PassFactory> getOptimizations() {
        return ImmutableList.of();
    }

    @Override
    void setIntermediateState(PassConfig.State state) {
        this.state = state;
    }

    static class MemoizedScopeCleanupPass
    implements HotSwapCompilerPass {
        private final AbstractCompiler compiler;

        public MemoizedScopeCleanupPass(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @Override
        public void hotSwapScript(Node scriptRoot, Node originalRoot) {
            ScopeCreator creator = this.compiler.getTypedScopeCreator();
            if (creator instanceof MemoizedScopeCreator) {
                MemoizedScopeCreator scopeCreator = (MemoizedScopeCreator)creator;
                String newSrc = scriptRoot.getSourceFileName();
                for (Scope.Var var : scopeCreator.getAllSymbols()) {
                    FunctionType fnType;
                    JSType type = var.getType();
                    if (type == null || (fnType = type.toMaybeFunctionType()) == null || !newSrc.equals(NodeUtil.getSourceName(fnType.getSource()))) continue;
                    fnType.setSource(null);
                }
                scopeCreator.removeScopesForScript(originalRoot.getSourceFileName());
            }
        }

        @Override
        public void process(Node externs, Node root) {
        }
    }
}

