/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Predicate;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CheckLevel;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CheckPathsBetweenNodes;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.ControlFlowGraph;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DiagnosticType;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.graph.DiGraph;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.FunctionType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSTypeNative;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.TernaryValue;

class CheckMissingReturn
implements NodeTraversal.ScopedCallback {
    static final DiagnosticType MISSING_RETURN_STATEMENT = DiagnosticType.warning("JSC_MISSING_RETURN_STATEMENT", "Missing return statement. Function expected to return {0}.");
    private final AbstractCompiler compiler;
    private final CheckLevel level;
    private static final Predicate<Node> IS_RETURN = new Predicate<Node>(){

        @Override
        public boolean apply(Node input) {
            return input != null && input.isReturn();
        }
    };
    private static final Predicate<DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch>> GOES_THROUGH_TRUE_CONDITION_PREDICATE = new Predicate<DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch>>(){

        @Override
        public boolean apply(DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> input) {
            TernaryValue val;
            Node condition;
            ControlFlowGraph.Branch branch = (ControlFlowGraph.Branch)((Object)input.getValue());
            if (branch == ControlFlowGraph.Branch.ON_EX) {
                return false;
            }
            if (branch.isConditional() && (condition = NodeUtil.getConditionExpression((Node)input.getSource().getValue())) != null && (val = NodeUtil.getImpureBooleanValue(condition)) != TernaryValue.UNKNOWN) {
                return val.toBoolean(true) == (ControlFlowGraph.Branch.ON_TRUE == branch);
            }
            return true;
        }
    };

    CheckMissingReturn(AbstractCompiler compiler, CheckLevel level) {
        this.compiler = compiler;
        this.level = level;
    }

    @Override
    public void enterScope(NodeTraversal t) {
        JSType returnType = this.explicitReturnExpected(t.getScopeRoot());
        if (returnType == null) {
            return;
        }
        if (CheckMissingReturn.fastAllPathsReturnCheck(t.getControlFlowGraph())) {
            return;
        }
        CheckPathsBetweenNodes<Node, ControlFlowGraph.Branch> test = new CheckPathsBetweenNodes<Node, ControlFlowGraph.Branch>(t.getControlFlowGraph(), t.getControlFlowGraph().getEntry(), t.getControlFlowGraph().getImplicitReturn(), IS_RETURN, GOES_THROUGH_TRUE_CONDITION_PREDICATE);
        if (!test.allPathsSatisfyPredicate()) {
            this.compiler.report(t.makeError(t.getScopeRoot(), this.level, MISSING_RETURN_STATEMENT, returnType.toString()));
        }
    }

    private static boolean fastAllPathsReturnCheck(ControlFlowGraph<Node> cfg) {
        for (DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> s : cfg.getImplicitReturn().getInEdges()) {
            if (((Node)s.getSource().getValue()).isReturn()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void exitScope(NodeTraversal t) {
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
    }

    private JSType explicitReturnExpected(Node scope) {
        FunctionType scopeType = JSType.toMaybeFunctionType(scope.getJSType());
        if (scopeType == null) {
            return null;
        }
        if (CheckMissingReturn.isEmptyFunction(scope)) {
            return null;
        }
        JSType returnType = scopeType.getReturnType();
        if (returnType == null) {
            return null;
        }
        if (!this.isVoidOrUnknown(returnType)) {
            return returnType;
        }
        return null;
    }

    private static boolean isEmptyFunction(Node function) {
        return function.getChildCount() == 3 && !function.getFirstChild().getNext().getNext().hasChildren();
    }

    private boolean isVoidOrUnknown(JSType returnType) {
        JSType voidType = this.compiler.getTypeRegistry().getNativeType(JSTypeNative.VOID_TYPE);
        return voidType.isSubtype(returnType);
    }
}

