/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CheckLevel;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DiagnosticType;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class CheckMissingGetCssName
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final CheckLevel level;
    private final Matcher blacklist;
    static final DiagnosticType MISSING_GETCSSNAME = DiagnosticType.disabled("JSC_MISSING_GETCSSNAME", "missing goog.getCssName around literal ''{0}''");

    CheckMissingGetCssName(AbstractCompiler compiler, CheckLevel level, String blacklistRegex) {
        this.compiler = compiler;
        this.level = level;
        this.blacklist = Pattern.compile("\\b(?:" + blacklistRegex + ")").matcher("");
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isString() && !parent.isGetProp() && !parent.isRegExp() && !NodeUtil.isObjectLitKey(n, parent)) {
            String s = n.getString();
            this.blacklist.reset(s);
            while (this.blacklist.find()) {
                if (this.insideGetCssNameCall(n, parent) || this.insideGetUniqueIdCall(n, parent) || this.insideAssignmentToIdConstant(n, parent)) continue;
                this.compiler.report(t.makeError(n, this.level, MISSING_GETCSSNAME, this.blacklist.group()));
            }
        }
    }

    private boolean insideGetCssNameCall(Node n, Node parent) {
        return parent.isCall() && "goog.getCssName".equals(parent.getFirstChild().getQualifiedName());
    }

    private boolean insideGetUniqueIdCall(Node n, Node parent) {
        String name = parent.isCall() ? parent.getFirstChild().getQualifiedName() : null;
        return name != null && name.endsWith(".getUniqueId");
    }

    private boolean insideAssignmentToIdConstant(Node n, Node parent) {
        if (parent.isAssign()) {
            String qname = parent.getFirstChild().getQualifiedName();
            return qname != null && this.isIdName(qname);
        }
        if (parent.isName()) {
            Node grandParent = parent.getParent();
            if (grandParent != null && grandParent.isVar()) {
                String name = parent.getString();
                return this.isIdName(name);
            }
            return false;
        }
        return false;
    }

    private boolean isIdName(String name) {
        return name.endsWith("ID") || name.endsWith("ID_");
    }
}

