/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DiagnosticType;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.rhino.JSDocInfo;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

final class CheckGlobalThis
implements NodeTraversal.Callback {
    static final DiagnosticType GLOBAL_THIS = DiagnosticType.warning("JSC_USED_GLOBAL_THIS", "dangerous use of the global 'this' object");
    private final AbstractCompiler compiler;
    private Node assignLhsChild = null;

    CheckGlobalThis(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isFunction()) {
            JSDocInfo maybeLends;
            JSDocInfo jsDoc = this.getFunctionJsDocInfo(n);
            if (jsDoc != null && (jsDoc.isConstructor() || jsDoc.isInterface() || jsDoc.hasThisType() || jsDoc.isOverride())) {
                return false;
            }
            int pType = parent.getType();
            if (pType != 125 && pType != 132 && pType != 38 && pType != 86 && pType != 40) {
                return false;
            }
            Node gramps = parent.getParent();
            if (NodeUtil.isObjectLitKey(parent, gramps) && (maybeLends = gramps.getJSDocInfo()) != null && maybeLends.getLendsName() != null && maybeLends.getLendsName().endsWith(".prototype")) {
                return false;
            }
        }
        if (parent != null && parent.isAssign()) {
            Node lhs = parent.getFirstChild();
            Node rhs = lhs.getNext();
            if (n == lhs) {
                if (this.assignLhsChild == null) {
                    this.assignLhsChild = lhs;
                }
            } else if (NodeUtil.isGet(lhs)) {
                if (lhs.isGetProp() && lhs.getLastChild().getString().equals("prototype")) {
                    return false;
                }
                Node llhs = lhs.getFirstChild();
                if (llhs.isGetProp() && llhs.getLastChild().getString().equals("prototype")) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isThis() && this.shouldReportThis(n, parent)) {
            this.compiler.report(t.makeError(n, GLOBAL_THIS, new String[0]));
        }
        if (n == this.assignLhsChild) {
            this.assignLhsChild = null;
        }
    }

    private boolean shouldReportThis(Node n, Node parent) {
        if (this.assignLhsChild != null) {
            return true;
        }
        return parent != null && NodeUtil.isGet(parent);
    }

    private JSDocInfo getFunctionJsDocInfo(Node n) {
        Node gramps;
        int parentType;
        JSDocInfo jsDoc = n.getJSDocInfo();
        Node parent = n.getParent();
        if (jsDoc == null && ((parentType = parent.getType()) == 38 || parentType == 86) && (jsDoc = parent.getJSDocInfo()) == null && parentType == 38 && (gramps = parent.getParent()).isVar()) {
            jsDoc = gramps.getJSDocInfo();
        }
        return jsDoc;
    }
}

