/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.HashMultimap;
import closurecompiler.internal.com.google.common.collect.Multimap;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.DiagnosticType;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.HotSwapCompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.Scope;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.TypeValidator;
import org.jetbrains.jet.internal.com.google.javascript.rhino.JSDocInfo;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.FunctionType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.JSType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.ObjectType;
import org.jetbrains.jet.internal.com.google.javascript.rhino.jstype.StaticSourceFile;

class CheckAccessControls
implements HotSwapCompilerPass,
NodeTraversal.ScopedCallback {
    static final DiagnosticType DEPRECATED_NAME = DiagnosticType.disabled("JSC_DEPRECATED_VAR", "Variable {0} has been deprecated.");
    static final DiagnosticType DEPRECATED_NAME_REASON = DiagnosticType.disabled("JSC_DEPRECATED_VAR_REASON", "Variable {0} has been deprecated: {1}");
    static final DiagnosticType DEPRECATED_PROP = DiagnosticType.disabled("JSC_DEPRECATED_PROP", "Property {0} of type {1} has been deprecated.");
    static final DiagnosticType DEPRECATED_PROP_REASON = DiagnosticType.disabled("JSC_DEPRECATED_PROP_REASON", "Property {0} of type {1} has been deprecated: {2}");
    static final DiagnosticType DEPRECATED_CLASS = DiagnosticType.disabled("JSC_DEPRECATED_CLASS", "Class {0} has been deprecated.");
    static final DiagnosticType DEPRECATED_CLASS_REASON = DiagnosticType.disabled("JSC_DEPRECATED_CLASS_REASON", "Class {0} has been deprecated: {1}");
    static final DiagnosticType BAD_PRIVATE_GLOBAL_ACCESS = DiagnosticType.disabled("JSC_BAD_PRIVATE_GLOBAL_ACCESS", "Access to private variable {0} not allowed outside file {1}.");
    static final DiagnosticType BAD_PRIVATE_PROPERTY_ACCESS = DiagnosticType.disabled("JSC_BAD_PRIVATE_PROPERTY_ACCESS", "Access to private property {0} of {1} not allowed here.");
    static final DiagnosticType BAD_PROTECTED_PROPERTY_ACCESS = DiagnosticType.disabled("JSC_BAD_PROTECTED_PROPERTY_ACCESS", "Access to protected property {0} of {1} not allowed here.");
    static final DiagnosticType PRIVATE_OVERRIDE = DiagnosticType.disabled("JSC_PRIVATE_OVERRIDE", "Overriding private property of {0}.");
    static final DiagnosticType VISIBILITY_MISMATCH = DiagnosticType.disabled("JSC_VISIBILITY_MISMATCH", "Overriding {0} property of {1} with {2} property.");
    static final DiagnosticType CONST_PROPERTY_REASSIGNED_VALUE = DiagnosticType.warning("JSC_CONSTANT_PROPERTY_REASSIGNED_VALUE", "constant property {0} assigned a value more than once");
    static final DiagnosticType CONST_PROPERTY_DELETED = DiagnosticType.warning("JSC_CONSTANT_PROPERTY_DELETED", "constant property {0} cannot be deleted");
    private final AbstractCompiler compiler;
    private final TypeValidator validator;
    private int deprecatedDepth = 0;
    private int methodDepth = 0;
    private JSType currentClass = null;
    private final Multimap<String, String> initializedConstantProperties;

    CheckAccessControls(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.validator = compiler.getTypeValidator();
        this.initializedConstantProperties = HashMultimap.create();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
    }

    @Override
    public void enterScope(NodeTraversal t) {
        if (!t.inGlobalScope()) {
            Node parent;
            Node n = t.getScopeRoot();
            if (CheckAccessControls.isDeprecatedFunction(n, parent = n.getParent())) {
                ++this.deprecatedDepth;
            }
            if (this.methodDepth == 0) {
                this.currentClass = this.getClassOfMethod(n, parent);
            }
            ++this.methodDepth;
        }
    }

    @Override
    public void exitScope(NodeTraversal t) {
        if (!t.inGlobalScope()) {
            Node parent;
            Node n = t.getScopeRoot();
            if (CheckAccessControls.isDeprecatedFunction(n, parent = n.getParent())) {
                --this.deprecatedDepth;
            }
            --this.methodDepth;
            if (this.methodDepth == 0) {
                this.currentClass = null;
            }
        }
    }

    private JSType getClassOfMethod(Node n, Node parent) {
        if (parent.isAssign()) {
            Node lValue = parent.getFirstChild();
            if (NodeUtil.isGet(lValue)) {
                JSType lValueType = lValue.getJSType();
                if (lValueType != null && lValueType.isNominalConstructor()) {
                    return lValueType.toMaybeFunctionType().getInstanceType();
                }
                return this.normalizeClassType(lValue.getFirstChild().getJSType());
            }
            return this.normalizeClassType(lValue.getJSType());
        }
        if (NodeUtil.isFunctionDeclaration(n) || parent.isName()) {
            return this.normalizeClassType(n.getJSType());
        }
        return null;
    }

    private JSType normalizeClassType(JSType type) {
        FunctionType owner;
        if (type == null || type.isUnknownType()) {
            return type;
        }
        if (type.isNominalConstructor()) {
            return type.toMaybeFunctionType().getInstanceType();
        }
        if (type.isFunctionPrototypeType() && (owner = ((ObjectType)type).getOwnerFunction()).isConstructor()) {
            return owner.getInstanceType();
        }
        return type;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 38: {
                this.checkNameDeprecation(t, n, parent);
                this.checkNameVisibility(t, n, parent);
                break;
            }
            case 33: {
                this.checkPropertyDeprecation(t, n, parent);
                this.checkPropertyVisibility(t, n, parent);
                this.checkConstantProperty(t, n);
                break;
            }
            case 30: {
                this.checkConstructorDeprecation(t, n, parent);
            }
        }
    }

    private void checkConstructorDeprecation(NodeTraversal t, Node n, Node parent) {
        String deprecationInfo;
        JSType type = n.getJSType();
        if (type != null && (deprecationInfo = CheckAccessControls.getTypeDeprecationInfo(type)) != null && this.shouldEmitDeprecationWarning(t, n, parent)) {
            if (!deprecationInfo.isEmpty()) {
                this.compiler.report(t.makeError(n, DEPRECATED_CLASS_REASON, type.toString(), deprecationInfo));
            } else {
                this.compiler.report(t.makeError(n, DEPRECATED_CLASS, type.toString()));
            }
        }
    }

    private void checkNameDeprecation(NodeTraversal t, Node n, Node parent) {
        JSDocInfo docInfo;
        if (parent.isFunction() || parent.isVar() || parent.isNew()) {
            return;
        }
        Scope.Var var = t.getScope().getVar(n.getString());
        JSDocInfo jSDocInfo = docInfo = var == null ? null : var.getJSDocInfo();
        if (docInfo != null && docInfo.isDeprecated() && this.shouldEmitDeprecationWarning(t, n, parent)) {
            if (docInfo.getDeprecationReason() != null) {
                this.compiler.report(t.makeError(n, DEPRECATED_NAME_REASON, n.getString(), docInfo.getDeprecationReason()));
            } else {
                this.compiler.report(t.makeError(n, DEPRECATED_NAME, n.getString()));
            }
        }
    }

    private void checkPropertyDeprecation(NodeTraversal t, Node n, Node parent) {
        String deprecationInfo;
        if (parent.isNew()) {
            return;
        }
        ObjectType objectType = ObjectType.cast(CheckAccessControls.dereference(n.getFirstChild().getJSType()));
        String propertyName = n.getLastChild().getString();
        if (objectType != null && (deprecationInfo = CheckAccessControls.getPropertyDeprecationInfo(objectType, propertyName)) != null && this.shouldEmitDeprecationWarning(t, n, parent)) {
            if (!deprecationInfo.isEmpty()) {
                this.compiler.report(t.makeError(n, DEPRECATED_PROP_REASON, propertyName, this.validator.getReadableJSTypeName(n.getFirstChild(), true), deprecationInfo));
            } else {
                this.compiler.report(t.makeError(n, DEPRECATED_PROP, propertyName, this.validator.getReadableJSTypeName(n.getFirstChild(), true)));
            }
        }
    }

    private void checkNameVisibility(NodeTraversal t, Node name, Node parent) {
        JSDocInfo.Visibility visibility;
        JSDocInfo docInfo;
        Scope.Var var = t.getScope().getVar(name.getString());
        if (var != null && (docInfo = var.getJSDocInfo()) != null && (visibility = docInfo.getVisibility()) == JSDocInfo.Visibility.PRIVATE) {
            StaticSourceFile varSrc = var.getSourceFile();
            StaticSourceFile refSrc = name.getStaticSourceFile();
            if (varSrc != null && refSrc != null && !varSrc.getName().equals(refSrc.getName())) {
                if (docInfo.isConstructor() && CheckAccessControls.isValidPrivateConstructorAccess(parent)) {
                    return;
                }
                this.compiler.report(t.makeError(name, BAD_PRIVATE_GLOBAL_ACCESS, name.getString(), varSrc.getName()));
            }
        }
    }

    private void checkConstantProperty(NodeTraversal t, Node getprop) {
        String propertyName;
        Node parent = getprop.getParent();
        boolean isDelete = parent.isDelProp();
        if (!(NodeUtil.isAssignmentOp(parent) && parent.getFirstChild() == getprop || parent.isInc() || parent.isDec() || isDelete)) {
            return;
        }
        ObjectType objectType = ObjectType.cast(CheckAccessControls.dereference(getprop.getFirstChild().getJSType()));
        boolean isConstant = CheckAccessControls.isPropertyDeclaredConstant(objectType, propertyName = getprop.getLastChild().getString());
        if (isConstant) {
            ObjectType prototype;
            if (isDelete) {
                this.compiler.report(t.makeError(getprop, CONST_PROPERTY_DELETED, propertyName));
                return;
            }
            for (ObjectType oType = objectType; oType != null; oType = oType.getImplicitPrototype()) {
                if (!oType.hasReferenceName() || !this.initializedConstantProperties.containsEntry(oType.getReferenceName(), propertyName)) continue;
                this.compiler.report(t.makeError(getprop, CONST_PROPERTY_REASSIGNED_VALUE, propertyName));
                break;
            }
            Preconditions.checkState(objectType.hasReferenceName());
            this.initializedConstantProperties.put(objectType.getReferenceName(), propertyName);
            if (objectType.isInstanceType() && (prototype = objectType.getImplicitPrototype()) != null && prototype.hasProperty(propertyName) && prototype.hasReferenceName()) {
                this.initializedConstantProperties.put(prototype.getReferenceName(), propertyName);
            }
        }
    }

    private void checkPropertyVisibility(NodeTraversal t, Node getprop, Node parent) {
        ObjectType objectType = ObjectType.cast(CheckAccessControls.dereference(getprop.getFirstChild().getJSType()));
        String propertyName = getprop.getLastChild().getString();
        if (objectType != null) {
            boolean isOverride;
            boolean bl = isOverride = parent.getJSDocInfo() != null && parent.isAssign() && parent.getFirstChild() == getprop;
            if (isOverride) {
                objectType = objectType.getImplicitPrototype();
            }
            JSDocInfo docInfo = null;
            while (objectType != null && ((docInfo = objectType.getOwnPropertyJSDocInfo(propertyName)) == null || docInfo.getVisibility() == JSDocInfo.Visibility.INHERITED)) {
                objectType = objectType.getImplicitPrototype();
            }
            if (objectType == null) {
                return;
            }
            String referenceSource = getprop.getSourceFileName();
            String definingSource = docInfo.getSourceName();
            boolean sameInput = referenceSource != null && referenceSource.equals(definingSource);
            JSDocInfo.Visibility visibility = docInfo.getVisibility();
            JSType ownerType = this.normalizeClassType(objectType);
            if (isOverride) {
                JSDocInfo.Visibility overridingVisibility;
                JSDocInfo overridingInfo = parent.getJSDocInfo();
                JSDocInfo.Visibility visibility2 = overridingVisibility = overridingInfo == null ? JSDocInfo.Visibility.INHERITED : overridingInfo.getVisibility();
                if (visibility == JSDocInfo.Visibility.PRIVATE && !sameInput) {
                    this.compiler.report(t.makeError(getprop, PRIVATE_OVERRIDE, objectType.toString()));
                } else if (overridingVisibility != JSDocInfo.Visibility.INHERITED && overridingVisibility != visibility) {
                    this.compiler.report(t.makeError(getprop, VISIBILITY_MISMATCH, visibility.name(), objectType.toString(), overridingVisibility.name()));
                }
            } else {
                if (sameInput) {
                    return;
                }
                if (visibility == JSDocInfo.Visibility.PRIVATE && (this.currentClass == null || ownerType.differsFrom(this.currentClass))) {
                    if (docInfo.isConstructor() && CheckAccessControls.isValidPrivateConstructorAccess(parent)) {
                        return;
                    }
                    this.compiler.report(t.makeError(getprop, BAD_PRIVATE_PROPERTY_ACCESS, propertyName, this.validator.getReadableJSTypeName(getprop.getFirstChild(), true)));
                } else if (!(visibility != JSDocInfo.Visibility.PROTECTED || this.currentClass != null && this.currentClass.isSubtype(ownerType))) {
                    this.compiler.report(t.makeError(getprop, BAD_PROTECTED_PROPERTY_ACCESS, propertyName, this.validator.getReadableJSTypeName(getprop.getFirstChild(), true)));
                }
            }
        }
    }

    private static boolean isValidPrivateConstructorAccess(Node parent) {
        return !parent.isNew();
    }

    private boolean shouldEmitDeprecationWarning(NodeTraversal t, Node n, Node parent) {
        if (!(!t.inGlobalScope() || parent.isCall() && parent.getFirstChild() == n || n.isNew())) {
            return false;
        }
        if (n.isGetProp() && n == parent.getFirstChild() && NodeUtil.isAssignmentOp(parent)) {
            return false;
        }
        return !this.canAccessDeprecatedTypes(t);
    }

    private boolean canAccessDeprecatedTypes(NodeTraversal t) {
        Node scopeRoot = t.getScopeRoot();
        Node scopeRootParent = scopeRoot.getParent();
        return this.deprecatedDepth > 0 || CheckAccessControls.getTypeDeprecationInfo(t.getScope().getTypeOfThis()) != null || scopeRootParent != null && scopeRootParent.isAssign() && CheckAccessControls.getTypeDeprecationInfo(this.getClassOfMethod(scopeRoot, scopeRootParent)) != null;
    }

    private static boolean isDeprecatedFunction(Node n, Node parent) {
        JSType type;
        if (n.isFunction() && (type = n.getJSType()) != null) {
            return CheckAccessControls.getTypeDeprecationInfo(type) != null;
        }
        return false;
    }

    private static String getTypeDeprecationInfo(JSType type) {
        ObjectType implicitProto;
        if (type == null) {
            return null;
        }
        JSDocInfo info = type.getJSDocInfo();
        if (info != null && info.isDeprecated()) {
            if (info.getDeprecationReason() != null) {
                return info.getDeprecationReason();
            }
            return "";
        }
        ObjectType objType = ObjectType.cast(type);
        if (objType != null && (implicitProto = objType.getImplicitPrototype()) != null) {
            return CheckAccessControls.getTypeDeprecationInfo(implicitProto);
        }
        return null;
    }

    private static boolean isPropertyDeclaredConstant(ObjectType objectType, String prop) {
        while (objectType != null && objectType.hasReferenceName()) {
            JSDocInfo docInfo = objectType.getOwnPropertyJSDocInfo(prop);
            if (docInfo != null && docInfo.isConstant()) {
                return true;
            }
            objectType = objectType.getImplicitPrototype();
        }
        return false;
    }

    private static String getPropertyDeprecationInfo(ObjectType type, String prop) {
        JSDocInfo info = type.getOwnPropertyJSDocInfo(prop);
        if (info != null && info.isDeprecated()) {
            if (info.getDeprecationReason() != null) {
                return info.getDeprecationReason();
            }
            return "";
        }
        ObjectType implicitProto = type.getImplicitPrototype();
        if (implicitProto != null) {
            return CheckAccessControls.getPropertyDeprecationInfo(implicitProto, prop);
        }
        return null;
    }

    private static JSType dereference(JSType type) {
        return type == null ? null : type.dereference();
    }
}

