/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.javascript.jscomp;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.ImmutableSet;
import closurecompiler.internal.com.google.common.collect.Lists;
import closurecompiler.internal.com.google.common.collect.Maps;
import closurecompiler.internal.com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.AbstractCompiler;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.CompilerPass;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSModule;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.JSModuleGraph;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.NodeUtil;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.Scope;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.graph.FixedPointGraphTraversal;
import org.jetbrains.jet.internal.com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import org.jetbrains.jet.internal.com.google.javascript.rhino.Node;

class AnalyzePrototypeProperties
implements CompilerPass {
    private final SymbolType PROPERTY = SymbolType.PROPERTY;
    private final SymbolType VAR = SymbolType.VAR;
    private final AbstractCompiler compiler;
    private final boolean canModifyExterns;
    private final boolean anchorUnusedVars;
    private final JSModuleGraph moduleGraph;
    private final JSModule firstModule;
    private static final Set<String> IMPLICITLY_USED_PROPERTIES = ImmutableSet.of("length", "toString", "valueOf");
    private final LinkedDirectedGraph<NameInfo, JSModule> symbolGraph = LinkedDirectedGraph.createWithoutAnnotations();
    private final NameInfo globalNode = new NameInfo("[global]");
    private final NameInfo externNode = new NameInfo("[extern]");
    private final NameInfo anonymousNode = new NameInfo("[anonymous]");
    private final Map<String, NameInfo> propertyNameInfo = Maps.newHashMap();
    private final Map<String, NameInfo> varNameInfo = Maps.newHashMap();

    AnalyzePrototypeProperties(AbstractCompiler compiler, JSModuleGraph moduleGraph, boolean canModifyExterns, boolean anchorUnusedVars) {
        this.compiler = compiler;
        this.moduleGraph = moduleGraph;
        this.canModifyExterns = canModifyExterns;
        this.anchorUnusedVars = anchorUnusedVars;
        this.firstModule = moduleGraph != null ? moduleGraph.getRootModule() : null;
        this.globalNode.markReference(null);
        this.externNode.markReference(null);
        this.symbolGraph.createNode(this.globalNode);
        this.symbolGraph.createNode(this.externNode);
        for (String property : IMPLICITLY_USED_PROPERTIES) {
            NameInfo nameInfo = this.getNameInfoForName(property, this.PROPERTY);
            if (moduleGraph == null) {
                this.symbolGraph.connect(this.externNode, null, nameInfo);
                continue;
            }
            for (JSModule module : moduleGraph.getAllModules()) {
                this.symbolGraph.connect(this.externNode, module, nameInfo);
            }
        }
    }

    @Override
    public void process(Node externRoot, Node root) {
        if (!this.canModifyExterns) {
            NodeTraversal.traverse(this.compiler, externRoot, new ProcessExternProperties());
        }
        NodeTraversal.traverse(this.compiler, root, new ProcessProperties());
        FixedPointGraphTraversal<NameInfo, JSModule> t = FixedPointGraphTraversal.newTraversal(new PropagateReferences());
        t.computeFixedPoint(this.symbolGraph, Sets.newHashSet(this.externNode, this.globalNode));
    }

    public Collection<NameInfo> getAllNameInfo() {
        ArrayList<NameInfo> result = Lists.newArrayList(this.propertyNameInfo.values());
        result.addAll(this.varNameInfo.values());
        return result;
    }

    private NameInfo getNameInfoForName(String name, SymbolType type) {
        Map<String, NameInfo> map;
        Map<String, NameInfo> map2 = map = type == this.PROPERTY ? this.propertyNameInfo : this.varNameInfo;
        if (map.containsKey(name)) {
            return map.get(name);
        }
        NameInfo nameInfo = new NameInfo(name);
        map.put(name, nameInfo);
        this.symbolGraph.createNode(nameInfo);
        return nameInfo;
    }

    class NameInfo {
        final String name;
        private boolean referenced = false;
        private final Deque<Symbol> declarations = new ArrayDeque<Symbol>();
        private JSModule deepestCommonModuleRef = null;
        private boolean readClosureVariables = false;

        NameInfo(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        boolean isReferenced() {
            return this.referenced;
        }

        boolean readsClosureVariables() {
            return this.readClosureVariables;
        }

        boolean markReference(JSModule module) {
            boolean hasChanged = false;
            if (!this.referenced) {
                this.referenced = true;
                hasChanged = true;
            }
            if (AnalyzePrototypeProperties.this.moduleGraph != null) {
                JSModule originalDeepestCommon = this.deepestCommonModuleRef;
                this.deepestCommonModuleRef = this.deepestCommonModuleRef == null ? module : AnalyzePrototypeProperties.this.moduleGraph.getDeepestCommonDependencyInclusive(this.deepestCommonModuleRef, module);
                if (originalDeepestCommon != this.deepestCommonModuleRef) {
                    hasChanged = true;
                }
            }
            return hasChanged;
        }

        JSModule getDeepestCommonModuleRef() {
            return this.deepestCommonModuleRef;
        }

        Deque<Symbol> getDeclarations() {
            return this.declarations;
        }
    }

    private class NameContext {
        final NameInfo name;
        final Scope scope;

        NameContext(NameInfo name, Scope scope) {
            this.name = name;
            this.scope = scope;
        }
    }

    static class LiteralProperty
    implements Property {
        private final Node key;
        private final Node value;
        private final Node map;
        private final Node assign;
        private final Scope.Var rootVar;
        private final JSModule module;

        LiteralProperty(Node key, Node value, Node map, Node assign, Scope.Var rootVar, JSModule module) {
            this.key = key;
            this.value = value;
            this.map = map;
            this.assign = assign;
            this.rootVar = rootVar;
            this.module = module;
        }

        @Override
        public Scope.Var getRootVar() {
            return this.rootVar;
        }

        @Override
        public void remove() {
            this.map.removeChild(this.key);
        }

        @Override
        public Node getPrototype() {
            return this.assign.getFirstChild();
        }

        @Override
        public Node getValue() {
            return this.value;
        }

        @Override
        public JSModule getModule() {
            return this.module;
        }
    }

    static class AssignmentProperty
    implements Property {
        private final Node exprNode;
        private final Scope.Var rootVar;
        private final JSModule module;

        AssignmentProperty(Node node, Scope.Var rootVar, JSModule module) {
            this.exprNode = node;
            this.rootVar = rootVar;
            this.module = module;
        }

        @Override
        public Scope.Var getRootVar() {
            return this.rootVar;
        }

        @Override
        public void remove() {
            NodeUtil.removeChild(this.exprNode.getParent(), this.exprNode);
        }

        @Override
        public Node getPrototype() {
            return this.getAssignNode().getFirstChild().getFirstChild();
        }

        @Override
        public Node getValue() {
            return this.getAssignNode().getLastChild();
        }

        private Node getAssignNode() {
            return this.exprNode.getFirstChild();
        }

        @Override
        public JSModule getModule() {
            return this.module;
        }
    }

    static interface Property
    extends Symbol {
        public Node getPrototype();

        public Node getValue();
    }

    class GlobalFunction
    implements Symbol {
        private final Node nameNode;
        private final Scope.Var var;
        private final JSModule module;

        GlobalFunction(Node nameNode, Scope.Var var, JSModule module) {
            Node parent = nameNode.getParent();
            Preconditions.checkState(parent.isVar() || NodeUtil.isFunctionDeclaration(parent));
            this.nameNode = nameNode;
            this.var = var;
            this.module = module;
        }

        @Override
        public Scope.Var getRootVar() {
            return this.var;
        }

        @Override
        public void remove() {
            Node parent = this.nameNode.getParent();
            if (parent.isFunction() || parent.hasOneChild()) {
                NodeUtil.removeChild(parent.getParent(), parent);
            } else {
                Preconditions.checkState(parent.isVar());
                parent.removeChild(this.nameNode);
            }
        }

        @Override
        public JSModule getModule() {
            return this.module;
        }

        public Node getFunctionNode() {
            Node parent = this.nameNode.getParent();
            if (parent.isFunction()) {
                return parent;
            }
            return this.nameNode.getChildAtIndex(1);
        }
    }

    private static enum SymbolType {
        PROPERTY,
        VAR;

    }

    static interface Symbol {
        public void remove();

        public Scope.Var getRootVar();

        public JSModule getModule();
    }

    private class PropagateReferences
    implements FixedPointGraphTraversal.EdgeCallback<NameInfo, JSModule> {
        private PropagateReferences() {
        }

        @Override
        public boolean traverseEdge(NameInfo start, JSModule edge, NameInfo dest) {
            if (start.isReferenced()) {
                JSModule startModule = start.getDeepestCommonModuleRef();
                if (startModule != null && AnalyzePrototypeProperties.this.moduleGraph.dependsOn(startModule, edge)) {
                    return dest.markReference(startModule);
                }
                return dest.markReference(edge);
            }
            return false;
        }
    }

    private class ProcessExternProperties
    extends NodeTraversal.AbstractPostOrderCallback {
        private ProcessExternProperties() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isGetProp()) {
                AnalyzePrototypeProperties.this.symbolGraph.connect(AnalyzePrototypeProperties.this.externNode, AnalyzePrototypeProperties.this.firstModule, AnalyzePrototypeProperties.this.getNameInfoForName(n.getLastChild().getString(), AnalyzePrototypeProperties.this.PROPERTY));
            }
        }
    }

    private class ProcessProperties
    implements NodeTraversal.ScopedCallback {
        private Stack<NameContext> symbolStack = new Stack();

        private ProcessProperties() {
        }

        @Override
        public void enterScope(NodeTraversal t) {
            Node n = t.getCurrentNode();
            if (n.isFunction()) {
                String propName = this.getPrototypePropertyNameFromRValue(n);
                if (propName != null) {
                    this.symbolStack.push(new NameContext(AnalyzePrototypeProperties.this.getNameInfoForName(propName, AnalyzePrototypeProperties.this.PROPERTY), t.getScope()));
                } else if (this.isGlobalFunctionDeclaration(t, n)) {
                    Node parent = n.getParent();
                    String name = parent.isName() ? parent.getString() : n.getFirstChild().getString();
                    this.symbolStack.push(new NameContext(AnalyzePrototypeProperties.this.getNameInfoForName(name, AnalyzePrototypeProperties.this.VAR), t.getScope()));
                } else {
                    this.symbolStack.push(new NameContext(AnalyzePrototypeProperties.this.anonymousNode, t.getScope()));
                }
            } else {
                Preconditions.checkState(t.inGlobalScope());
                this.symbolStack.push(new NameContext(AnalyzePrototypeProperties.this.globalNode, t.getScope()));
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
            this.symbolStack.pop();
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            String propName = this.processNonFunctionPrototypeAssign(n, parent);
            if (propName != null) {
                this.symbolStack.push(new NameContext(AnalyzePrototypeProperties.this.getNameInfoForName(propName, AnalyzePrototypeProperties.this.PROPERTY), null));
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isGetProp()) {
                String propName = n.getFirstChild().getNext().getString();
                if (n.isQualifiedName()) {
                    if (propName.equals("prototype")) {
                        if (this.processPrototypeRef(t, n)) {
                            return;
                        }
                    } else {
                        String rValueName;
                        if (AnalyzePrototypeProperties.this.compiler.getCodingConvention().isExported(propName)) {
                            this.addGlobalUseOfSymbol(propName, t.getModule(), AnalyzePrototypeProperties.this.PROPERTY);
                            return;
                        }
                        if (n.getParent().isAssign() && n.getNext() != null && (rValueName = this.getPrototypePropertyNameFromRValue(n)) != null) {
                            return;
                        }
                    }
                }
                this.addSymbolUse(propName, t.getModule(), AnalyzePrototypeProperties.this.PROPERTY);
            } else if (n.isObjectLit()) {
                String lValueName = NodeUtil.getBestLValueName(NodeUtil.getBestLValue(n));
                if (lValueName != null && lValueName.endsWith(".prototype")) {
                    return;
                }
                for (Node propNameNode = n.getFirstChild(); propNameNode != null; propNameNode = propNameNode.getNext()) {
                    if (propNameNode.isQuotedString()) continue;
                    this.addSymbolUse(propNameNode.getString(), t.getModule(), AnalyzePrototypeProperties.this.PROPERTY);
                }
            } else if (n.isName()) {
                String name = n.getString();
                Scope.Var var = t.getScope().getVar(name);
                if (var != null) {
                    if (var.isGlobal()) {
                        if (var.getInitialValue() != null && var.getInitialValue().isFunction()) {
                            if (t.inGlobalScope()) {
                                if (!this.processGlobalFunctionDeclaration(t, n, var)) {
                                    this.addGlobalUseOfSymbol(name, t.getModule(), AnalyzePrototypeProperties.this.VAR);
                                }
                            } else {
                                this.addSymbolUse(name, t.getModule(), AnalyzePrototypeProperties.this.VAR);
                            }
                        }
                    } else if (var.getScope() != t.getScope()) {
                        for (int i = this.symbolStack.size() - 1; i >= 0; --i) {
                            NameContext context = (NameContext)this.symbolStack.get(i);
                            if (context.scope != var.getScope()) {
                                context.name.readClosureVariables = true;
                                continue;
                            }
                            break;
                        }
                    }
                }
            }
            if (this.processNonFunctionPrototypeAssign(n, parent) != null) {
                this.symbolStack.pop();
            }
        }

        private void addSymbolUse(String name, JSModule module, SymbolType type) {
            NameInfo info = AnalyzePrototypeProperties.this.getNameInfoForName(name, type);
            Object def = null;
            for (int i = this.symbolStack.size() - 1; i >= 0 && (def = ((NameContext)this.symbolStack.get((int)i)).name) == AnalyzePrototypeProperties.this.anonymousNode; --i) {
            }
            if (!def.equals(info)) {
                AnalyzePrototypeProperties.this.symbolGraph.connect(def, module, info);
            }
        }

        private String processNonFunctionPrototypeAssign(Node n, Node parent) {
            if (this.isAssignRValue(n, parent) && !n.isFunction()) {
                return this.getPrototypePropertyNameFromRValue(n);
            }
            return null;
        }

        private boolean isGlobalFunctionDeclaration(NodeTraversal t, Node n) {
            Scope s = t.getScope();
            if (!(s.isGlobal() || s.getDepth() == 1 && s.getRootNode() == n)) {
                return false;
            }
            return NodeUtil.isFunctionDeclaration(n) || n.isFunction() && n.getParent().isName();
        }

        private boolean isAssignRValue(Node n, Node parent) {
            return parent != null && parent.isAssign() && parent.getFirstChild() != n;
        }

        private String getPrototypePropertyNameFromRValue(Node rValue) {
            Node lValue = NodeUtil.getBestLValue(rValue);
            if (lValue == null || lValue.getParent() == null || lValue.getParent().getParent() == null || !NodeUtil.isObjectLitKey(lValue, lValue.getParent()) && !NodeUtil.isExprAssign(lValue.getParent().getParent())) {
                return null;
            }
            String lValueName = NodeUtil.getBestLValueName(NodeUtil.getBestLValue(rValue));
            if (lValueName == null) {
                return null;
            }
            int lastDot = lValueName.lastIndexOf(46);
            if (lastDot == -1) {
                return null;
            }
            String firstPart = lValueName.substring(0, lastDot);
            if (!firstPart.endsWith(".prototype")) {
                return null;
            }
            return lValueName.substring(lastDot + 1);
        }

        private boolean processGlobalFunctionDeclaration(NodeTraversal t, Node nameNode, Scope.Var v) {
            Node firstChild = nameNode.getFirstChild();
            Node parent = nameNode.getParent();
            if (this.isGlobalFunctionDeclaration(t, parent) || firstChild != null && this.isGlobalFunctionDeclaration(t, firstChild)) {
                String name = nameNode.getString();
                AnalyzePrototypeProperties.this.getNameInfoForName(name, AnalyzePrototypeProperties.this.VAR).getDeclarations().add(new GlobalFunction(nameNode, v, t.getModule()));
                if (AnalyzePrototypeProperties.this.compiler.getCodingConvention().isExported(name) || AnalyzePrototypeProperties.this.anchorUnusedVars) {
                    this.addGlobalUseOfSymbol(name, t.getModule(), AnalyzePrototypeProperties.this.VAR);
                }
                return true;
            }
            return false;
        }

        private boolean processPrototypeRef(NodeTraversal t, Node ref) {
            Node root = NodeUtil.getRootOfQualifiedName(ref);
            Node n = ref.getParent();
            switch (n.getType()) {
                case 33: {
                    Node dest = n.getFirstChild().getNext();
                    Node parent = n.getParent();
                    Node grandParent = parent.getParent();
                    if (!dest.isString() || !NodeUtil.isExprAssign(grandParent) || !NodeUtil.isVarOrSimpleAssignLhs(n, parent)) break;
                    String name = dest.getString();
                    AssignmentProperty prop = new AssignmentProperty(grandParent, this.maybeGetVar(t, root), t.getModule());
                    AnalyzePrototypeProperties.this.getNameInfoForName(name, AnalyzePrototypeProperties.this.PROPERTY).getDeclarations().add(prop);
                    return true;
                }
                case 86: {
                    Node map = n.getFirstChild().getNext();
                    if (!map.isObjectLit()) break;
                    for (Node key = map.getFirstChild(); key != null; key = key.getNext()) {
                        String name = key.getString();
                        LiteralProperty prop = new LiteralProperty(key, key.getFirstChild(), map, n, this.maybeGetVar(t, root), t.getModule());
                        AnalyzePrototypeProperties.this.getNameInfoForName(name, AnalyzePrototypeProperties.this.PROPERTY).getDeclarations().add(prop);
                    }
                    return true;
                }
            }
            return false;
        }

        private Scope.Var maybeGetVar(NodeTraversal t, Node maybeName) {
            return maybeName.isName() ? t.getScope().getVar(maybeName.getString()) : null;
        }

        private void addGlobalUseOfSymbol(String name, JSModule module, SymbolType type) {
            AnalyzePrototypeProperties.this.symbolGraph.connect(AnalyzePrototypeProperties.this.globalNode, module, AnalyzePrototypeProperties.this.getNameInfoForName(name, type));
        }
    }
}

