/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.debugging.sourcemap;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.Lists;
import closurecompiler.internal.com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.Base64;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.FilePosition;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.SourceMapGenerator;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.SourceMapLineDecoder;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.SourceMapSection;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.Util;

public class SourceMapGeneratorV2
implements SourceMapGenerator {
    private boolean validate = false;
    private List<Mapping> mappings = Lists.newArrayList();
    private LinkedHashMap<String, Integer> sourceFileMap = Maps.newLinkedHashMap();
    private LinkedHashMap<String, Integer> originalNameMap = Maps.newLinkedHashMap();
    private String lastSourceFile = null;
    private int lastSourceFileIndex = -1;
    private Mapping lastMapping;
    private FilePosition offsetPosition = new FilePosition(0, 0);
    private FilePosition prefixPosition = new FilePosition(0, 0);

    @Override
    public void reset() {
        this.mappings.clear();
        this.lastMapping = null;
        this.sourceFileMap.clear();
        this.originalNameMap.clear();
        this.lastSourceFile = null;
        this.lastSourceFileIndex = -1;
        this.offsetPosition = new FilePosition(0, 0);
        this.prefixPosition = new FilePosition(0, 0);
    }

    @Override
    public void validate(boolean validate) {
        this.validate = validate;
    }

    @Override
    public void setWrapperPrefix(String prefix) {
        int prefixLine = 0;
        int prefixIndex = 0;
        for (int i = 0; i < prefix.length(); ++i) {
            if (prefix.charAt(i) == '\n') {
                ++prefixLine;
                prefixIndex = 0;
                continue;
            }
            ++prefixIndex;
        }
        this.prefixPosition = new FilePosition(prefixLine, prefixIndex);
    }

    @Override
    public void setStartingPosition(int offsetLine, int offsetIndex) {
        Preconditions.checkState(offsetLine >= 0);
        Preconditions.checkState(offsetIndex >= 0);
        this.offsetPosition = new FilePosition(offsetLine, offsetIndex);
    }

    @Override
    public void addMapping(String sourceName, String symbolName, FilePosition sourceStartPosition, FilePosition startPosition, FilePosition endPosition) {
        if (sourceName == null || sourceStartPosition.getLine() < 0) {
            return;
        }
        FilePosition adjustedStart = startPosition;
        FilePosition adjustedEnd = endPosition;
        if (this.offsetPosition.getLine() != 0 || this.offsetPosition.getColumn() != 0) {
            int offsetLine = this.offsetPosition.getLine();
            int startOffsetPosition = this.offsetPosition.getColumn();
            int endOffsetPosition = this.offsetPosition.getColumn();
            if (startPosition.getLine() > 0) {
                startOffsetPosition = 0;
            }
            if (endPosition.getLine() > 0) {
                endOffsetPosition = 0;
            }
            adjustedStart = new FilePosition(startPosition.getLine() + offsetLine, startPosition.getColumn() + startOffsetPosition);
            adjustedEnd = new FilePosition(endPosition.getLine() + offsetLine, endPosition.getColumn() + endOffsetPosition);
        }
        Mapping mapping = new Mapping();
        mapping.sourceFile = this.getSourceId(sourceName);
        mapping.originalPosition = sourceStartPosition;
        mapping.originalName = symbolName;
        mapping.startPosition = adjustedStart;
        mapping.endPosition = adjustedEnd;
        if (this.lastMapping != null) {
            int lastLine = this.lastMapping.startPosition.getLine();
            int lastColumn = this.lastMapping.startPosition.getColumn();
            int nextLine = mapping.startPosition.getLine();
            int nextColumn = mapping.startPosition.getColumn();
            Preconditions.checkState(nextLine > lastLine || nextLine == lastLine && nextColumn >= lastColumn, "Incorrect source mappings order, previous : (%s,%s)\nnew : (%s,%s)\nnode : %s", lastLine, lastColumn, nextLine, nextColumn);
        }
        this.lastMapping = mapping;
        this.mappings.add(mapping);
    }

    @Override
    public void appendTo(Appendable out, String name) throws IOException {
        int maxLine = this.prepMappings();
        out.append("{\n");
        SourceMapGeneratorV2.appendFirstField(out, "version", "2");
        SourceMapGeneratorV2.appendField(out, "file", SourceMapGeneratorV2.escapeString(name));
        SourceMapGeneratorV2.appendField(out, "lineCount", String.valueOf(maxLine + 1));
        SourceMapGeneratorV2.appendFieldStart(out, "lineMaps");
        out.append("[");
        new LineMapper(out).appendLineMappings();
        out.append("]");
        SourceMapGeneratorV2.appendFieldEnd(out);
        SourceMapGeneratorV2.appendFieldStart(out, "mappings");
        out.append("[");
        new MappingWriter().appendMappings(out);
        out.append("]");
        SourceMapGeneratorV2.appendFieldEnd(out);
        SourceMapGeneratorV2.appendFieldStart(out, "sources");
        out.append("[");
        this.addSourceNameMap(out);
        out.append("]");
        SourceMapGeneratorV2.appendFieldEnd(out);
        SourceMapGeneratorV2.appendFieldStart(out, "names");
        out.append("[");
        this.addOriginalNameMap(out);
        out.append("]");
        SourceMapGeneratorV2.appendFieldEnd(out);
        out.append("\n}\n");
    }

    private void addSourceNameMap(Appendable out) throws IOException {
        this.addMap(out, this.sourceFileMap);
    }

    private void addOriginalNameMap(Appendable out) throws IOException {
        this.addMap(out, this.originalNameMap);
    }

    private void addMap(Appendable out, Map<String, Integer> map) throws IOException {
        int i = 0;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String key = entry.getKey();
            if (i != 0) {
                out.append(",");
            }
            out.append(SourceMapGeneratorV2.escapeString(key));
            ++i;
        }
    }

    private static String escapeString(String value) {
        return Util.escapeString(value);
    }

    private static void appendFirstField(Appendable out, String name, CharSequence value) throws IOException {
        out.append("\"");
        out.append(name);
        out.append("\"");
        out.append(":");
        out.append(value);
    }

    private static void appendField(Appendable out, String name, CharSequence value) throws IOException {
        out.append(",\n");
        out.append("\"");
        out.append(name);
        out.append("\"");
        out.append(":");
        out.append(value);
    }

    private static void appendFieldStart(Appendable out, String name) throws IOException {
        SourceMapGeneratorV2.appendField(out, name, "");
    }

    private static void appendFieldEnd(Appendable out) throws IOException {
    }

    private int prepMappings() throws IOException {
        new MappingTraversal().traverse(new UsedMappingCheck());
        int id = 0;
        int maxLine = 0;
        for (Mapping m : this.mappings) {
            if (!m.used) continue;
            m.id = id++;
            int endPositionLine = m.endPosition.getLine();
            maxLine = Math.max(maxLine, endPositionLine);
        }
        return maxLine + this.prefixPosition.getLine();
    }

    private int getSourceId(String sourceName) {
        if (sourceName != this.lastSourceFile) {
            this.lastSourceFile = sourceName;
            Integer index = this.sourceFileMap.get(sourceName);
            if (index != null) {
                this.lastSourceFileIndex = index;
            } else {
                this.lastSourceFileIndex = this.sourceFileMap.size();
                this.sourceFileMap.put(sourceName, this.lastSourceFileIndex);
            }
        }
        return this.lastSourceFileIndex;
    }

    private int getNameId(String symbolName) {
        int originalNameIndex;
        Integer index = this.originalNameMap.get(symbolName);
        if (index != null) {
            originalNameIndex = index;
        } else {
            originalNameIndex = this.originalNameMap.size();
            this.originalNameMap.put(symbolName, originalNameIndex);
        }
        return originalNameIndex;
    }

    @Override
    public void appendIndexMapTo(Appendable out, String name, List<SourceMapSection> appSections) {
        throw new UnsupportedOperationException();
    }

    private class MappingTraversal {
        private int line;
        private int col;

        MappingTraversal() {
        }

        void traverse(MappingVisitor v) throws IOException {
            ArrayDeque<Mapping> stack = new ArrayDeque<Mapping>();
            for (Mapping m : SourceMapGeneratorV2.this.mappings) {
                while (!stack.isEmpty() && !this.isOverlapped((Mapping)stack.peek(), m)) {
                    Mapping previous = (Mapping)stack.pop();
                    this.maybeVisit(v, previous);
                }
                Mapping parent = (Mapping)stack.peek();
                this.maybeVisitParent(v, parent, m);
                stack.push(m);
            }
            while (!stack.isEmpty()) {
                Mapping m = (Mapping)stack.pop();
                this.maybeVisit(v, m);
            }
        }

        private int getAdjustedLine(FilePosition p) {
            return p.getLine() + SourceMapGeneratorV2.this.prefixPosition.getLine();
        }

        private int getAdjustedCol(FilePosition p) {
            int rawLine = p.getLine();
            int rawCol = p.getColumn();
            return rawLine != 0 ? rawCol : rawCol + SourceMapGeneratorV2.this.prefixPosition.getColumn();
        }

        private boolean isOverlapped(Mapping m1, Mapping m2) {
            int l1 = m1.endPosition.getLine();
            int l2 = m2.startPosition.getLine();
            int c1 = m1.endPosition.getColumn();
            int c2 = m2.startPosition.getColumn();
            return l1 == l2 && c1 >= c2 || l1 > l2;
        }

        private void maybeVisit(MappingVisitor v, Mapping m) throws IOException {
            int nextLine = this.getAdjustedLine(m.endPosition);
            int nextCol = this.getAdjustedCol(m.endPosition);
            if (this.line < nextLine || this.line == nextLine && this.col < nextCol) {
                this.visit(v, m, nextLine, nextCol);
            }
        }

        private void maybeVisitParent(MappingVisitor v, Mapping parent, Mapping m) throws IOException {
            int nextLine = this.getAdjustedLine(m.startPosition);
            int nextCol = this.getAdjustedCol(m.startPosition);
            Preconditions.checkState(this.line < nextLine || this.col <= nextCol);
            if (this.line < nextLine || this.line == nextLine && this.col < nextCol) {
                this.visit(v, parent, nextLine, nextCol);
            }
        }

        private void visit(MappingVisitor v, Mapping m, int nextLine, int nextCol) throws IOException {
            Preconditions.checkState(this.line <= nextLine);
            Preconditions.checkState(this.line < nextLine || this.col < nextCol);
            if (this.line == nextLine && this.col == nextCol) {
                Preconditions.checkState(false);
                return;
            }
            v.visit(m, this.line, this.col, nextLine, nextCol);
            this.line = nextLine;
            this.col = nextCol;
        }
    }

    private static interface MappingVisitor {
        public void visit(Mapping var1, int var2, int var3, int var4, int var5) throws IOException;
    }

    private class UsedMappingCheck
    implements MappingVisitor {
        private UsedMappingCheck() {
        }

        @Override
        public void visit(Mapping m, int line, int col, int nextLine, int nextCol) throws IOException {
            if (m != null) {
                m.used = true;
            }
        }
    }

    public static class LineMapEncoder {
        public static void encodeEntry(Appendable out, int id, int lastId, int reps) throws IOException {
            Preconditions.checkState(reps > 0);
            int relativeIdLength = LineMapEncoder.getRelativeMappingIdLength(id, lastId);
            int relativeId = LineMapEncoder.getRelativeMappingId(id, relativeIdLength, lastId);
            String relativeIdString = LineMapEncoder.valueToBase64(relativeId, relativeIdLength);
            if (reps > 16 || relativeIdLength > 4) {
                String repsString = LineMapEncoder.valueToBase64(reps - 1, 1);
                for (int i = 0; i < repsString.length(); ++i) {
                    out.append('!');
                }
                String sizeId = LineMapEncoder.valueToBase64(relativeIdString.length() - 1, 1);
                out.append(sizeId);
                out.append(repsString);
            } else {
                int prefix = (reps - 1 << 2) + (relativeIdString.length() - 1);
                Preconditions.checkState(prefix < 64 && prefix >= 0, "prefix (%s) reps(%s) map id size(%s)", prefix, reps, relativeIdString.length());
                out.append(LineMapEncoder.valueToBase64(prefix, 1));
            }
            out.append(relativeIdString);
        }

        public static int getRelativeMappingId(int id, int idLength, int lastId) {
            int base = 1 << idLength * 6;
            int relativeId = id - lastId;
            return relativeId < 0 ? relativeId + base : relativeId;
        }

        public static int getRelativeMappingIdLength(int rawId, int lastId) {
            Preconditions.checkState(rawId >= 0 || rawId == -1);
            int relativeId = rawId - lastId;
            int id = (relativeId < 0 ? Math.abs(relativeId) - 1 : relativeId) << 1;
            int digits = 1;
            for (int base = 64; id >= base; base *= 64) {
                ++digits;
            }
            return digits;
        }

        static String valueToBase64(int value, int minimumSize) {
            int size = 0;
            char[] chars = new char[4];
            do {
                int charValue = value & 0x3F;
                chars[size++] = Base64.toBase64(charValue);
            } while ((value >>>= 6) > 0);
            StringBuilder sb = new StringBuilder(size);
            while (minimumSize > size) {
                sb.append(Base64.toBase64(0));
                --minimumSize;
            }
            while (size > 0) {
                sb.append(chars[--size]);
            }
            return sb.toString();
        }
    }

    private class LineMapper
    implements MappingVisitor {
        private final Appendable out;
        private int lastId = -1;

        LineMapper(Appendable out) {
            this.out = out;
        }

        @Override
        public void visit(Mapping m, int line, int col, int nextLine, int nextCol) throws IOException {
            int id = m != null ? m.id : -1;
            for (int i = line; i <= nextLine; ++i) {
                if (i == nextLine) {
                    this.closeEntry(id, nextCol - col);
                    break;
                }
                this.closeLine(false);
                this.openLine();
                col = 0;
            }
        }

        void appendLineMappings() throws IOException {
            this.openLine();
            new MappingTraversal().traverse(this);
            this.closeLine(true);
        }

        private void openLine() throws IOException {
            this.out.append("\"");
            this.lastId = 0;
        }

        private void closeLine(boolean finalEntry) throws IOException {
            if (finalEntry) {
                this.out.append("\"");
            } else {
                this.out.append("\",\n");
            }
        }

        private void closeEntry(int id, int reps) throws IOException {
            if (reps == 0) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            LineMapEncoder.encodeEntry(sb, id, this.lastId, reps);
            if (SourceMapGeneratorV2.this.validate) {
                SourceMapLineDecoder.LineEntry entry = SourceMapLineDecoder.decodeLineEntry(sb.toString(), this.lastId);
                Preconditions.checkState(entry.id == id && entry.reps == reps, "expected (%s,%s) but got (%s,%s)", id, reps, entry.id, entry.reps);
            }
            this.out.append(sb);
            this.lastId = id;
        }
    }

    private class MappingWriter {
        private int lastLine = 0;
        private String lastLineString = String.valueOf(0);

        private MappingWriter() {
        }

        private void appendMappingTo(Mapping m, Appendable out) throws IOException {
            out.append("[");
            out.append(String.valueOf(m.sourceFile));
            out.append(",");
            int line = m.originalPosition.getLine();
            if (line != this.lastLine) {
                this.lastLineString = String.valueOf(line);
            }
            String lineValue = this.lastLineString;
            out.append(lineValue);
            out.append(",");
            out.append(String.valueOf(m.originalPosition.getColumn()));
            if (m.originalName != null) {
                out.append(",");
                out.append(String.valueOf(SourceMapGeneratorV2.this.getNameId(m.originalName)));
            }
            out.append("],\n");
        }

        void appendMappings(Appendable out) throws IOException {
            for (Mapping m : SourceMapGeneratorV2.this.mappings) {
                if (!m.used) continue;
                this.appendMappingTo(m, out);
            }
        }
    }

    static class Mapping {
        int id = -1;
        int sourceFile;
        FilePosition originalPosition;
        FilePosition startPosition;
        FilePosition endPosition;
        String originalName;
        boolean used = false;

        Mapping() {
        }
    }
}

