/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.debugging.sourcemap;

import org.jetbrains.jet.internal.com.google.debugging.sourcemap.SourceMapFormat;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.SourceMapGenerator;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.SourceMapGeneratorV1;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.SourceMapGeneratorV2;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.SourceMapGeneratorV3;

public class SourceMapGeneratorFactory {
    public static SourceMapGenerator getInstance() {
        return SourceMapGeneratorFactory.getInstance(SourceMapFormat.DEFAULT);
    }

    public static SourceMapGenerator getInstance(SourceMapFormat format) {
        switch (format) {
            case V1: {
                return new SourceMapGeneratorV1();
            }
            case V2: {
                return new SourceMapGeneratorV2();
            }
            case DEFAULT: 
            case V3: {
                return new SourceMapGeneratorV3();
            }
        }
        throw new IllegalStateException("unsupported source map format");
    }
}

