/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.debugging.sourcemap;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.collect.Lists;
import closurecompiler.internal.com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.SourceMapConsumer;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.SourceMapLineDecoder;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.SourceMapParseException;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.proto.Mapping;
import org.jetbrains.jet.internal.org.json.JSONArray;
import org.jetbrains.jet.internal.org.json.JSONException;
import org.jetbrains.jet.internal.org.json.JSONObject;

public class SourceMapConsumerV2
implements SourceMapConsumer {
    private Map<Integer, List<Integer>> characterMap = null;
    private JSONArray lineMaps = null;
    private List<Mapping.OriginalMapping> mappings;

    @Override
    public void parse(String contents) throws SourceMapParseException {
        try {
            JSONObject sourceMapRoot = new JSONObject(contents);
            this.parse(sourceMapRoot);
        }
        catch (JSONException ex) {
            throw new SourceMapParseException("JSON parse exception: " + ex);
        }
    }

    public void parse(JSONObject sourceMapRoot) throws SourceMapParseException {
        try {
            this.parseInternal(sourceMapRoot);
        }
        catch (JSONException ex) {
            throw new SourceMapParseException("JSON parse exception: " + ex);
        }
    }

    private void parseInternal(JSONObject sourceMapRoot) throws JSONException, SourceMapParseException {
        int version = sourceMapRoot.getInt("version");
        if (version != 2) {
            throw new SourceMapParseException("Unknown version: " + version);
        }
        String file = sourceMapRoot.getString("file");
        if (file.isEmpty()) {
            throw new SourceMapParseException("File entry is missing or empty");
        }
        int lineCount = sourceMapRoot.getInt("lineCount");
        this.lineMaps = sourceMapRoot.getJSONArray("lineMaps");
        if (lineCount != this.lineMaps.length()) {
            throw new SourceMapParseException("lineMaps length does not match lineCount");
        }
        this.characterMap = Maps.newHashMap();
        JSONArray sources = sourceMapRoot.getJSONArray("sources");
        JSONArray names = sourceMapRoot.has("names") ? sourceMapRoot.getJSONArray("names") : null;
        JSONArray jsonMappings = sourceMapRoot.getJSONArray("mappings");
        this.mappings = Lists.newArrayListWithCapacity(lineCount);
        for (int i = 0; i < jsonMappings.length(); ++i) {
            JSONArray entry = jsonMappings.getJSONArray(i);
            String name = entry.optString(3, "");
            if (names != null) {
                try {
                    int nameIndex = entry.getInt(3);
                    name = names.getString(nameIndex);
                }
                catch (JSONException nameIndex) {
                    // empty catch block
                }
            }
            String sourceFile = sources.getString(entry.getInt(0));
            int lineNumber = entry.getInt(1);
            int column = entry.getInt(2);
            Mapping.OriginalMapping.Builder builder = Mapping.OriginalMapping.newBuilder().setOriginalFile(sourceFile).setLineNumber(lineNumber).setColumnPosition(column).setIdentifier(name);
            this.mappings.add(builder.build());
        }
    }

    @Override
    public Mapping.OriginalMapping getMappingForLine(int lineNumber, int columnIndex) {
        List<Integer> map;
        --columnIndex;
        if (--lineNumber >= this.lineMaps.length()) {
            return null;
        }
        Preconditions.checkState(lineNumber >= 0, "Line number must be >= 0");
        Preconditions.checkState(columnIndex >= 0, "Column index must be >= 0");
        if (!this.characterMap.containsKey(lineNumber)) {
            try {
                this.characterMap.put(lineNumber, SourceMapLineDecoder.decodeLine(this.lineMaps.getString(lineNumber)));
            }
            catch (JSONException jse) {
                throw new IllegalStateException("JSON exception when retrieving line map", jse);
            }
        }
        if ((map = this.characterMap.get(lineNumber)) == null || map.size() <= columnIndex) {
            return null;
        }
        int index = map.get(columnIndex);
        if (index == -1) {
            return null;
        }
        Preconditions.checkState(index < this.mappings.size(), "Invalid mapping reference");
        return this.mappings.get(index);
    }
}

