/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.debugging.sourcemap;

import org.jetbrains.jet.internal.com.google.debugging.sourcemap.SourceMapConsumerV1;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.SourceMapConsumerV2;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.SourceMapConsumerV3;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.SourceMapParseException;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.SourceMapSupplier;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.SourceMapping;
import org.jetbrains.jet.internal.org.json.JSONException;
import org.jetbrains.jet.internal.org.json.JSONObject;

public class SourceMapConsumerFactory {
    private SourceMapConsumerFactory() {
    }

    public static SourceMapping parse(String contents) throws SourceMapParseException {
        return SourceMapConsumerFactory.parse(contents, null);
    }

    public static SourceMapping parse(String contents, SourceMapSupplier supplier) throws SourceMapParseException {
        if (contents.startsWith("/** Begin line maps. **/")) {
            SourceMapConsumerV1 consumer = new SourceMapConsumerV1();
            consumer.parse(contents);
            return consumer;
        }
        if (contents.startsWith("{")) {
            try {
                JSONObject sourceMapRoot = new JSONObject(contents);
                int version = sourceMapRoot.getInt("version");
                switch (version) {
                    case 2: {
                        SourceMapConsumerV2 consumer = new SourceMapConsumerV2();
                        consumer.parse(sourceMapRoot);
                        return consumer;
                    }
                    case 3: {
                        SourceMapConsumerV3 consumer = new SourceMapConsumerV3();
                        consumer.parse(sourceMapRoot, supplier);
                        return consumer;
                    }
                }
                throw new SourceMapParseException("Unknown source map version:" + version);
            }
            catch (JSONException ex) {
                throw new SourceMapParseException("JSON parse exception: " + ex);
            }
        }
        throw new SourceMapParseException("unable to detect source map format");
    }
}

