/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.debugging.sourcemap;

import java.io.IOException;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.Base64;

final class Base64VLQ {
    private Base64VLQ() {
    }

    private static int toVLQSigned(int value) {
        if (value < 0) {
            return (-value << 1) + 1;
        }
        return (value << 1) + 0;
    }

    private static int fromVLQSigned(int value) {
        boolean negate = (value & 1) == 1;
        return negate ? -value : (value >>= 1);
    }

    public static void encode(Appendable out, int value) throws IOException {
        value = Base64VLQ.toVLQSigned(value);
        do {
            int digit = value & 0x1F;
            if ((value >>>= 5) > 0) {
                digit |= 0x20;
            }
            out.append(Base64.toBase64(digit));
        } while (value > 0);
    }

    public static int decode(CharIterator in) {
        boolean continuation;
        int result = 0;
        int shift = 0;
        do {
            char c;
            int digit;
            continuation = ((digit = Base64.fromBase64(c = in.next())) & 0x20) != 0;
            result += (digit &= 0x1F) << shift;
            shift += 5;
        } while (continuation);
        return Base64VLQ.fromVLQSigned(result);
    }

    static interface CharIterator {
        public boolean hasNext();

        public char next();
    }
}

