/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.runner;

import java.io.PrintStream;
import java.lang.reflect.Member;
import org.jetbrains.jet.internal.com.google.dart.runner.JavaScriptLauncher;
import org.jetbrains.jet.internal.com.google.dart.runner.RunnerError;
import org.jetbrains.jet.internal.com.google.dart.runner.RunnerOptions;
import org.jetbrains.jet.internal.org.mozilla.javascript.Context;
import org.jetbrains.jet.internal.org.mozilla.javascript.Function;
import org.jetbrains.jet.internal.org.mozilla.javascript.FunctionObject;
import org.jetbrains.jet.internal.org.mozilla.javascript.RhinoException;
import org.jetbrains.jet.internal.org.mozilla.javascript.Scriptable;
import org.jetbrains.jet.internal.org.mozilla.javascript.ScriptableObject;
import org.jetbrains.jet.internal.org.mozilla.javascript.Undefined;

public class RhinoLauncher
implements JavaScriptLauncher {
    @Override
    public void execute(String jsScript, String sourceName, String[] args, RunnerOptions options, PrintStream stdout, PrintStream stderr) throws RunnerError {
        try {
            Context ctx = Context.enter();
            ScriptableObject scope = ctx.initStandardObjects();
            scope.put("assert", (Scriptable)scope, (Object)new AssertFunction());
            scope.put("native_Expect__throwException", (Scriptable)scope, (Object)new ThrowException("Expect__throwException", ThrowException.class.getMethod("throwException", Object.class), scope));
            scope.put("write", (Scriptable)scope, (Object)new Write("write", Write.class.getMethod("write", Object.class), scope, stderr));
            scope.put("arguments", (Scriptable)scope, Context.javaToJS(args, scope));
            ctx.evaluateString(scope, jsScript, sourceName, 1, null);
        }
        catch (NoSuchMethodException e) {
            throw new RunnerError(e);
        }
        catch (RhinoException e) {
            if (options.verbose()) {
                stdout.println(jsScript);
                stdout.flush();
            }
            StringBuffer msg = new StringBuffer();
            msg.append(e.sourceName());
            msg.append(" (" + e.lineNumber() + ":" + e.columnNumber() + ")");
            msg.append(" : " + e.details());
            stderr.println(msg.toString());
            throw e;
        }
        finally {
            Context.exit();
        }
    }

    private static abstract class SimpleFunction
    implements Function {
        private SimpleFunction() {
        }

        @Override
        public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
            return null;
        }

        @Override
        public void delete(int index) {
        }

        @Override
        public void delete(String name) {
        }

        @Override
        public Object get(int index, Scriptable start) {
            return null;
        }

        @Override
        public Object get(String name, Scriptable start) {
            return null;
        }

        @Override
        public String getClassName() {
            return "Function";
        }

        @Override
        public Object getDefaultValue(Class<?> hint) {
            return null;
        }

        @Override
        public Object[] getIds() {
            return null;
        }

        @Override
        public Scriptable getParentScope() {
            return null;
        }

        @Override
        public Scriptable getPrototype() {
            return null;
        }

        @Override
        public boolean has(int index, Scriptable start) {
            return false;
        }

        @Override
        public boolean has(String name, Scriptable start) {
            return false;
        }

        @Override
        public boolean hasInstance(Scriptable instance) {
            return false;
        }

        @Override
        public void put(int index, Scriptable start, Object value) {
        }

        @Override
        public void put(String name, Scriptable start, Object value) {
        }

        @Override
        public void setParentScope(Scriptable parent) {
        }

        @Override
        public void setPrototype(Scriptable prototype) {
        }
    }

    public static class Write
    extends FunctionObject {
        private PrintStream out;

        public Write(String name, Member methodOrConstructor, Scriptable scope, PrintStream out) {
            super(name, methodOrConstructor, scope);
            this.out = out;
        }

        @Override
        public Object call(Context ctx, Scriptable scope, Scriptable thisObj, Object[] args) {
            this.write(args[0]);
            return Undefined.instance;
        }

        public void write(Object arg0) {
            this.out.print(arg0);
        }
    }

    public static class ThrowException
    extends FunctionObject {
        public ThrowException(String name, Member methodOrConstructor, Scriptable scope) {
            super(name, methodOrConstructor, scope);
        }

        @Override
        public Object call(Context ctx, Scriptable scope, Scriptable thisObj, Object[] args) {
            if (args.length != 1) {
                Context.reportError("Invalid call to Expect_throwException(e)");
            }
            this.throwException(args[0]);
            return Undefined.instance;
        }

        public void throwException(Object arg0) {
            Context.reportError(arg0.toString());
        }
    }

    private static class AssertFunction
    extends SimpleFunction {
        private AssertFunction() {
        }

        @Override
        public Object call(Context ctx, Scriptable scope, Scriptable thisObj, Object[] args) {
            if (args.length < 1 || args.length > 2) {
                Context.reportError("Invalid call to assertThat(" + args + ")");
            }
            if (!(args[0] instanceof Boolean)) {
                Context.reportError("Argument 0 must be of type boolean");
            }
            if (args.length == 2 && !(args[1] instanceof String)) {
                Context.reportError("Argument 1 must be of type String");
            }
            if (!((Boolean)args[0]).booleanValue()) {
                Context.reportError("assert() failed" + (args.length == 2 ? ": " + args[1] : ""));
            }
            return null;
        }
    }
}

