/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.util;

import java.io.PrintWriter;
import java.util.Arrays;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.TextOutput;

public abstract class AbstractTextOutput
implements TextOutput {
    private final boolean compact;
    private int identLevel = 0;
    private int indentGranularity = 2;
    private char[][] indents = new char[][]{new char[0]};
    private boolean justNewlined;
    private PrintWriter out;
    private int position = 0;
    private int line = 0;
    private int column = 0;

    protected AbstractTextOutput(boolean compact) {
        this.compact = compact;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public void indentIn() {
        ++this.identLevel;
        if (this.identLevel >= this.indents.length) {
            char[] newIndentLevel = new char[this.identLevel * this.indentGranularity];
            Arrays.fill(newIndentLevel, ' ');
            char[][] newIndents = new char[this.indents.length + 1][];
            System.arraycopy(this.indents, 0, newIndents, 0, this.indents.length);
            newIndents[this.identLevel] = newIndentLevel;
            this.indents = newIndents;
        }
    }

    @Override
    public void indentOut() {
        --this.identLevel;
    }

    @Override
    public void newline() {
        this.out.print('\n');
        ++this.position;
        ++this.line;
        this.column = 0;
        this.justNewlined = true;
    }

    @Override
    public void newlineOpt() {
        if (!this.compact) {
            this.newline();
        }
    }

    @Override
    public void print(char c) {
        this.maybeIndent();
        this.out.print(c);
        ++this.position;
        ++this.column;
        this.justNewlined = false;
    }

    @Override
    public void print(char[] s) {
        this.maybeIndent();
        this.printAndCount(s);
        this.justNewlined = false;
    }

    @Override
    public void print(String s) {
        this.maybeIndent();
        this.printAndCount(s.toCharArray());
        this.justNewlined = false;
    }

    @Override
    public void printOpt(char c) {
        if (!this.compact) {
            this.maybeIndent();
            this.out.print(c);
            ++this.position;
            ++this.column;
        }
    }

    @Override
    public void printOpt(char[] s) {
        if (!this.compact) {
            this.maybeIndent();
            this.printAndCount(s);
        }
    }

    @Override
    public void printOpt(String s) {
        if (!this.compact) {
            this.maybeIndent();
            this.printAndCount(s.toCharArray());
        }
    }

    protected void setPrintWriter(PrintWriter out) {
        this.out = out;
    }

    private void maybeIndent() {
        if (this.justNewlined && !this.compact) {
            this.printAndCount(this.indents[this.identLevel]);
            this.justNewlined = false;
        }
    }

    private void printAndCount(char[] chars) {
        this.position += chars.length;
        this.column += chars.length;
        this.out.print(chars);
    }
}

