/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.type;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.jet.internal.com.google.common.annotations.VisibleForTesting;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNewExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartPropertyAccess;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartTypeNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ClassElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.CoreTypeProvider;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Element;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.FunctionAliasElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ResolutionErrorListener;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.TypeVariableElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.VariableElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.DynamicType;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.DynamicTypeImplementation;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.FunctionAliasType;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.FunctionAliasTypeImplementation;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.FunctionType;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.FunctionTypeImplementation;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.InterfaceType;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.InterfaceTypeImplementation;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.Type;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.TypeKind;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.TypeVariable;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.TypeVariableImplementation;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.VoidType;

public class Types {
    private final CoreTypeProvider typeProvider;

    private Types(CoreTypeProvider typeProvider) {
        this.typeProvider = typeProvider;
    }

    public Type leastUpperBound(Type t, Type s) {
        if (this.isSubtype(t, s)) {
            return s;
        }
        if (this.isSubtype(s, t)) {
            return t;
        }
        return this.typeProvider.getDynamicType();
    }

    public InterfaceType getInterfaceType(Type type) {
        switch (type.getKind()) {
            case VARIABLE: {
                TypeVariableElement element = ((TypeVariable)type).getTypeVariableElement();
                if (element.getBound() == null) {
                    return this.typeProvider.getObjectType();
                }
                return this.getInterfaceType(element.getBound());
            }
            case FUNCTION: 
            case FUNCTION_ALIAS: {
                return this.typeProvider.getFunctionType();
            }
            case INTERFACE: {
                return (InterfaceType)type;
            }
        }
        return null;
    }

    public boolean isSubtype(Type t, Type s) {
        if (t.getKind().equals((Object)TypeKind.DYNAMIC)) {
            return true;
        }
        switch (s.getKind()) {
            case DYNAMIC: {
                return true;
            }
            case INTERFACE: {
                return this.isSubtypeOfInterface(t, (InterfaceType)s);
            }
            case FUNCTION_ALIAS: {
                return this.isSubtypeOfAlias(t, (FunctionAliasType)s);
            }
            case FUNCTION: {
                switch (t.getKind()) {
                    case FUNCTION_ALIAS: {
                        return this.isSubtypeOfFunction(this.asFunctionType((FunctionAliasType)t), (FunctionType)s);
                    }
                    case FUNCTION: {
                        return this.isSubtypeOfFunction((FunctionType)t, (FunctionType)s);
                    }
                }
                return false;
            }
            case VARIABLE: {
                return this.isSubtypeOfTypeVariable(t, (TypeVariable)s);
            }
            case VOID: {
                return t.equals(s);
            }
        }
        throw new AssertionError((Object)s.getKind());
    }

    FunctionType asFunctionType(FunctionAliasType alias) {
        FunctionAliasElement element = alias.getElement();
        FunctionType type = (FunctionType)element.getFunctionType().subst(alias.getArguments(), element.getTypeParameters());
        return type;
    }

    private boolean isSubtypeOfAlias(Type t, FunctionAliasType s) {
        if (this.isSubtypeOfInterface(t, s)) {
            return true;
        }
        if (t.getKind().equals((Object)TypeKind.FUNCTION_ALIAS)) {
            return this.isSubtypeOfFunction(this.asFunctionType((FunctionAliasType)t), this.asFunctionType(s));
        }
        return false;
    }

    private boolean isSubtypeOfTypeVariable(Type t, TypeVariable sv) {
        return sv.equals(t);
    }

    private boolean isSubtypeOfInterface(Type t, InterfaceType s) {
        InterfaceType sup = this.asInstanceOf(t, s.getElement());
        if (TypeKind.of(sup).equals((Object)TypeKind.INTERFACE)) {
            InterfaceType ti = sup;
            assert (ti.getElement().equals(s.getElement()));
            if (ti.isRaw() || s.isRaw()) {
                return true;
            }
            return this.areSubtypes(ti.getArguments().iterator(), s.getArguments().iterator());
        }
        return false;
    }

    private boolean isSubtypeOfFunction(FunctionType t, FunctionType s) {
        Type sRest;
        if (s.getKind() == TypeKind.DYNAMIC || t.getKind() == TypeKind.DYNAMIC) {
            return true;
        }
        if (!this.isAssignable(t.getReturnType(), s.getReturnType()) && !s.getReturnType().equals(this.typeProvider.getVoidType())) {
            return false;
        }
        Type tRest = t.getRest();
        if (tRest == null != ((sRest = s.getRest()) == null)) {
            return false;
        }
        if (tRest != null && !this.isAssignable(sRest, tRest)) {
            return false;
        }
        Map<String, Type> tNamed = t.getNamedParameterTypes();
        Map<String, Type> sNamed = s.getNamedParameterTypes();
        if (tNamed.isEmpty() && !sNamed.isEmpty()) {
            return false;
        }
        if (!sNamed.isEmpty()) {
            LinkedHashMap tMap = (LinkedHashMap)tNamed;
            LinkedHashMap sMap = (LinkedHashMap)sNamed;
            Iterator tList = tMap.entrySet().iterator();
            Iterator sList = sMap.entrySet().iterator();
            while (sList.hasNext()) {
                if (!tList.hasNext()) {
                    return false;
                }
                Map.Entry sEntry = sList.next();
                Map.Entry tEntry = tList.next();
                if (!((String)sEntry.getKey()).equals(tEntry.getKey())) {
                    return false;
                }
                if (this.isAssignable((Type)tEntry.getValue(), (Type)sEntry.getValue())) continue;
                return false;
            }
        }
        return this.areAssignable(s.getParameterTypes().iterator(), t.getParameterTypes().iterator());
    }

    private boolean areSubtypes(Iterator<? extends Type> t, Iterator<? extends Type> s) {
        while (t.hasNext() && s.hasNext()) {
            if (this.isSubtype(t.next(), s.next())) continue;
            return false;
        }
        return t.hasNext() == s.hasNext();
    }

    private boolean areAssignable(Iterator<? extends Type> t, Iterator<? extends Type> s) {
        while (t.hasNext() && s.hasNext()) {
            if (this.isAssignable(t.next(), s.next())) continue;
            return false;
        }
        return t.hasNext() == s.hasNext();
    }

    public boolean isAssignable(Type t, Type s) {
        t.getClass();
        s.getClass();
        return this.isSubtype(t, s) || this.isSubtype(s, t);
    }

    @VisibleForTesting
    public InterfaceType asInstanceOf(Type t, ClassElement element) {
        switch (TypeKind.of(t)) {
            case FUNCTION_ALIAS: 
            case INTERFACE: {
                InterfaceType result;
                if (t.getElement().equals(element)) {
                    return (InterfaceType)t;
                }
                InterfaceType ti = (InterfaceType)t;
                ClassElement tElement = ti.getElement();
                InterfaceType supertype = tElement.getSupertype();
                if (supertype != null && (result = this.asInstanceOf(this.asSupertype(ti, supertype), element)) != null) {
                    return result;
                }
                for (InterfaceType intrface : tElement.getInterfaces()) {
                    InterfaceType result2 = this.asInstanceOf(this.asSupertype(ti, intrface), element);
                    if (result2 == null) continue;
                    return result2;
                }
                return null;
            }
            case FUNCTION: {
                Element e = t.getElement();
                switch (e.getKind()) {
                    case CLASS: {
                        InterfaceType ti = (InterfaceType)e.getType();
                        return this.asInstanceOf(ti, element);
                    }
                }
                return null;
            }
            case VARIABLE: {
                TypeVariable v = (TypeVariable)t;
                Type bound = v.getTypeVariableElement().getBound();
                return this.asInstanceOf(bound, element);
            }
        }
        return null;
    }

    private InterfaceType asSupertype(InterfaceType type, InterfaceType supertype) {
        if (supertype == null) {
            return null;
        }
        if (type.isRaw()) {
            return supertype.asRawType();
        }
        List<? extends Type> arguments = type.getArguments();
        List<? extends Type> parameters = type.getElement().getTypeParameters();
        return supertype.subst(arguments, parameters);
    }

    static void printTypesOn(StringBuilder sb, List<? extends Type> types, String start, String end) {
        sb.append(start);
        boolean first = true;
        for (Type type : types) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(type);
            first = false;
        }
        sb.append(end);
    }

    public static List<Type> subst(List<? extends Type> types, List<? extends Type> arguments, List<? extends Type> parameters) {
        ArrayList<Type> result = new ArrayList<Type>(types.size());
        for (Type type : types) {
            result.add(type.subst(arguments, parameters));
        }
        return result;
    }

    public static FunctionType makeFunctionType(ResolutionErrorListener listener, ClassElement element, List<VariableElement> parameters, Type returnType) {
        ArrayList<Type> parameterTypes = new ArrayList<Type>(parameters.size());
        LinkedHashMap<String, Type> namedParameterTypes = null;
        Type restParameter = null;
        for (VariableElement parameter : parameters) {
            Type type = parameter.getType();
            if (parameter.isNamed()) {
                if (namedParameterTypes == null) {
                    namedParameterTypes = new LinkedHashMap<String, Type>();
                }
                namedParameterTypes.put(parameter.getName(), type);
                continue;
            }
            parameterTypes.add(type);
        }
        return FunctionTypeImplementation.of(element, parameterTypes, namedParameterTypes, restParameter, returnType);
    }

    public static Types getInstance(CoreTypeProvider typeProvider) {
        return new Types(typeProvider);
    }

    public static InterfaceType interfaceType(ClassElement element, List<? extends Type> arguments) {
        return new InterfaceTypeImplementation(element, arguments);
    }

    public static FunctionAliasType functionAliasType(FunctionAliasElement element, List<TypeVariable> typeVariables) {
        return new FunctionAliasTypeImplementation(element, typeVariables);
    }

    public static TypeVariable typeVariable(TypeVariableElement element) {
        return new TypeVariableImplementation(element);
    }

    public static DynamicType newDynamicType() {
        return new DynamicTypeImplementation();
    }

    public static InterfaceType ensureInterface(Type type) {
        TypeKind kind = TypeKind.of(type);
        switch (kind) {
            case INTERFACE: {
                return (InterfaceType)type;
            }
            case DYNAMIC: 
            case NONE: {
                return null;
            }
        }
        throw new AssertionError((Object)("unexpected kind " + (Object)((Object)kind)));
    }

    public static Type newVoidType() {
        return new VoidType();
    }

    public static DartTypeNode constructorTypeNode(DartNewExpression node) {
        DartNode constructor = node.getConstructor();
        if (constructor instanceof DartPropertyAccess) {
            return (DartTypeNode)((DartPropertyAccess)constructor).getQualifier();
        }
        return (DartTypeNode)constructor;
    }

    public static InterfaceType constructorType(DartNewExpression node) {
        DartTypeNode typeNode = Types.constructorTypeNode(node);
        return (InterfaceType)typeNode.getType();
    }
}

