/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ClassElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Element;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.AbstractType;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.InterfaceType;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.Type;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.TypeKind;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.Types;

class InterfaceTypeImplementation
extends AbstractType
implements InterfaceType {
    private final ClassElement element;
    private final List<? extends Type> arguments;

    InterfaceTypeImplementation(ClassElement element, List<? extends Type> arguments) {
        this.element = element;
        this.arguments = arguments;
    }

    @Override
    public ClassElement getElement() {
        return this.element;
    }

    @Override
    public List<? extends Type> getArguments() {
        return this.arguments;
    }

    public String toString() {
        if (this.getArguments().isEmpty()) {
            return this.getElement().getName();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getElement().getName());
        Types.printTypesOn(sb, this.getArguments(), "<", ">");
        return sb.toString();
    }

    @Override
    public boolean hasDynamicTypeArgs() {
        for (Type type : this.getArguments()) {
            if (type.getKind() != TypeKind.DYNAMIC) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRaw() {
        return this.getArguments().size() != this.getElement().getTypeParameters().size();
    }

    @Override
    public InterfaceType subst(List<? extends Type> arguments, List<? extends Type> parameters) {
        if (arguments.isEmpty() && parameters.isEmpty()) {
            return this;
        }
        List<Type> substitutedArguments = Types.subst(this.getArguments(), arguments, parameters);
        return new InterfaceTypeImplementation(this.getElement(), substitutedArguments);
    }

    public boolean equals(Object obj) {
        if (obj instanceof InterfaceType) {
            InterfaceType other = (InterfaceType)obj;
            return this.getElement().equals(other.getElement()) && ((Object)this.getArguments()).equals(other.getArguments());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 31;
        hashCode += this.getElement().hashCode();
        hashCode += 31 * hashCode + ((Object)this.getArguments()).hashCode();
        return hashCode;
    }

    @Override
    public InterfaceType asRawType() {
        return new InterfaceTypeImplementation(this.getElement(), Arrays.asList(new Type[0]));
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.INTERFACE;
    }

    @Override
    public InterfaceType.Member lookupMember(String name) {
        InterfaceType.Member member;
        Element element = this.getElement().lookupLocalElement(name);
        if (element != null) {
            return new MemberImplementation(this, element);
        }
        InterfaceType supertype = this.getSupertype();
        if (supertype != null && (member = supertype.lookupMember(name)) != null) {
            return member;
        }
        for (InterfaceType intrface : this.getInterfaces()) {
            InterfaceType.Member member2 = intrface.lookupMember(name);
            if (member2 == null) continue;
            return member2;
        }
        return null;
    }

    private InterfaceType getSupertype() {
        InterfaceType supertype = this.getElement().getSupertype();
        if (supertype == null) {
            return null;
        }
        return supertype.subst(this.getArguments(), this.getElement().getTypeParameters());
    }

    private List<InterfaceType> getInterfaces() {
        List<InterfaceType> interfaces = this.getElement().getInterfaces();
        ArrayList<InterfaceType> result = new ArrayList<InterfaceType>(interfaces.size());
        List<? extends Type> typeArguments = this.getArguments();
        List<? extends Type> typeParameters = this.getElement().getTypeParameters();
        for (InterfaceType type : interfaces) {
            result.add(type.subst(typeArguments, typeParameters));
        }
        return result;
    }

    private static class MemberImplementation
    implements InterfaceType.Member {
        private final InterfaceType holder;
        private final Element member;

        MemberImplementation(InterfaceType holder, Element member) {
            this.holder = holder;
            this.member = member;
        }

        @Override
        public InterfaceType getHolder() {
            return this.holder;
        }

        @Override
        public Element getElement() {
            return this.member;
        }

        @Override
        public Type getType() {
            List<? extends Type> typeArguments = this.getHolder().getArguments();
            List<? extends Type> typeParameters = this.getHolder().getElement().getTypeParameters();
            return this.getElement().getType().subst(typeArguments, typeParameters);
        }
    }
}

