/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.testing;

import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartSource;
import org.jetbrains.jet.internal.com.google.dart.compiler.LibrarySource;

public class TestLibrarySource
implements LibrarySource {
    private final String name;
    private URI uri;
    private final Map<String, DartSource> sourceMap = new LinkedHashMap<String, DartSource>();

    public TestLibrarySource(String name) {
        this.name = name;
        this.uri = URI.create(name);
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public Reader getSourceReader() {
        StringBuilder sb = new StringBuilder();
        sb.append("#library('");
        sb.append(this.name);
        sb.append("');\n");
        for (DartSource source : this.sourceMap.values()) {
            sb.append("#source('");
            sb.append(source.getName());
            sb.append("');\n");
        }
        return new StringReader(sb.toString());
    }

    public DartSource addSource(String name, String ... sourceLines) {
        StringBuilder sb = new StringBuilder();
        for (String line : sourceLines) {
            sb.append(line);
            sb.append("\n");
        }
        final String source = sb.toString();
        URI uri = URI.create(name);
        TestDartSource dartSource = new TestDartSource(name, uri){

            @Override
            public Reader getSourceReader() {
                return new StringReader(source);
            }
        };
        return this.sourceMap.put(dartSource.getName(), dartSource);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public DartSource getSourceFor(String relPath) {
        if (!this.name.equals(relPath)) {
            return this.sourceMap.get(relPath);
        }
        return new TestDartSource(this.name, this.uri){

            @Override
            public Reader getSourceReader() {
                return TestLibrarySource.this.getSourceReader();
            }
        };
    }

    @Override
    public LibrarySource getImportFor(String relPath) {
        throw new AssertionError((Object)relPath);
    }

    private abstract class TestDartSource
    implements DartSource {
        private final String srcName;
        private final URI srcUri;

        private TestDartSource(String name, URI uri) {
            this.srcName = name;
            this.srcUri = uri;
        }

        @Override
        public URI getUri() {
            return this.srcUri;
        }

        @Override
        public String getName() {
            return this.srcName;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        @Override
        public LibrarySource getLibrary() {
            return TestLibrarySource.this;
        }

        @Override
        public String getRelativePath() {
            return this.srcName;
        }
    }
}

